/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.noise;

import net.dries007.tfc.world.noise.FastNoiseLite;
import net.dries007.tfc.world.noise.Noise3D;

public class OpenSimplex3D
implements Noise3D {
    final FastNoiseLite fnl;
    private float frequency;
    private float midpoint;
    private float amplitude;

    public OpenSimplex3D(long seed) {
        this((int)(seed ^ seed >> 32));
    }

    public OpenSimplex3D(int seed) {
        this.fnl = new FastNoiseLite(seed);
        this.fnl.SetFrequency(1.0f);
        this.fnl.SetNoiseType(FastNoiseLite.NoiseType.OpenSimplex2S);
        this.fnl.SetFractalOctaves(1);
        this.fnl.SetRotationType3D(FastNoiseLite.RotationType3D.ImproveXZPlanes);
        this.frequency = 1.0f;
        this.midpoint = 0.0f;
        this.amplitude = 1.0f;
    }

    @Override
    public float noise(float x, float y, float z) {
        return this.midpoint + this.fnl.GetNoise(x, y, z) * this.amplitude;
    }

    @Override
    public OpenSimplex3D octaves(int octaves) {
        this.fnl.SetFractalOctaves(octaves);
        this.fnl.SetFractalType(FastNoiseLite.FractalType.FBm);
        return this.spread(1.0f / (float)(1 << octaves - 1));
    }

    @Override
    public OpenSimplex3D spread(float scaleFactor) {
        this.frequency *= scaleFactor;
        this.fnl.SetFrequency(this.frequency);
        return this;
    }

    @Override
    public OpenSimplex3D scaled(float min, float max) {
        return this.scaled(-1.0f, 1.0f, min, max);
    }

    @Override
    public OpenSimplex3D scaled(float oldMin, float oldMax, float min, float max) {
        assert (oldMin == -1.0f && oldMax == 1.0f);
        this.midpoint = (max + min) / 2.0f;
        this.amplitude = (max - min) / 2.0f;
        return this;
    }

    float getAmplitude() {
        return this.amplitude;
    }
}

