/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.noise;

import net.dries007.tfc.world.noise.FastNoiseLite;
import net.dries007.tfc.world.noise.OpenSimplex3D;

@FunctionalInterface
public interface Noise3D {
    public float noise(float var1, float var2, float var3);

    default public Noise3D octaves(int octaves) {
        float[] frequency = new float[octaves];
        float[] amplitude = new float[octaves];
        for (int i = 0; i < octaves; ++i) {
            frequency[i] = 1 << i;
            amplitude[i] = (float)Math.pow(0.5, octaves - i);
        }
        return (x, y, z) -> {
            float value = 0.0f;
            for (int i = 0; i < octaves; ++i) {
                value += this.noise(x / frequency[i], y / frequency[i], z / frequency[i]) * amplitude[i];
            }
            return value;
        };
    }

    default public Noise3D spread(float scaleFactor) {
        return (x, y, z) -> this.noise(x * scaleFactor, y * scaleFactor, z * scaleFactor);
    }

    default public Noise3D scaled(float min, float max) {
        return this.scaled(-1.0f, 1.0f, min, max);
    }

    default public Noise3D scaled(float oldMin, float oldMax, float min, float max) {
        return (x, y, z) -> {
            float value = this.noise(x, y, z);
            return (value - oldMin) / (oldMax - oldMin) * (max - min) + min;
        };
    }

    default public Noise3D warped(OpenSimplex3D warp) {
        warp.fnl.SetDomainWarpType(FastNoiseLite.DomainWarpType.OpenSimplex2);
        warp.fnl.SetFractalType(FastNoiseLite.FractalType.DomainWarpIndependent);
        warp.fnl.SetDomainWarpAmp(warp.getAmplitude() * 2.0f);
        FastNoiseLite.Vector3 cursor = new FastNoiseLite.Vector3(0.0f, 0.0f, 0.0f);
        return (x, y, z) -> {
            cursor.x = x;
            cursor.y = y;
            cursor.z = z;
            warp.fnl.DomainWarp(cursor);
            return this.noise(cursor.x, cursor.y, cursor.z);
        };
    }
}

