/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.noise;

import net.dries007.tfc.util.Helpers;
import net.minecraft.world.level.levelgen.RandomSource;

public class Metaballs3D {
    private final Ball[] balls;

    public static Metaballs3D simple(RandomSource random, int size) {
        return new Metaballs3D(random, 5, 7, 0.1f * (float)size, 0.3f * (float)size, 0.5f * (float)size);
    }

    public Metaballs3D(RandomSource random, int minBalls, int maxBalls, float minSize, float maxSize, float radius) {
        int ballCount = Helpers.uniform(random, minBalls, maxBalls);
        int negativeBallCount = minSize < 0.0f ? (int)((float)ballCount * (-minSize / (maxSize - minSize))) : 0;
        this.balls = new Ball[ballCount];
        for (int i = 0; i < this.balls.length; ++i) {
            this.balls[i] = new Ball(Helpers.triangle(random, radius), Helpers.triangle(random, radius), Helpers.triangle(random, radius), i < negativeBallCount ? Helpers.uniform(random, minSize, 0.0f) : Helpers.uniform(random, 0.0f, maxSize));
        }
    }

    public boolean inside(float x, float y, float z) {
        float f = 0.0f;
        for (Ball ball : this.balls) {
            if (!((f += ball.weight * Math.abs(ball.weight) / ((x - ball.x) * (x - ball.x) + (y - ball.y) * (y - ball.y) + (z - ball.z) * (z - ball.z))) > 1.0f)) continue;
            return true;
        }
        return false;
    }

    record Ball(float x, float y, float z, float weight) {
    }
}

