/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.noise;

import it.unimi.dsi.fastutil.HashCommon;
import net.dries007.tfc.world.noise.FastNoiseLite;
import net.dries007.tfc.world.noise.Noise3D;

public class Cellular3D
implements Noise3D {
    private final int seed;
    private float frequency;

    public Cellular3D(long seed) {
        this.seed = HashCommon.long2int((long)seed);
        this.frequency = 1.0f;
    }

    @Override
    public float noise(float x, float y, float z) {
        return this.cell(x, y, z).noise();
    }

    @Override
    public Cellular3D spread(float scaleFactor) {
        this.frequency *= scaleFactor;
        return this;
    }

    public Cell cell(float x, float y, float z) {
        int xr = FastNoiseLite.FastRound(x *= this.frequency);
        int yr = FastNoiseLite.FastRound(y *= this.frequency);
        int zr = FastNoiseLite.FastRound(z *= this.frequency);
        float distance0 = Float.MAX_VALUE;
        float distance1 = Float.MAX_VALUE;
        int closestHash = 0;
        float closestCenterX = 0.0f;
        float closestCenterY = 0.0f;
        float closestCenterZ = 0.0f;
        float cellularJitter = 0.39614353f;
        int xPrimed = (xr - 1) * 501125321;
        int yPrimedBase = (yr - 1) * 1136930381;
        int zPrimedBase = (zr - 1) * 1720413743;
        for (int xi = xr - 1; xi <= xr + 1; ++xi) {
            int yPrimed = yPrimedBase;
            for (int yi = yr - 1; yi <= yr + 1; ++yi) {
                int zPrimed = zPrimedBase;
                for (int zi = zr - 1; zi <= zr + 1; ++zi) {
                    int hash = FastNoiseLite.Hash(this.seed, xPrimed, yPrimed, zPrimed);
                    int idx = hash & 0x3FC;
                    float vecX = (float)xi + FastNoiseLite.RandVecs3D[idx] * cellularJitter;
                    float vecY = (float)yi + FastNoiseLite.RandVecs3D[idx | 1] * cellularJitter;
                    float vecZ = (float)zi + FastNoiseLite.RandVecs3D[idx | 2] * cellularJitter;
                    float newDistance = (vecX - x) * (vecX - x) + (vecY - y) * (vecY - y) + (vecZ - z) * (vecZ - z);
                    distance1 = FastNoiseLite.FastMax(FastNoiseLite.FastMin(distance1, newDistance), distance0);
                    if (newDistance < distance0) {
                        distance0 = newDistance;
                        closestHash = hash;
                        closestCenterX = vecX;
                        closestCenterY = vecY;
                        closestCenterZ = vecZ;
                    }
                    zPrimed += 1720413743;
                }
                yPrimed += 1136930381;
            }
            xPrimed += 501125321;
        }
        return new Cell(closestCenterX / this.frequency, closestCenterY / this.frequency, closestCenterZ / this.frequency, distance0, distance1, (float)closestHash * 4.656613E-10f);
    }

    public record Cell(float x, float y, float z, float f1, float f2, float noise) {
    }
}

