/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.layer.framework;

import it.unimi.dsi.fastutil.HashCommon;
import java.util.Arrays;
import net.dries007.tfc.world.layer.framework.TypedAreaSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;

public class TypedArea<A> {
    private final TypedAreaSource<A> factory;
    private final long[] keys;
    private final Object[] values;
    private final int mask;

    public TypedArea(TypedAreaSource<A> factory, int maxCacheSize) {
        maxCacheSize = Mth.m_14125_((int)maxCacheSize);
        this.factory = factory;
        this.keys = new long[maxCacheSize];
        this.values = new Object[maxCacheSize];
        this.mask = maxCacheSize - 1;
        Arrays.fill(this.keys, Long.MIN_VALUE);
    }

    public A get(int x, int z) {
        long key = ChunkPos.m_45589_((int)x, (int)z);
        int index = (int)HashCommon.mix((long)key) & this.mask;
        if (this.keys[index] == key) {
            return (A)this.values[index];
        }
        A value = this.factory.apply(x, z);
        this.values[index] = value;
        this.keys[index] = key;
        return value;
    }
}

