/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.layer;

import java.util.Random;
import java.util.function.Supplier;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.IArtist;
import net.dries007.tfc.world.biome.BiomeExtension;
import net.dries007.tfc.world.biome.TFCBiomes;
import net.dries007.tfc.world.chunkdata.ForestType;
import net.dries007.tfc.world.layer.AddLakesLayer;
import net.dries007.tfc.world.layer.ArchipelagoLayer;
import net.dries007.tfc.world.layer.BiasedLandPlateZoomLayer;
import net.dries007.tfc.world.layer.EdgeBiomeLayer;
import net.dries007.tfc.world.layer.ForestEdgeLayer;
import net.dries007.tfc.world.layer.ForestInitLayer;
import net.dries007.tfc.world.layer.ForestRandomizeLayer;
import net.dries007.tfc.world.layer.ForestRandomizeSmallLayer;
import net.dries007.tfc.world.layer.InlandLayer;
import net.dries007.tfc.world.layer.MergeLakeLayer;
import net.dries007.tfc.world.layer.MergeRiverLayer;
import net.dries007.tfc.world.layer.OceanBorderLayer;
import net.dries007.tfc.world.layer.Plate;
import net.dries007.tfc.world.layer.PlateBiomeLayer;
import net.dries007.tfc.world.layer.PlateBoundaryLayer;
import net.dries007.tfc.world.layer.PlateBoundaryModifierLayer;
import net.dries007.tfc.world.layer.PlateGenerationLayer;
import net.dries007.tfc.world.layer.RandomizeNeighborsLayer;
import net.dries007.tfc.world.layer.ReefBorderLayer;
import net.dries007.tfc.world.layer.RegionBiomeLayer;
import net.dries007.tfc.world.layer.RegionEdgeBiomeLayer;
import net.dries007.tfc.world.layer.RegionLayer;
import net.dries007.tfc.world.layer.RegionMergeRiverLayer;
import net.dries007.tfc.world.layer.RockLayer;
import net.dries007.tfc.world.layer.ShoreLayer;
import net.dries007.tfc.world.layer.SmoothLayer;
import net.dries007.tfc.world.layer.TypedZoomLayer;
import net.dries007.tfc.world.layer.UniformLayer;
import net.dries007.tfc.world.layer.ZoomLayer;
import net.dries007.tfc.world.layer.framework.AreaFactory;
import net.dries007.tfc.world.layer.framework.TypedAreaFactory;
import net.dries007.tfc.world.noise.Cellular2D;
import net.dries007.tfc.world.noise.OpenSimplex2D;
import net.dries007.tfc.world.region.Region;
import net.dries007.tfc.world.region.RegionGenerator;
import net.dries007.tfc.world.river.Watershed;
import net.minecraft.world.level.levelgen.RandomSource;
import org.apache.commons.lang3.mutable.MutableInt;

public class TFCLayers {
    public static final int OCEANIC = 0;
    public static final int CONTINENTAL_LOW = 1;
    public static final int CONTINENTAL_MID = 2;
    public static final int CONTINENTAL_HIGH = 3;
    public static final int OCEAN_OCEAN_DIVERGING = 4;
    public static final int OCEAN_OCEAN_CONVERGING_LOWER = 5;
    public static final int OCEAN_OCEAN_CONVERGING_UPPER = 6;
    public static final int OCEAN_CONTINENT_CONVERGING_LOWER = 7;
    public static final int OCEAN_CONTINENT_CONVERGING_UPPER = 8;
    public static final int OCEAN_CONTINENT_DIVERGING = 9;
    public static final int CONTINENT_CONTINENT_DIVERGING = 10;
    public static final int CONTINENT_CONTINENT_CONVERGING = 11;
    public static final int CONTINENTAL_SHELF = 12;
    public static final int FOREST_NONE = ForestType.NONE.ordinal();
    public static final int FOREST_NORMAL = ForestType.NORMAL.ordinal();
    public static final int FOREST_SPARSE = ForestType.SPARSE.ordinal();
    public static final int FOREST_EDGE = ForestType.EDGE.ordinal();
    public static final int FOREST_OLD = ForestType.OLD_GROWTH.ordinal();
    public static final int OCEAN;
    public static final int OCEAN_REEF;
    public static final int DEEP_OCEAN;
    public static final int DEEP_OCEAN_TRENCH;
    public static final int PLAINS;
    public static final int HILLS;
    public static final int LOWLANDS;
    public static final int LOW_CANYONS;
    public static final int ROLLING_HILLS;
    public static final int BADLANDS;
    public static final int INVERTED_BADLANDS;
    public static final int PLATEAU;
    public static final int OLD_MOUNTAINS;
    public static final int MOUNTAINS;
    public static final int VOLCANIC_MOUNTAINS;
    public static final int OCEANIC_MOUNTAINS;
    public static final int VOLCANIC_OCEANIC_MOUNTAINS;
    public static final int CANYONS;
    public static final int SHORE;
    public static final int LAKE;
    public static final int RIVER;
    public static final int MOUNTAIN_RIVER;
    public static final int VOLCANIC_MOUNTAIN_RIVER;
    public static final int OLD_MOUNTAIN_RIVER;
    public static final int OCEANIC_MOUNTAIN_RIVER;
    public static final int VOLCANIC_OCEANIC_MOUNTAIN_RIVER;
    public static final int MOUNTAIN_LAKE;
    public static final int VOLCANIC_MOUNTAIN_LAKE;
    public static final int OLD_MOUNTAIN_LAKE;
    public static final int OCEANIC_MOUNTAIN_LAKE;
    public static final int VOLCANIC_OCEANIC_MOUNTAIN_LAKE;
    public static final int PLATEAU_LAKE;
    public static final int OCEAN_OCEAN_CONVERGING_MARKER;
    public static final int OCEAN_OCEAN_DIVERGING_MARKER;
    public static final int LAKE_MARKER;
    public static final int NULL_MARKER;
    public static final int INLAND_MARKER;
    public static final int OCEAN_REEF_MARKER;
    private static final BiomeExtension[] BIOME_LAYERS;
    private static final MutableInt BIOME_LAYER_INDEX;

    public static BiomeExtension getFromLayerId(int id) {
        BiomeExtension v = BIOME_LAYERS[id];
        if (v == null) {
            throw new NullPointerException("Layer id = " + id + " returned null!");
        }
        return v;
    }

    public static AreaFactory createOverworldBiomeLayer(long seed, IArtist<TypedAreaFactory<Plate>> plateArtist, IArtist<AreaFactory> layerArtist) {
        Random random = new Random(seed);
        TypedAreaFactory<Plate> plateLayer = new PlateGenerationLayer(new Cellular2D(random.nextInt()).spread(0.2f), 40).apply(random.nextLong());
        plateArtist.draw("plate_generation", 1, plateLayer);
        plateLayer = TypedZoomLayer.fuzzy().apply(random.nextLong(), plateLayer);
        plateArtist.draw("plate_generation", 2, plateLayer);
        AreaFactory mainLayer = PlateBoundaryLayer.INSTANCE.apply(random.nextLong(), plateLayer);
        layerArtist.draw("plate_boundary", 1, mainLayer);
        mainLayer = SmoothLayer.INSTANCE.apply(random.nextLong(), mainLayer);
        layerArtist.draw("plate_boundary", 2, mainLayer);
        mainLayer = PlateBoundaryModifierLayer.INSTANCE.apply(random.nextLong(), mainLayer);
        layerArtist.draw("plate_boundary", 3, mainLayer);
        mainLayer = PlateBiomeLayer.INSTANCE.apply(random.nextLong(), mainLayer);
        layerArtist.draw("biomes", 1, mainLayer);
        AreaFactory lakeLayer = InlandLayer.INSTANCE.apply(random.nextLong(), mainLayer);
        layerArtist.draw("lake", 1, lakeLayer);
        lakeLayer = ZoomLayer.NORMAL.apply(1001L, lakeLayer);
        layerArtist.draw("lake", 2, lakeLayer);
        lakeLayer = AddLakesLayer.LARGE.apply(random.nextLong(), lakeLayer);
        layerArtist.draw("lake", 3, lakeLayer);
        lakeLayer = ZoomLayer.NORMAL.apply(1002L, lakeLayer);
        layerArtist.draw("lake", 4, lakeLayer);
        lakeLayer = AddLakesLayer.SMALL.apply(random.nextLong(), lakeLayer);
        layerArtist.draw("lake", 5, lakeLayer);
        lakeLayer = ZoomLayer.NORMAL.apply(1003L, lakeLayer);
        layerArtist.draw("lake", 6, lakeLayer);
        mainLayer = OceanBorderLayer.INSTANCE.apply(random.nextLong(), mainLayer);
        layerArtist.draw("biomes", 2, mainLayer);
        mainLayer = ZoomLayer.NORMAL.apply(1001L, mainLayer);
        layerArtist.draw("biomes", 3, mainLayer);
        mainLayer = ArchipelagoLayer.INSTANCE.apply(random.nextLong(), mainLayer);
        layerArtist.draw("biomes", 4, mainLayer);
        mainLayer = ReefBorderLayer.INSTANCE.apply(random.nextLong(), mainLayer);
        layerArtist.draw("biomes", 5, mainLayer);
        mainLayer = ZoomLayer.NORMAL.apply(1002L, mainLayer);
        layerArtist.draw("biomes", 6, mainLayer);
        mainLayer = EdgeBiomeLayer.INSTANCE.apply(random.nextLong(), mainLayer);
        layerArtist.draw("biomes", 7, mainLayer);
        mainLayer = ZoomLayer.NORMAL.apply(1003L, mainLayer);
        layerArtist.draw("biomes", 8, mainLayer);
        mainLayer = MergeLakeLayer.INSTANCE.apply(random.nextLong(), mainLayer, lakeLayer);
        layerArtist.draw("biomes", 9, mainLayer);
        mainLayer = ShoreLayer.INSTANCE.apply(random.nextLong(), mainLayer);
        layerArtist.draw("biomes", 10, mainLayer);
        for (int i = 0; i < 4; ++i) {
            mainLayer = ZoomLayer.NORMAL.apply(random.nextLong(), mainLayer);
            layerArtist.draw("biomes", 11 + i, mainLayer);
        }
        mainLayer = SmoothLayer.INSTANCE.apply(random.nextLong(), mainLayer);
        layerArtist.draw("biomes", 15, mainLayer);
        return mainLayer;
    }

    public static AreaFactory createOverworldBiomeLayerWithRivers(long seed, Watershed.Context watersheds, IArtist<TypedAreaFactory<Plate>> plateArtist, IArtist<AreaFactory> layerArtist) {
        return new MergeRiverLayer(watersheds).apply(seed, TFCLayers.createOverworldBiomeLayer(seed, plateArtist, layerArtist));
    }

    public static AreaFactory createOverworldForestLayer(long seed, IArtist<AreaFactory> artist) {
        Random random = new Random(seed);
        AreaFactory layer = new ForestInitLayer(new OpenSimplex2D(random.nextInt()).spread(0.3f)).apply(random.nextLong());
        artist.draw("forest", 1, layer);
        layer = ForestRandomizeLayer.INSTANCE.apply(random.nextLong(), layer);
        artist.draw("forest", 2, layer);
        layer = ZoomLayer.FUZZY.apply(random.nextLong(), layer);
        artist.draw("forest", 3, layer);
        layer = ForestRandomizeLayer.INSTANCE.apply(random.nextLong(), layer);
        artist.draw("forest", 4, layer);
        layer = ZoomLayer.FUZZY.apply(random.nextLong(), layer);
        artist.draw("forest", 5, layer);
        layer = ZoomLayer.NORMAL.apply(random.nextLong(), layer);
        artist.draw("forest", 6, layer);
        layer = ForestEdgeLayer.INSTANCE.apply(random.nextLong(), layer);
        artist.draw("forest", 7, layer);
        layer = ForestRandomizeSmallLayer.INSTANCE.apply(random.nextLong(), layer);
        artist.draw("forest", 8, layer);
        for (int i = 0; i < 2; ++i) {
            layer = ZoomLayer.NORMAL.apply(random.nextLong(), layer);
            artist.draw("forest", 9 + i, layer);
        }
        return layer;
    }

    public static TypedAreaFactory<Plate> createEarlyPlateLayers(long seed) {
        Random random = new Random(seed);
        TypedAreaFactory<Plate> plateLayer = new PlateGenerationLayer(new Cellular2D(random.nextInt()).spread(0.2f), 40).apply(random.nextLong());
        plateLayer = BiasedLandPlateZoomLayer.INSTANCE.apply(random.nextLong(), plateLayer);
        return plateLayer;
    }

    public static AreaFactory createOverworldPlateTectonicInfoLayer(long seed) {
        Random random = new Random(seed);
        TypedAreaFactory<Plate> plateLayer = new PlateGenerationLayer(new Cellular2D(random.nextInt()).spread(0.2f), 40).apply(random.nextLong());
        plateLayer = TypedZoomLayer.fuzzy().apply(random.nextLong(), plateLayer);
        AreaFactory mainLayer = PlateBoundaryLayer.INSTANCE.apply(random.nextLong(), plateLayer);
        for (int i = 0; i < 5; ++i) {
            mainLayer = ZoomLayer.NORMAL.apply(random.nextLong(), mainLayer);
        }
        return mainLayer;
    }

    public static AreaFactory createOverworldRockLayer(long seed, int layerScale, int rockCount) {
        int i;
        Random random = new Random(seed);
        AreaFactory layer = new RockLayer(rockCount).apply(random.nextLong());
        layer = new RandomizeNeighborsLayer(rockCount).apply(random.nextLong(), layer);
        for (i = 0; i < 2; ++i) {
            layer = ZoomLayer.NORMAL.apply(random.nextLong(), layer);
            layer = ZoomLayer.NORMAL.apply(random.nextLong(), layer);
            layer = SmoothLayer.INSTANCE.apply(random.nextLong(), layer);
        }
        for (i = 0; i < layerScale; ++i) {
            layer = ZoomLayer.NORMAL.apply(random.nextLong(), layer);
        }
        return layer;
    }

    public static AreaFactory createRegionBiomeLayerWithRivers(RegionGenerator generator, long seed) {
        return new RegionMergeRiverLayer(generator).apply(seed, TFCLayers.createRegionBiomeLayer(generator, seed));
    }

    public static AreaFactory createRegionBiomeLayer(RegionGenerator generator, long seed) {
        Random random = new Random(seed);
        TypedAreaFactory<Region.Point> regionLayer = new RegionLayer(generator).apply(random.nextLong());
        AreaFactory mainLayer = RegionBiomeLayer.INSTANCE.apply(regionLayer);
        mainLayer = RegionEdgeBiomeLayer.INSTANCE.apply(random.nextLong(), mainLayer);
        mainLayer = ZoomLayer.NORMAL.apply(random.nextLong(), mainLayer);
        mainLayer = ShoreLayer.INSTANCE.apply(random.nextLong(), mainLayer);
        mainLayer = ZoomLayer.NORMAL.apply(random.nextLong(), mainLayer);
        mainLayer = ZoomLayer.NORMAL.apply(random.nextLong(), mainLayer);
        mainLayer = ZoomLayer.NORMAL.apply(random.nextLong(), mainLayer);
        mainLayer = ZoomLayer.NORMAL.apply(random.nextLong(), mainLayer);
        mainLayer = SmoothLayer.INSTANCE.apply(random.nextLong(), mainLayer);
        return mainLayer;
    }

    public static AreaFactory createUniformLayer(RandomSource random, int zoomLevels) {
        AreaFactory layer = UniformLayer.INSTANCE.apply(random.nextLong());
        for (int i = 0; i < zoomLevels; ++i) {
            layer = ZoomLayer.NORMAL.apply(random.nextLong(), layer);
        }
        layer = SmoothLayer.INSTANCE.apply(random.nextLong(), layer);
        return layer;
    }

    public static boolean isContinental(int value) {
        return value == 1 || value == 2 || value == 3;
    }

    public static boolean hasShore(int value) {
        return value != LOWLANDS && value != LOW_CANYONS && value != CANYONS && value != OCEANIC_MOUNTAINS && value != VOLCANIC_OCEANIC_MOUNTAINS;
    }

    public static int shoreFor(int value) {
        if (value == MOUNTAINS) {
            return OCEANIC_MOUNTAINS;
        }
        if (value == VOLCANIC_MOUNTAINS) {
            return VOLCANIC_OCEANIC_MOUNTAINS;
        }
        return SHORE;
    }

    public static boolean hasLake(int value) {
        return !TFCLayers.isOcean(value) && value != BADLANDS;
    }

    public static int lakeFor(int value) {
        if (value == MOUNTAINS) {
            return MOUNTAIN_LAKE;
        }
        if (value == VOLCANIC_MOUNTAINS) {
            return VOLCANIC_MOUNTAIN_LAKE;
        }
        if (value == OLD_MOUNTAINS) {
            return OLD_MOUNTAIN_LAKE;
        }
        if (value == OCEANIC_MOUNTAINS) {
            return OCEANIC_MOUNTAIN_LAKE;
        }
        if (value == VOLCANIC_OCEANIC_MOUNTAINS) {
            return VOLCANIC_OCEANIC_MOUNTAIN_LAKE;
        }
        if (value == PLATEAU) {
            return PLATEAU_LAKE;
        }
        return LAKE;
    }

    public static boolean hasRiver(int value) {
        return !TFCLayers.isOcean(value) && !TFCLayers.isLake(value);
    }

    public static int riverFor(int value) {
        if (value == MOUNTAINS) {
            return MOUNTAIN_RIVER;
        }
        if (value == VOLCANIC_MOUNTAINS) {
            return VOLCANIC_MOUNTAIN_RIVER;
        }
        if (value == OLD_MOUNTAINS) {
            return OLD_MOUNTAIN_RIVER;
        }
        if (value == OCEANIC_MOUNTAINS) {
            return OCEANIC_MOUNTAIN_RIVER;
        }
        if (value == VOLCANIC_OCEANIC_MOUNTAINS) {
            return VOLCANIC_OCEANIC_MOUNTAIN_RIVER;
        }
        return RIVER;
    }

    public static boolean isOcean(int value) {
        return value == OCEAN || value == DEEP_OCEAN || value == DEEP_OCEAN_TRENCH || value == OCEAN_REEF;
    }

    public static boolean isOceanOrMarker(int value) {
        return TFCLayers.isOcean(value) || value == OCEAN_OCEAN_CONVERGING_MARKER || value == OCEAN_OCEAN_DIVERGING_MARKER || value == OCEAN_REEF_MARKER;
    }

    public static boolean isLake(int value) {
        return value == LAKE || value == OCEANIC_MOUNTAIN_LAKE || value == OLD_MOUNTAIN_LAKE || value == MOUNTAIN_LAKE || value == VOLCANIC_OCEANIC_MOUNTAIN_LAKE || value == VOLCANIC_MOUNTAIN_LAKE || value == PLATEAU_LAKE;
    }

    public static boolean isRiver(int value) {
        return value == RIVER || value == OCEANIC_MOUNTAIN_RIVER || value == OLD_MOUNTAIN_RIVER || value == MOUNTAIN_RIVER || value == VOLCANIC_OCEANIC_MOUNTAIN_RIVER || value == VOLCANIC_MOUNTAIN_RIVER;
    }

    public static boolean isMountains(int value) {
        return value == MOUNTAINS || value == OCEANIC_MOUNTAINS || value == OLD_MOUNTAINS || value == VOLCANIC_MOUNTAINS || value == VOLCANIC_OCEANIC_MOUNTAINS;
    }

    public static boolean isLow(int value) {
        return value == PLAINS || value == HILLS || value == LOW_CANYONS || value == LOWLANDS;
    }

    public static int register() {
        return TFCLayers.register(() -> null);
    }

    public static int register(Supplier<BiomeExtension> variants) {
        int index = BIOME_LAYER_INDEX.getAndIncrement();
        if (index >= BIOME_LAYERS.length) {
            throw new IllegalStateException("Tried to register layer id " + index + " but only had space for " + BIOME_LAYERS.length + " layers");
        }
        TFCLayers.BIOME_LAYERS[index] = Helpers.BOOTSTRAP_ENVIRONMENT ? null : variants.get();
        return index;
    }

    static {
        BIOME_LAYERS = new BiomeExtension[64];
        BIOME_LAYER_INDEX = new MutableInt(0);
        OCEAN = TFCLayers.register(() -> TFCBiomes.OCEAN);
        OCEAN_REEF = TFCLayers.register(() -> TFCBiomes.OCEAN_REEF);
        DEEP_OCEAN = TFCLayers.register(() -> TFCBiomes.DEEP_OCEAN);
        DEEP_OCEAN_TRENCH = TFCLayers.register(() -> TFCBiomes.DEEP_OCEAN_TRENCH);
        PLAINS = TFCLayers.register(() -> TFCBiomes.PLAINS);
        HILLS = TFCLayers.register(() -> TFCBiomes.HILLS);
        LOWLANDS = TFCLayers.register(() -> TFCBiomes.LOWLANDS);
        LOW_CANYONS = TFCLayers.register(() -> TFCBiomes.LOW_CANYONS);
        ROLLING_HILLS = TFCLayers.register(() -> TFCBiomes.ROLLING_HILLS);
        BADLANDS = TFCLayers.register(() -> TFCBiomes.BADLANDS);
        INVERTED_BADLANDS = TFCLayers.register(() -> TFCBiomes.INVERTED_BADLANDS);
        PLATEAU = TFCLayers.register(() -> TFCBiomes.PLATEAU);
        OLD_MOUNTAINS = TFCLayers.register(() -> TFCBiomes.OLD_MOUNTAINS);
        MOUNTAINS = TFCLayers.register(() -> TFCBiomes.MOUNTAINS);
        VOLCANIC_MOUNTAINS = TFCLayers.register(() -> TFCBiomes.VOLCANIC_MOUNTAINS);
        OCEANIC_MOUNTAINS = TFCLayers.register(() -> TFCBiomes.OCEANIC_MOUNTAINS);
        VOLCANIC_OCEANIC_MOUNTAINS = TFCLayers.register(() -> TFCBiomes.VOLCANIC_OCEANIC_MOUNTAINS);
        CANYONS = TFCLayers.register(() -> TFCBiomes.CANYONS);
        SHORE = TFCLayers.register(() -> TFCBiomes.SHORE);
        LAKE = TFCLayers.register(() -> TFCBiomes.LAKE);
        RIVER = TFCLayers.register(() -> TFCBiomes.RIVER);
        MOUNTAIN_RIVER = TFCLayers.register(() -> TFCBiomes.MOUNTAIN_RIVER);
        VOLCANIC_MOUNTAIN_RIVER = TFCLayers.register(() -> TFCBiomes.VOLCANIC_MOUNTAIN_RIVER);
        OLD_MOUNTAIN_RIVER = TFCLayers.register(() -> TFCBiomes.OLD_MOUNTAIN_RIVER);
        OCEANIC_MOUNTAIN_RIVER = TFCLayers.register(() -> TFCBiomes.OCEANIC_MOUNTAIN_RIVER);
        VOLCANIC_OCEANIC_MOUNTAIN_RIVER = TFCLayers.register(() -> TFCBiomes.VOLCANIC_OCEANIC_MOUNTAIN_RIVER);
        MOUNTAIN_LAKE = TFCLayers.register(() -> TFCBiomes.MOUNTAIN_LAKE);
        VOLCANIC_MOUNTAIN_LAKE = TFCLayers.register(() -> TFCBiomes.VOLCANIC_MOUNTAIN_LAKE);
        OLD_MOUNTAIN_LAKE = TFCLayers.register(() -> TFCBiomes.OLD_MOUNTAIN_LAKE);
        OCEANIC_MOUNTAIN_LAKE = TFCLayers.register(() -> TFCBiomes.OCEANIC_MOUNTAIN_LAKE);
        VOLCANIC_OCEANIC_MOUNTAIN_LAKE = TFCLayers.register(() -> TFCBiomes.VOLCANIC_OCEANIC_MOUNTAIN_LAKE);
        PLATEAU_LAKE = TFCLayers.register(() -> TFCBiomes.PLATEAU_LAKE);
        OCEAN_OCEAN_CONVERGING_MARKER = TFCLayers.register();
        OCEAN_OCEAN_DIVERGING_MARKER = TFCLayers.register();
        LAKE_MARKER = TFCLayers.register();
        NULL_MARKER = TFCLayers.register();
        INLAND_MARKER = TFCLayers.register();
        OCEAN_REEF_MARKER = TFCLayers.register();
    }
}

