/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.layer;

import net.dries007.tfc.world.layer.Plate;
import net.dries007.tfc.world.layer.framework.AreaContext;
import net.dries007.tfc.world.layer.framework.TypedSourceLayer;
import net.dries007.tfc.world.noise.Cellular2D;
import net.minecraft.util.Mth;

public class PlateGenerationLayer
implements TypedSourceLayer<Plate> {
    private static final float PI = (float)Math.PI;
    private final Cellular2D plateNoise;
    private final float oceanPercent;

    public PlateGenerationLayer(Cellular2D plateNoise, int oceanPercent) {
        this.plateNoise = plateNoise;
        this.oceanPercent = (float)oceanPercent * 0.01f;
    }

    @Override
    public Plate apply(AreaContext context, int x, int z) {
        Cellular2D.Cell cell = this.plateNoise.cell(x, z);
        float centerX = cell.x();
        float centerZ = cell.y();
        context.setSeed((long)centerX, (long)centerZ);
        boolean oceanic = context.random().nextFloat() < this.oceanPercent;
        float angle = (float)Math.PI * 2 * context.random().nextFloat();
        float velocity = context.random().nextFloat();
        float elevation = context.random().nextFloat();
        float driftX = Mth.m_14089_((float)angle) * velocity;
        float driftZ = Mth.m_14031_((float)angle) * velocity;
        return new Plate(centerX, centerZ, driftX, driftZ, elevation, oceanic);
    }
}

