/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.layer;

import net.dries007.tfc.world.layer.TFCLayers;
import net.dries007.tfc.world.layer.framework.AreaContext;
import net.dries007.tfc.world.layer.framework.CenterTransformLayer;

public enum PlateBiomeLayer implements CenterTransformLayer
{
    INSTANCE;

    private static final int[] SUBDUCTION_BIOMES;
    private static final int[] OROGENY_BIOMES;
    private static final int[] RIFT_BIOMES;
    private static final int[] CONTINENT_LOW_BIOMES;
    private static final int[] CONTINENT_MID_BIOMES;
    private static final int[] CONTINENT_HIGH_BIOMES;

    @Override
    public int apply(AreaContext context, int value) {
        switch (value) {
            case 0: {
                return TFCLayers.DEEP_OCEAN;
            }
            case 1: {
                return context.choose(CONTINENT_LOW_BIOMES);
            }
            case 2: {
                return context.choose(CONTINENT_MID_BIOMES);
            }
            case 3: {
                return context.choose(CONTINENT_HIGH_BIOMES);
            }
            case 4: {
                return TFCLayers.OCEAN_OCEAN_DIVERGING_MARKER;
            }
            case 5: {
                return TFCLayers.DEEP_OCEAN_TRENCH;
            }
            case 6: {
                return TFCLayers.OCEAN_OCEAN_CONVERGING_MARKER;
            }
            case 7: {
                return TFCLayers.DEEP_OCEAN_TRENCH;
            }
            case 8: {
                return context.choose(SUBDUCTION_BIOMES);
            }
            case 10: {
                return context.choose(RIFT_BIOMES);
            }
            case 11: {
                return context.choose(OROGENY_BIOMES);
            }
            case 12: {
                return TFCLayers.OCEAN;
            }
        }
        throw new IllegalStateException("What is this: " + value);
    }

    static {
        SUBDUCTION_BIOMES = new int[]{TFCLayers.VOLCANIC_OCEANIC_MOUNTAINS, TFCLayers.VOLCANIC_OCEANIC_MOUNTAINS, TFCLayers.VOLCANIC_MOUNTAINS, TFCLayers.VOLCANIC_MOUNTAINS, TFCLayers.MOUNTAINS, TFCLayers.PLATEAU};
        OROGENY_BIOMES = new int[]{TFCLayers.MOUNTAINS, TFCLayers.MOUNTAINS, TFCLayers.MOUNTAINS, TFCLayers.OLD_MOUNTAINS, TFCLayers.PLATEAU};
        RIFT_BIOMES = new int[]{TFCLayers.CANYONS, TFCLayers.CANYONS, TFCLayers.CANYONS, TFCLayers.CANYONS, TFCLayers.ROLLING_HILLS, TFCLayers.OLD_MOUNTAINS};
        CONTINENT_LOW_BIOMES = new int[]{TFCLayers.PLAINS, TFCLayers.PLAINS, TFCLayers.HILLS, TFCLayers.ROLLING_HILLS, TFCLayers.LOW_CANYONS, TFCLayers.LOW_CANYONS, TFCLayers.LOWLANDS, TFCLayers.LOWLANDS};
        CONTINENT_MID_BIOMES = new int[]{TFCLayers.PLAINS, TFCLayers.HILLS, TFCLayers.ROLLING_HILLS, TFCLayers.INVERTED_BADLANDS, TFCLayers.BADLANDS, TFCLayers.PLATEAU, TFCLayers.LOW_CANYONS, TFCLayers.LOWLANDS};
        CONTINENT_HIGH_BIOMES = new int[]{TFCLayers.HILLS, TFCLayers.ROLLING_HILLS, TFCLayers.ROLLING_HILLS, TFCLayers.INVERTED_BADLANDS, TFCLayers.BADLANDS, TFCLayers.PLATEAU, TFCLayers.PLATEAU, TFCLayers.OLD_MOUNTAINS, TFCLayers.OLD_MOUNTAINS};
    }
}

