/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.vein;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.dries007.tfc.world.Codecs;
import net.dries007.tfc.world.feature.vein.VeinConfig;

public class PipeVeinConfig
extends VeinConfig {
    public static final Codec<PipeVeinConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)VeinConfig.MAP_CODEC.forGetter(c -> c), (App)Codecs.POSITIVE_INT.optionalFieldOf("radius", (Object)3).forGetter(PipeVeinConfig::getRadius), (App)Codecs.POSITIVE_INT.optionalFieldOf("min_skew", (Object)0).forGetter(PipeVeinConfig::getMinSkew), (App)Codecs.POSITIVE_INT.optionalFieldOf("max_skew", (Object)0).forGetter(PipeVeinConfig::getMaxSkew), (App)Codecs.POSITIVE_INT.optionalFieldOf("min_slant", (Object)0).forGetter(PipeVeinConfig::getMinSlant), (App)Codecs.POSITIVE_INT.optionalFieldOf("max_slant", (Object)0).forGetter(PipeVeinConfig::getMaxSlant), (App)Codecs.UNIT_FLOAT.optionalFieldOf("sign", (Object)Float.valueOf(0.5f)).forGetter(PipeVeinConfig::getSign)).apply((Applicative)instance, PipeVeinConfig::new));
    private final int radius;
    private final int minSkew;
    private final int maxSkew;
    private final int minSlant;
    private final int maxSlant;
    private final float sign;

    public PipeVeinConfig(VeinConfig other, int radius, int minSkew, int maxSkew, int minSlant, int maxSlant, float sign) {
        super(other);
        this.radius = radius;
        this.minSkew = minSkew;
        this.maxSkew = maxSkew;
        this.minSlant = minSlant;
        this.maxSlant = maxSlant;
        this.sign = sign;
    }

    public int getRadius() {
        return this.radius;
    }

    public int getMinSkew() {
        return this.minSkew;
    }

    public int getMaxSkew() {
        return this.maxSkew;
    }

    public int getMinSlant() {
        return this.minSlant;
    }

    public int getMaxSlant() {
        return this.maxSlant;
    }

    public float getSign() {
        return this.sign;
    }

    @Override
    public int getChunkRadius() {
        return 1 + (this.radius >> 4);
    }
}

