/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.tree;

import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.RiverWaterBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.mixin.accessor.StructureTemplateAccessor;
import net.dries007.tfc.util.EnvironmentHelpers;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.feature.tree.TreePlacementConfig;
import net.dries007.tfc.world.feature.tree.TrunkConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public final class TreeHelpers {
    private static final Rotation[] ROTATION_VALUES = Rotation.values();
    private static final Mirror[] MIRROR_VALUES = Mirror.values();

    public static boolean isValidLocation(LevelAccessor level, BlockPos pos, StructurePlaceSettings settings, TreePlacementConfig config) {
        return TreeHelpers.isValidGround(level, pos, settings, config) && TreeHelpers.isValidTrunk(level, pos, settings, config);
    }

    public static boolean isValidGround(LevelAccessor level, BlockPos pos, StructurePlaceSettings settings, TreePlacementConfig config) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int x = (1 - config.width()) / 2; x <= config.width() / 2; ++x) {
            for (int z = (1 - config.width()) / 2; z <= config.width() / 2; ++z) {
                mutablePos.m_122178_(x, 0, z);
                TreeHelpers.transformMutable(mutablePos, settings.m_74401_(), settings.m_74404_());
                mutablePos.m_122193_((Vec3i)pos);
                if (!config.allowDeeplySubmerged() ? TreeHelpers.isValidPosition(level, mutablePos, config) : TreeHelpers.isValidPositionPossiblyUnderwater(level, mutablePos)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isValidPosition(LevelAccessor level, BlockPos.MutableBlockPos mutablePos, TreePlacementConfig config) {
        boolean isInWater;
        BlockState stateAt = level.m_8055_((BlockPos)mutablePos);
        boolean bl = isInWater = stateAt.m_60819_().m_76152_() == Fluids.f_76193_;
        if (!(config.allowSubmerged() && FluidHelpers.isAirOrEmptyFluid(stateAt) && isInWater || stateAt.m_60795_() || stateAt.m_60734_() instanceof SaplingBlock)) {
            return false;
        }
        mutablePos.m_122184_(0, -1, 0);
        BlockState stateBelow = level.m_8055_((BlockPos)mutablePos);
        boolean treeGrowsOn = Helpers.isBlock(stateBelow, TFCTags.Blocks.TREE_GROWS_ON);
        if (config.allowSubmerged() && isInWater) {
            treeGrowsOn |= Helpers.isBlock(stateBelow, TFCTags.Blocks.SEA_BUSH_PLANTABLE_ON);
        }
        return treeGrowsOn;
    }

    private static boolean isValidPositionPossiblyUnderwater(LevelAccessor level, BlockPos.MutableBlockPos mutablePos) {
        BlockState stateAt = level.m_8055_((BlockPos)mutablePos);
        FluidState fluid = stateAt.m_60819_();
        if (!Helpers.isFluid(fluid, (TagKey<Fluid>)FluidTags.f_13131_) || stateAt.m_61138_(RiverWaterBlock.FLOW)) {
            return false;
        }
        mutablePos.m_122184_(0, -1, 0);
        BlockState stateBelow = level.m_8055_((BlockPos)mutablePos);
        return Helpers.isBlock(stateBelow, TFCTags.Blocks.SEA_BUSH_PLANTABLE_ON) && Helpers.isBlock(stateBelow, TFCTags.Blocks.TREE_GROWS_ON);
    }

    public static boolean isValidTrunk(LevelAccessor level, BlockPos pos, StructurePlaceSettings settings, TreePlacementConfig config) {
        Predicate<BlockState> trunkTest = config.allowDeeplySubmerged() ? FluidHelpers::isAirOrEmptyFluid : BlockBehaviour.BlockStateBase::m_60795_;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int x = (1 - config.width()) / 2; x <= config.width() / 2; ++x) {
            for (int z = (1 - config.width()) / 2; z <= config.width() / 2; ++z) {
                for (int y = 1; y < config.height(); ++y) {
                    mutablePos.m_122178_(x, y, z);
                    TreeHelpers.transformMutable(mutablePos, settings.m_74401_(), settings.m_74404_());
                    mutablePos.m_122193_((Vec3i)pos);
                    BlockState stateAt = level.m_8055_((BlockPos)mutablePos);
                    if (trunkTest.test(stateAt)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static void placeTemplate(StructureTemplate template, StructurePlaceSettings placementIn, LevelAccessor level, BlockPos pos) {
        List transformedBlockInfos = placementIn.m_74387_(((StructureTemplateAccessor)template).accessor$getPalettes(), pos).m_74652_();
        BoundingBox boundingBox = placementIn.m_74409_();
        for (StructureTemplate.StructureBlockInfo blockInfo : StructureTemplate.processBlockInfos((LevelAccessor)level, (BlockPos)pos, (BlockPos)pos, (StructurePlaceSettings)placementIn, (List)transformedBlockInfos, (StructureTemplate)template)) {
            BlockState stateAt;
            BlockPos posAt = blockInfo.f_74675_;
            if (boundingBox != null && !boundingBox.m_71051_((Vec3i)posAt) || !EnvironmentHelpers.isWorldgenReplaceable(stateAt = level.m_8055_(posAt)) && !Helpers.isBlock(stateAt.m_60734_(), (TagKey<Block>)BlockTags.f_13035_)) continue;
            BlockState stateReplace = blockInfo.f_74676_.m_60715_(placementIn.m_74401_()).m_60717_(placementIn.m_74404_());
            level.m_7731_(posAt, stateReplace, 2);
        }
    }

    public static int placeTrunk(WorldGenLevel level, BlockPos pos, Random random, StructurePlaceSettings settings, TrunkConfig trunk) {
        int height = trunk.getHeight(random);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int x = (1 - trunk.width()) / 2; x <= trunk.width() / 2; ++x) {
            for (int z = (1 - trunk.width()) / 2; z <= trunk.width() / 2; ++z) {
                for (int y = 0; y < height; ++y) {
                    mutablePos.m_122178_(x, y, z);
                    TreeHelpers.transformMutable(mutablePos, settings.m_74401_(), settings.m_74404_());
                    mutablePos.m_122193_((Vec3i)pos);
                    level.m_7731_((BlockPos)mutablePos, trunk.state(), 3);
                }
            }
        }
        return height;
    }

    public static StructureManager getStructureManager(WorldGenLevel level) {
        return level.m_6018_().m_142572_().m_129909_();
    }

    public static StructurePlaceSettings getPlacementSettings(LevelHeightAccessor level, ChunkPos chunkPos, Random random) {
        return new StructurePlaceSettings().m_74381_(new BoundingBox(chunkPos.m_45604_() - 16, level.m_141937_(), chunkPos.m_45605_() - 16, chunkPos.m_45608_() + 16, level.m_151558_(), chunkPos.m_45609_() + 16)).m_74390_(random).m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74048_).m_74379_(TreeHelpers.randomRotation(random)).m_74377_(TreeHelpers.randomMirror(random));
    }

    public static BlockPos transformCenter(Vec3i size, StructurePlaceSettings settings) {
        return TreeHelpers.transform(new BlockPos((size.m_123341_() - 1) / 2, 0, (size.m_123343_() - 1) / 2), settings.m_74401_(), settings.m_74404_());
    }

    public static BlockPos transform(BlockPos pos, Mirror mirrorIn, Rotation rotationIn) {
        int posX = pos.m_123341_();
        int posZ = pos.m_123343_();
        boolean mirror = true;
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                posZ = -posZ;
                break;
            }
            case FRONT_BACK: {
                posX = -posX;
                break;
            }
            default: {
                mirror = false;
            }
        }
        return switch (rotationIn) {
            case Rotation.COUNTERCLOCKWISE_90 -> new BlockPos(posZ, pos.m_123342_(), -posX);
            case Rotation.CLOCKWISE_90 -> new BlockPos(-posZ, pos.m_123342_(), posX);
            case Rotation.CLOCKWISE_180 -> new BlockPos(-posX, pos.m_123342_(), -posZ);
            default -> mirror ? new BlockPos(posX, pos.m_123342_(), posZ) : pos;
        };
    }

    public static void transformMutable(BlockPos.MutableBlockPos pos, Mirror mirrorIn, Rotation rotationIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                pos.m_142443_(-pos.m_123343_());
                break;
            }
            case FRONT_BACK: {
                pos.m_142451_(-pos.m_123341_());
            }
        }
        switch (rotationIn) {
            case COUNTERCLOCKWISE_90: {
                pos.m_122178_(pos.m_123343_(), pos.m_123342_(), -pos.m_123341_());
                break;
            }
            case CLOCKWISE_90: {
                pos.m_122178_(-pos.m_123343_(), pos.m_123342_(), pos.m_123341_());
                break;
            }
            case CLOCKWISE_180: {
                pos.m_122178_(-pos.m_123341_(), pos.m_123342_(), -pos.m_123343_());
            }
        }
    }

    private static Rotation randomRotation(Random random) {
        return ROTATION_VALUES[random.nextInt(ROTATION_VALUES.length)];
    }

    private static Mirror randomMirror(Random random) {
        return MIRROR_VALUES[random.nextInt(MIRROR_VALUES.length)];
    }
}

