/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.plant;

import com.mojang.serialization.Codec;
import net.dries007.tfc.common.blockentities.DecayingBlockEntity;
import net.dries007.tfc.common.blocks.crop.WildSpreadingCropBlock;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodTraits;
import net.dries007.tfc.util.EnvironmentHelpers;
import net.dries007.tfc.world.feature.BlockConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class SpreadingCropFeature
extends Feature<BlockConfig<WildSpreadingCropBlock>> {
    public static final Codec<BlockConfig<WildSpreadingCropBlock>> CODEC = BlockConfig.codec(b -> {
        WildSpreadingCropBlock t;
        return b instanceof WildSpreadingCropBlock ? (t = (WildSpreadingCropBlock)b) : null;
    }, "Must be a " + WildSpreadingCropBlock.class.getSimpleName());

    public SpreadingCropFeature(Codec<BlockConfig<WildSpreadingCropBlock>> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<BlockConfig<WildSpreadingCropBlock>> context) {
        WildSpreadingCropBlock block = (WildSpreadingCropBlock)((BlockConfig)context.m_159778_()).block();
        WorldGenLevel level = context.m_159774_();
        BlockPos origin = context.m_159777_();
        BlockPos offsetPos = origin.m_142300_(Direction.Plane.HORIZONTAL.m_122560_(context.m_159776_()));
        this.m_5974_((LevelWriter)level, origin, block.m_49966_());
        BlockPos below = offsetPos.m_7495_();
        if (level.m_8055_(below).m_60783_((BlockGetter)level, below, Direction.UP) && EnvironmentHelpers.isWorldgenReplaceable(level, offsetPos)) {
            this.m_5974_((LevelWriter)level, offsetPos, block.getFruit().m_49966_());
            BlockEntity blockEntity = level.m_7702_(offsetPos);
            if (blockEntity instanceof DecayingBlockEntity) {
                DecayingBlockEntity decaying = (DecayingBlockEntity)blockEntity;
                ItemStack food = new ItemStack((ItemLike)block.getFruit());
                FoodCapability.applyTrait(food, FoodTraits.WILD);
                decaying.setStack(food);
            }
        }
        return true;
    }
}

