/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.dries007.tfc.common.blocks.soil.ConnectedGrassBlock;
import net.dries007.tfc.common.blocks.soil.DirtBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BambooBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BambooLeaves;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.ProbabilityFeatureConfiguration;

public class TFCBambooFeature
extends Feature<ProbabilityFeatureConfiguration> {
    private static final BlockState BAMBOO_TRUNK = (BlockState)((BlockState)((BlockState)Blocks.f_50571_.m_49966_().m_61124_((Property)BambooBlock.f_48869_, (Comparable)Integer.valueOf(1))).m_61124_((Property)BambooBlock.f_48870_, (Comparable)BambooLeaves.NONE)).m_61124_((Property)BambooBlock.f_48871_, (Comparable)Integer.valueOf(0));
    private static final BlockState BAMBOO_FINAL_LARGE = (BlockState)((BlockState)BAMBOO_TRUNK.m_61124_((Property)BambooBlock.f_48870_, (Comparable)BambooLeaves.LARGE)).m_61124_((Property)BambooBlock.f_48871_, (Comparable)Integer.valueOf(1));
    private static final BlockState BAMBOO_TOP_LARGE = (BlockState)BAMBOO_TRUNK.m_61124_((Property)BambooBlock.f_48870_, (Comparable)BambooLeaves.LARGE);
    private static final BlockState BAMBOO_TOP_SMALL = (BlockState)BAMBOO_TRUNK.m_61124_((Property)BambooBlock.f_48870_, (Comparable)BambooLeaves.SMALL);

    public TFCBambooFeature(Codec<ProbabilityFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<ProbabilityFeatureConfiguration> context) {
        int placed = 0;
        BlockPos blockpos = context.m_159777_();
        WorldGenLevel level = context.m_159774_();
        Random random = context.m_159776_();
        ProbabilityFeatureConfiguration config = (ProbabilityFeatureConfiguration)context.m_159778_();
        BlockPos.MutableBlockPos cursor = blockpos.m_122032_();
        BlockPos.MutableBlockPos cursor2 = blockpos.m_122032_();
        if (level.m_46859_((BlockPos)cursor)) {
            if (Blocks.f_50571_.m_49966_().m_60710_((LevelReader)level, (BlockPos)cursor)) {
                int trunkSize = random.nextInt(12) + 5;
                if (random.nextFloat() < config.f_67859_) {
                    int radius = random.nextInt(4) + 1;
                    for (int x = blockpos.m_123341_() - radius; x <= blockpos.m_123341_() + radius; ++x) {
                        for (int z = blockpos.m_123343_() - radius; z <= blockpos.m_123343_() + radius; ++z) {
                            ConnectedGrassBlock grass;
                            Block block;
                            int dz;
                            int dx = x - blockpos.m_123341_();
                            if (dx * dx + (dz = z - blockpos.m_123343_()) * dz > radius * radius) continue;
                            cursor2.m_122178_(x, level.m_6924_(Heightmap.Types.WORLD_SURFACE, x, z) - 1, z);
                            Block under = level.m_8055_((BlockPos)cursor2).m_60734_();
                            if (under instanceof ConnectedGrassBlock && (block = (grass = (ConnectedGrassBlock)under).getDirt().m_60734_()) instanceof DirtBlock) {
                                DirtBlock dirt = (DirtBlock)block;
                                level.m_7731_((BlockPos)cursor2, dirt.getRooted(), 2);
                                continue;
                            }
                            if (!(under instanceof DirtBlock)) continue;
                            DirtBlock dirt = (DirtBlock)under;
                            level.m_7731_((BlockPos)cursor2, dirt.getRooted(), 2);
                        }
                    }
                }
                for (int j = 0; j < trunkSize && level.m_46859_((BlockPos)cursor); ++j) {
                    level.m_7731_((BlockPos)cursor, BAMBOO_TRUNK, 2);
                    cursor.m_122175_(Direction.UP, 1);
                }
                if (cursor.m_123342_() - blockpos.m_123342_() >= 3) {
                    level.m_7731_((BlockPos)cursor, BAMBOO_FINAL_LARGE, 2);
                    level.m_7731_((BlockPos)cursor.m_122175_(Direction.DOWN, 1), BAMBOO_TOP_LARGE, 2);
                    level.m_7731_((BlockPos)cursor.m_122175_(Direction.DOWN, 1), BAMBOO_TOP_SMALL, 2);
                }
            }
            ++placed;
        }
        return placed > 0;
    }
}

