/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature;

import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.util.LegacyMaterials;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.NotNull;

public class RivuletFeature
extends Feature<BlockStateConfiguration> {
    public RivuletFeature(Codec<BlockStateConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<BlockStateConfiguration> context) {
        WorldGenLevel world = context.m_159774_();
        BlockPos pos = context.m_159777_();
        Random rand = context.m_159776_();
        BlockStateConfiguration config = (BlockStateConfiguration)context.m_159778_();
        ChunkPos chunkPos = new ChunkPos(pos);
        BoundingBox box = new BoundingBox(chunkPos.m_45604_() - 14, Integer.MIN_VALUE, chunkPos.m_45605_() - 14, chunkPos.m_45608_() + 14, Integer.MAX_VALUE, chunkPos.m_45609_() + 14);
        HashSet<BlockPos> chosen = new HashSet<BlockPos>();
        LinkedList<BlockPos> branches = new LinkedList<BlockPos>();
        BlockPos startPos = new BlockPos(pos.m_123341_(), world.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, pos.m_123341_(), pos.m_123343_()), pos.m_123343_());
        if (!world.m_6425_(startPos.m_7495_()).m_76178_()) {
            return false;
        }
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        branches.add(startPos);
        boolean mainBranch = true;
        block0: while (!branches.isEmpty()) {
            BlockPos branchStartPos = (BlockPos)branches.removeFirst();
            int maxLength = 5 + rand.nextInt(8);
            if (mainBranch) {
                mainBranch = false;
                maxLength += 12;
            }
            BlockPos lastPos = branchStartPos;
            for (int i = 0; i < maxLength; ++i) {
                chosen.add(branchStartPos);
                Direction chosenDirection = null;
                int chosenHeight = 0;
                int possibleDirections = 0;
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    int height;
                    mutablePos.m_122159_((Vec3i)lastPos, direction);
                    if (!box.m_71051_((Vec3i)mutablePos) || !world.m_6425_(mutablePos.m_7495_()).m_76178_() || (height = world.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, mutablePos.m_123341_(), mutablePos.m_123343_())) > mutablePos.m_123342_()) continue;
                    mutablePos.m_142448_(height - 1);
                    if (!LegacyMaterials.isSolid(world.m_8055_((BlockPos)mutablePos)) || chosenDirection != null && rand.nextInt(++possibleDirections) != 0) continue;
                    chosenHeight = height;
                    chosenDirection = direction;
                }
                if (possibleDirections == 0) continue block0;
                if (possibleDirections > 1 && rand.nextInt(3) == 0) {
                    branches.add(lastPos);
                }
                mutablePos.m_122159_((Vec3i)lastPos, chosenDirection).m_142448_(chosenHeight);
                if (chosen.contains(mutablePos) || !world.m_6425_(mutablePos.m_7495_()).m_76178_()) continue block0;
                lastPos = mutablePos.m_7949_();
                chosen.add(lastPos);
            }
        }
        if (!chosen.isEmpty()) {
            for (BlockPos chosenPos : chosen) {
                mutablePos.m_122190_((Vec3i)chosenPos);
                while (!FluidHelpers.isAirOrEmptyFluid(world.m_8055_((BlockPos)mutablePos))) {
                    this.m_5974_((LevelWriter)world, (BlockPos)mutablePos, this.getReplaceState(world, mutablePos));
                    mutablePos.m_122173_(Direction.UP);
                }
                mutablePos.m_122159_((Vec3i)chosenPos, Direction.DOWN);
                this.m_5974_((LevelWriter)world, (BlockPos)mutablePos, this.getReplaceState(world, mutablePos));
                mutablePos.m_122173_(Direction.DOWN);
                this.m_5974_((LevelWriter)world, (BlockPos)mutablePos, config.f_67547_);
                mutablePos.m_122173_(Direction.DOWN);
                this.m_5974_((LevelWriter)world, (BlockPos)mutablePos, config.f_67547_);
            }
            return true;
        }
        return false;
    }

    @NotNull
    private BlockState getReplaceState(WorldGenLevel level, BlockPos.MutableBlockPos pos) {
        for (Direction d : Direction.Plane.HORIZONTAL) {
            pos.m_122173_(d);
            FluidState fluidState = level.m_6425_((BlockPos)pos);
            if (!fluidState.m_76178_()) {
                pos.m_122173_(d.m_122424_());
                return fluidState.m_76188_();
            }
            pos.m_122173_(d.m_122424_());
        }
        return Blocks.f_50016_.m_49966_();
    }
}

