/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.LegacyMaterials;
import net.dries007.tfc.util.collections.IWeighted;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.chunkdata.ChunkDataProvider;
import net.dries007.tfc.world.feature.FissureFeature;
import net.dries007.tfc.world.feature.HotSpringConfig;
import net.dries007.tfc.world.noise.Metaballs2D;
import net.dries007.tfc.world.settings.RockSettings;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class HotSpringFeature
extends Feature<HotSpringConfig> {
    public HotSpringFeature(Codec<HotSpringConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<HotSpringConfig> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        Random random = context.m_159776_();
        HotSpringConfig config = (HotSpringConfig)context.m_159778_();
        Metaballs2D noise = Metaballs2D.simple(Helpers.fork(random), config.radius());
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        ChunkDataProvider provider = ChunkDataProvider.get(context.m_159775_());
        ChunkData data = provider.get(context.m_159774_(), pos);
        RockSettings rock = data.getRockData().getRock(pos.m_123341_(), 0, pos.m_123343_());
        Block rawBlock = rock.raw();
        BlockState rockState = rawBlock.m_49966_();
        BlockState gravelState = rock.gravel().m_49966_();
        Fluid fluid = config.fluidState().m_60819_().m_76152_();
        boolean useFilledEmptyCheck = config.fluidState().m_60795_();
        HashSet<BlockPos> filledEmptyPositions = new HashSet<BlockPos>();
        ArrayList<BlockPos> fissureStartPositions = new ArrayList<BlockPos>();
        Optional<Map<Block, IWeighted<BlockState>>> replacers = config.replacesOnFluidContact();
        IWeighted magma = replacers.map(map -> map.getOrDefault(rawBlock, (IWeighted)Helpers.getRandomValue(map, random))).orElse(null);
        boolean touchedWater = false;
        for (int x = -config.radius(); x <= config.radius(); ++x) {
            block1: for (int z = -config.radius(); z <= config.radius(); ++z) {
                int dy;
                int localX = pos.m_123341_() + x;
                int localZ = pos.m_123343_() + z;
                int y = level.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, localX, localZ) - 1;
                if (!config.allowUnderwater() && y <= 63 || !noise.inside(x, z)) continue;
                mutablePos.m_122178_(localX, y + 1, localZ);
                BlockState stateAbove = level.m_8055_((BlockPos)mutablePos);
                if (!HotSpringFeature.isEmptyBlock(config, stateAbove)) {
                    if (!LegacyMaterials.isReplaceable(stateAbove)) continue;
                    this.m_5974_((LevelWriter)level, (BlockPos)mutablePos, stateAbove.m_60819_().m_76188_());
                    mutablePos.m_122184_(0, 1, 0);
                    level.m_186460_((BlockPos)mutablePos, level.m_8055_((BlockPos)mutablePos).m_60734_(), 1);
                }
                boolean edge = false;
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    mutablePos.m_122178_(localX, y, localZ).m_122173_(direction);
                    BlockState stateAt = level.m_8055_((BlockPos)mutablePos);
                    if (LegacyMaterials.isLiquid(stateAt)) {
                        touchedWater = true;
                    }
                    if (!HotSpringFeature.isEmptyBlock(config, stateAt) || useFilledEmptyCheck && filledEmptyPositions.contains(mutablePos)) continue;
                    edge = true;
                    break;
                }
                float centerFactor = 1.0f - 0.7f * Mth.m_14036_((float)((float)(2 * (x * x + z * z)) / (float)(config.radius() * config.radius())), (float)0.0f, (float)1.0f);
                int surfaceDepth = (int)((float)(8 + random.nextInt(3)) * centerFactor);
                if (edge) {
                    int startY;
                    int n = startY = random.nextInt(12) == 0 ? -1 : 0;
                    if (startY == -1) {
                        mutablePos.m_122178_(localX, y, localZ);
                        this.m_5974_((LevelWriter)level, (BlockPos)mutablePos, Blocks.f_50016_.m_49966_());
                    }
                } else {
                    mutablePos.m_122178_(localX, y, localZ);
                    BlockPos posAt = mutablePos.m_7949_();
                    fissureStartPositions.add(posAt);
                    BlockState toPlace = touchedWater && config.allowUnderwater() && magma != null ? (BlockState)magma.get(random) : config.fluidState();
                    this.m_5974_((LevelWriter)level, (BlockPos)mutablePos, toPlace);
                    if (fluid != Fluids.f_76191_) {
                        level.m_186469_((BlockPos)mutablePos, fluid, 0);
                    }
                    if (touchedWater) {
                        level.m_186460_((BlockPos)mutablePos, toPlace.m_60734_(), 20);
                    }
                    if (useFilledEmptyCheck) {
                        filledEmptyPositions.add(posAt);
                    }
                    mutablePos.m_122178_(localX, y - 1, localZ);
                    this.setFissureBaseBlock(config, level, (BlockPos)mutablePos, gravelState);
                }
                int n = dy = edge ? 0 : -2;
                while (dy >= -surfaceDepth) {
                    mutablePos.m_122178_(localX, y + dy, localZ);
                    if (!this.setFissureBaseBlock(config, level, (BlockPos)mutablePos, rockState)) continue block1;
                    --dy;
                }
            }
        }
        if (fissureStartPositions.isEmpty()) {
            return false;
        }
        int fissureStarts = 1 + random.nextInt(1 + random.nextInt(Mth.m_14045_((int)fissureStartPositions.size(), (int)1, (int)7)));
        List<BlockPos> selected = Helpers.uniqueRandomSample(fissureStartPositions, fissureStarts, random);
        for (BlockPos start : selected) {
            FissureFeature.placeFissure(level, start, pos, mutablePos, random, config.fluidState(), rockState, 10, 22, 6, 16, 12, config.decoration().orElse(null));
        }
        return true;
    }

    private boolean setFissureBaseBlock(HotSpringConfig config, WorldGenLevel level, BlockPos pos, BlockState state) {
        BlockState stateAt = level.m_8055_(pos);
        if (HotSpringFeature.isEmptyBlock(config, stateAt)) {
            return false;
        }
        level.m_7731_(pos, state, 2);
        return true;
    }

    private static boolean isEmptyBlock(HotSpringConfig config, BlockState state) {
        return config.allowUnderwater() ? FluidHelpers.isAirOrEmptyFluid(state) : state.m_60795_();
    }
}

