/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.dries007.tfc.world.biome.BiomeExtension;
import net.dries007.tfc.world.biome.BiomeSourceExtension;
import net.dries007.tfc.world.biome.TFCBiomeSource;
import net.dries007.tfc.world.biome.TFCBiomes;
import net.dries007.tfc.world.chunkdata.TFCChunkDataGenerator;
import net.dries007.tfc.world.layer.TFCLayers;
import net.dries007.tfc.world.layer.framework.ConcurrentArea;
import net.dries007.tfc.world.region.RegionGenerator;
import net.dries007.tfc.world.region.Units;
import net.dries007.tfc.world.river.Flow;
import net.dries007.tfc.world.river.MidpointFractal;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;

public class RegionBiomeSource
extends TFCBiomeSource {
    public static final Codec<RegionBiomeSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BiomeSourceExtension.Settings.CODEC.forGetter(BiomeSourceExtension::settings), (App)RegistryOps.m_206832_((ResourceKey)Registry.f_122885_).forGetter(c -> c.biomeRegistry)).apply((Applicative)instance, RegionBiomeSource::new));
    public static final float RIVER_WIDTH = 0.052f;
    private final RegionGenerator regionGenerator;
    private final ConcurrentArea<BiomeExtension> biomeLayer;

    public RegionBiomeSource(BiomeSourceExtension.Settings settings, Registry<Biome> biomeRegistry) {
        super(settings, biomeRegistry, new TFCChunkDataGenerator(settings), TFCBiomes.getAllKeys());
        XoroshiroRandomSource random = new XoroshiroRandomSource(settings.seed());
        this.regionGenerator = new RegionGenerator(random.nextLong());
        this.biomeLayer = new ConcurrentArea<BiomeExtension>(TFCLayers.createRegionBiomeLayerWithRivers(this.regionGenerator, random.nextLong()), TFCLayers::getFromLayerId);
    }

    @Override
    public BiomeExtension getNoiseBiomeVariants(int quartX, int quartZ) {
        return this.biomeLayer.get(quartX, quartZ);
    }

    @Override
    public Flow getRiverFlow(int quartX, int quartZ) {
        int gridX = Units.quartToGrid(quartX);
        int gridZ = Units.quartToGrid(quartZ);
        float exactGridX = Units.quartToGridExact(quartX);
        float exactGridZ = Units.quartToGridExact(quartZ);
        for (MidpointFractal fractal : this.regionGenerator.getOrCreatePartition(gridX, gridZ).get(gridX, gridZ).rivers()) {
            Flow flow;
            if (!fractal.maybeIntersect(exactGridX, exactGridZ, 0.052f) || (flow = fractal.intersectWithFlow(exactGridX, exactGridZ, 0.052f)) == Flow.NONE) continue;
            return flow;
        }
        return Flow.NONE;
    }

    protected Codec<? extends BiomeSource> m_5820_() {
        return CODEC;
    }

    @Override
    public TFCBiomeSource withSeed(long seed) {
        return new RegionBiomeSource(this.settings.withSeed(seed), (Registry<Biome>)this.biomeRegistry);
    }
}

