/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.dries007.tfc.util.IArtist;
import net.dries007.tfc.world.biome.BiomeExtension;
import net.dries007.tfc.world.biome.BiomeSourceExtension;
import net.dries007.tfc.world.biome.TFCBiomeSource;
import net.dries007.tfc.world.biome.TFCBiomes;
import net.dries007.tfc.world.chunkdata.TFCChunkDataGenerator;
import net.dries007.tfc.world.layer.TFCLayers;
import net.dries007.tfc.world.layer.framework.ConcurrentArea;
import net.dries007.tfc.world.river.Flow;
import net.dries007.tfc.world.river.MidpointFractal;
import net.dries007.tfc.world.river.Watershed;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;

public class LegacyBiomeSource
extends TFCBiomeSource {
    public static final Codec<LegacyBiomeSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BiomeSourceExtension.Settings.CODEC.forGetter(BiomeSourceExtension::settings), (App)RegistryOps.m_206832_((ResourceKey)Registry.f_122885_).forGetter(c -> c.biomeRegistry)).apply((Applicative)instance, LegacyBiomeSource::new));
    protected final ConcurrentArea<BiomeExtension> biomeLayer;
    protected final Watershed.Context watersheds;

    public LegacyBiomeSource(BiomeSourceExtension.Settings settings, Registry<Biome> biomeRegistry) {
        super(settings, biomeRegistry, new TFCChunkDataGenerator(settings), TFCBiomes.getAllKeys());
        long seed = settings.seed();
        this.watersheds = new Watershed.Context(TFCLayers.createEarlyPlateLayers(seed), seed, 0.5f, 0.8f, 14, 0.2f);
        this.biomeLayer = new ConcurrentArea<BiomeExtension>(TFCLayers.createOverworldBiomeLayerWithRivers(seed, this.watersheds, IArtist.nope(), IArtist.nope()), TFCLayers::getFromLayerId);
    }

    @Override
    public Flow getRiverFlow(int quartX, int quartZ) {
        float scale = 0.0078125f;
        float x0 = (float)quartX * 0.0078125f;
        float z0 = (float)quartZ * 0.0078125f;
        for (MidpointFractal fractal : this.watersheds.getFractalsByPartition(quartX, quartZ)) {
            Flow flow;
            if (!fractal.maybeIntersect(x0, z0, 0.013f) || (flow = fractal.intersectWithFlow(x0, z0, 0.013f)) == Flow.NONE) continue;
            return flow;
        }
        return Flow.NONE;
    }

    @Override
    public BiomeExtension getNoiseBiomeVariants(int quartX, int quartZ) {
        return this.biomeLayer.get(quartX, quartZ);
    }

    @Override
    public LegacyBiomeSource withSeed(long seed) {
        return new LegacyBiomeSource(this.settings.withSeed(seed), (Registry<Biome>)this.biomeRegistry);
    }

    protected Codec<LegacyBiomeSource> m_5820_() {
        return CODEC;
    }
}

