/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Random;
import net.dries007.tfc.world.TFCStructureHooks;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.chunkdata.ChunkDataProvider;
import net.dries007.tfc.world.placement.ClimatePlacement;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;

public record TFCStructurePlacement(StructurePlacement delegate, Optional<ClimatePlacement> climate, PositionalRandomFactory fork, String randomName) implements StructurePlacement
{
    public static final Codec<TFCStructurePlacement> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)StructurePlacement.f_205036_.fieldOf("placement").forGetter(TFCStructurePlacement::delegate), (App)ClimatePlacement.PLACEMENT_CODEC.optionalFieldOf("climate").forGetter(TFCStructurePlacement::climate), (App)Codec.STRING.fieldOf("random_name").forGetter(TFCStructurePlacement::randomName)).apply((Applicative)instance, TFCStructurePlacement::new)).codec();

    public TFCStructurePlacement(StructurePlacement delegate, Optional<ClimatePlacement> climate, String randomName) {
        this(delegate, climate, TFCStructurePlacement.hash(randomName), randomName);
    }

    private static PositionalRandomFactory hash(String name) {
        return new XoroshiroRandomSource(18729341234L, 9182639418231L).m_183423_().m_183211_(name).m_183423_();
    }

    public boolean m_212129_(ChunkGenerator generator, long seed, int x, int z) {
        if (!this.delegate.m_212129_(generator, seed, x, z)) {
            return false;
        }
        ChunkDataProvider provider = ChunkDataProvider.get(generator);
        ChunkPos chunkPos = new ChunkPos(x, z);
        int blockX = chunkPos.m_45604_();
        int blockZ = chunkPos.m_45605_();
        BlockPos blockPos = new BlockPos(blockX, 0, blockZ);
        ChunkData data = provider.get(chunkPos);
        RandomSource random = this.getRandom(seed, x, z);
        WorldgenRandom worldgenRandom = new WorldgenRandom(random);
        return this.climate.isEmpty() || this.climate.get().isValid(data, blockPos, (Random)worldgenRandom);
    }

    public StructurePlacementType<?> m_203443_() {
        return (StructurePlacementType)TFCStructureHooks.TFC_STRUCTURE_PLACEMENT.get();
    }

    private RandomSource getRandom(long levelSeed, int chunkX, int chunkZ) {
        return this.fork.m_183161_((int)levelSeed, chunkX, chunkZ);
    }
}

