/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import net.dries007.tfc.mixin.accessor.ChunkAccessAccessor;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.BiomeNoiseSampler;
import net.dries007.tfc.world.ChunkBaseBlockSource;
import net.dries007.tfc.world.ChunkHeightFiller;
import net.dries007.tfc.world.ChunkNoiseFiller;
import net.dries007.tfc.world.FastConcurrentCache;
import net.dries007.tfc.world.NoopClimateSampler;
import net.dries007.tfc.world.Sampler;
import net.dries007.tfc.world.TFCAquifer;
import net.dries007.tfc.world.biome.BiomeExtension;
import net.dries007.tfc.world.biome.TFCBiomeSource;
import net.dries007.tfc.world.biome.TFCBiomes;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.chunkdata.ChunkDataProvider;
import net.dries007.tfc.world.chunkdata.ChunkGeneratorExtension;
import net.dries007.tfc.world.chunkdata.RockData;
import net.dries007.tfc.world.noise.ChunkNoiseSamplingSettings;
import net.dries007.tfc.world.noise.Kernel;
import net.dries007.tfc.world.noise.NoiseSampler;
import net.dries007.tfc.world.surface.SurfaceManager;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraftforge.registries.DeferredRegister;

public class TFCChunkGenerator
extends ChunkGenerator
implements ChunkGeneratorExtension {
    public static final Codec<TFCChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryOps.m_206832_((ResourceKey)Registry.f_211073_).forGetter(c -> c.f_207955_), (App)RegistryOps.m_206832_((ResourceKey)Registry.f_194568_).forGetter(c -> c.parameters), (App)BiomeSource.f_47888_.comapFlatMap(TFCChunkGenerator::guardBiomeSource, Function.identity()).fieldOf("biome_source").forGetter(c -> c.customBiomeSource), (App)NoiseGeneratorSettings.f_64431_.fieldOf("noise_settings").forGetter(c -> c.settings), (App)Codec.BOOL.fieldOf("flat_bedrock").forGetter(c -> c.flatBedrock), (App)Codec.LONG.optionalFieldOf("seed", (Object)0L).forGetter(c -> c.seed)).apply((Applicative)instance, TFCChunkGenerator::new));
    public static final DeferredRegister<Codec<? extends ChunkGenerator>> CHUNK_GENERATOR = DeferredRegister.create((ResourceKey)Registry.f_122853_, (String)"tfc");
    public static final int DECORATION_STEPS = GenerationStep.Decoration.values().length;
    public static final int SEA_LEVEL_Y = 63;
    public static final Kernel KERNEL_9x9;
    public static final Kernel KERNEL_5x5;
    private final Registry<StructureSet> structures;
    private final Registry<NormalNoise.NoiseParameters> parameters;
    private final TFCBiomeSource customBiomeSource;
    private final Holder<NoiseGeneratorSettings> settings;
    private final boolean flatBedrock;
    private final long seed;
    private final NoiseBasedChunkGenerator stupidMojangChunkGenerator;
    private final FastConcurrentCache<TFCAquifer> aquiferCache;
    private final Map<BiomeExtension, Supplier<BiomeNoiseSampler>> biomeNoiseSamplers;
    private final ChunkDataProvider chunkDataProvider;
    private final SurfaceManager surfaceManager;
    private final NoiseSampler noiseSampler;
    private final boolean hasStructures;

    public static <T> void composeSampleWeights(Object2DoubleMap<T> weightMap, Object2DoubleMap<T> groupWeightMap, ToIntFunction<T> groupFunction, int groups) {
        double[] maxWeights = new double[groups];
        for (Object2DoubleMap.Entry entry : groupWeightMap.object2DoubleEntrySet()) {
            int group = groupFunction.applyAsInt(entry.getKey());
            if (group == -1) continue;
            int n = group;
            maxWeights[n] = maxWeights[n] + entry.getDoubleValue();
        }
        double[] actualWeights = new double[groups];
        ObjectIterator iterator = weightMap.object2DoubleEntrySet().iterator();
        while (iterator.hasNext()) {
            Object2DoubleMap.Entry entry = (Object2DoubleMap.Entry)iterator.next();
            int group = groupFunction.applyAsInt(entry.getKey());
            if (group == -1) continue;
            int n = group;
            actualWeights[n] = actualWeights[n] + entry.getDoubleValue();
            iterator.remove();
        }
        for (Object2DoubleMap.Entry entry : groupWeightMap.object2DoubleEntrySet()) {
            int group = groupFunction.applyAsInt(entry.getKey());
            if (group == -1 || !(actualWeights[group] > 0.0) || !(maxWeights[group] > 0.0)) continue;
            weightMap.put(entry.getKey(), entry.getDoubleValue() * actualWeights[group] / maxWeights[group]);
        }
    }

    public static TFCChunkGenerator defaultChunkGenerator(Registry<StructureSet> structures, Registry<NormalNoise.NoiseParameters> parameters, Holder<NoiseGeneratorSettings> noiseGeneratorSettings, Registry<Biome> biomeRegistry, long seed) {
        return new TFCChunkGenerator(structures, parameters, TFCBiomeSource.defaultBiomeSource(seed, biomeRegistry), noiseGeneratorSettings, false, seed);
    }

    public static <T> void sampleBiomesCornerContribution(Object2DoubleMap<T> accumulator, Object2DoubleMap<T> corner, double t) {
        if (t > 0.0) {
            for (Object2DoubleMap.Entry entry : corner.object2DoubleEntrySet()) {
                accumulator.mergeDouble(entry.getKey(), entry.getDoubleValue() * t, Double::sum);
            }
        }
    }

    private static Map<BiomeExtension, Supplier<BiomeNoiseSampler>> collectBiomeNoiseSamplers(long seed) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BiomeExtension variant : TFCBiomes.getExtensions()) {
            builder.put((Object)variant, () -> variant.createNoiseSampler(seed));
        }
        return builder.build();
    }

    private static DataResult<TFCBiomeSource> guardBiomeSource(BiomeSource source) {
        DataResult dataResult;
        if (source instanceof TFCBiomeSource) {
            TFCBiomeSource s = (TFCBiomeSource)source;
            dataResult = DataResult.success((Object)s);
        } else {
            dataResult = DataResult.error((String)("Must be a " + TFCBiomeSource.class.getSimpleName()));
        }
        return dataResult;
    }

    private static <T> Object2DoubleMap<T>[] sampleBiomes(ChunkPos pos, Sampler<T> biomeSampler, Function<T, BiomeExtension.Group> groupFunction) {
        Object2DoubleMap<T>[] chunkBiomeWeightArray = TFCChunkGenerator.newWeightArray(16);
        int chunkX = pos.m_45604_();
        int chunkZ = pos.m_45605_();
        for (int x = 0; x < 4; ++x) {
            for (int z = 0; z < 4; ++z) {
                Object2DoubleOpenHashMap chunkBiomeWeight;
                chunkBiomeWeightArray[x | z << 2] = chunkBiomeWeight = new Object2DoubleOpenHashMap();
                TFCChunkGenerator.sampleBiomesAtPositionWithKernel(chunkBiomeWeight, biomeSampler, KERNEL_9x9, 4, chunkX, chunkZ, x - 1, z - 1);
            }
        }
        Object2DoubleMap<T>[] quartBiomeWeightArray = TFCChunkGenerator.newWeightArray(49);
        Object2DoubleOpenHashMap chunkBiomeWeight = new Object2DoubleOpenHashMap();
        Object2DoubleOpenHashMap wideQuartBiomeWeight = new Object2DoubleOpenHashMap();
        for (int x = 0; x < 7; ++x) {
            for (int z = 0; z < 7; ++z) {
                wideQuartBiomeWeight.clear();
                chunkBiomeWeight.clear();
                TFCChunkGenerator.sampleBiomesAtPositionWithKernel(wideQuartBiomeWeight, biomeSampler, KERNEL_9x9, 2, chunkX, chunkZ, x - 1, z - 1);
                int x1 = chunkX + (x - 1 << 2);
                int z1 = chunkZ + (z - 1 << 2);
                int coordX = x1 >> 4;
                int coordZ = z1 >> 4;
                double lerpX = (double)(x1 - (coordX << 4)) * 0.0625;
                double lerpZ = (double)(z1 - (coordZ << 4)) * 0.0625;
                int index16X = (x1 - chunkX >> 4) + 1;
                int index16Z = (z1 - chunkZ >> 4) + 1;
                TFCChunkGenerator.sampleBiomesCornerContribution(chunkBiomeWeight, chunkBiomeWeightArray[index16X | index16Z << 2], (1.0 - lerpX) * (1.0 - lerpZ));
                TFCChunkGenerator.sampleBiomesCornerContribution(chunkBiomeWeight, chunkBiomeWeightArray[index16X + 1 | index16Z << 2], lerpX * (1.0 - lerpZ));
                TFCChunkGenerator.sampleBiomesCornerContribution(chunkBiomeWeight, chunkBiomeWeightArray[index16X | index16Z + 1 << 2], (1.0 - lerpX) * lerpZ);
                TFCChunkGenerator.sampleBiomesCornerContribution(chunkBiomeWeight, chunkBiomeWeightArray[index16X + 1 | index16Z + 1 << 2], lerpX * lerpZ);
                TFCChunkGenerator.composeSampleWeights(wideQuartBiomeWeight, chunkBiomeWeight, biome -> {
                    BiomeExtension.Group group = (BiomeExtension.Group)((Object)((Object)groupFunction.apply(biome)));
                    return group.ordinal();
                }, BiomeExtension.Group.SIZE);
                Object2DoubleOpenHashMap quartBiomeWeight = new Object2DoubleOpenHashMap();
                TFCChunkGenerator.sampleBiomesAtPositionWithKernel(quartBiomeWeight, biomeSampler, KERNEL_5x5, 2, chunkX, chunkZ, x - 1, z - 1);
                TFCChunkGenerator.composeSampleWeights(quartBiomeWeight, wideQuartBiomeWeight, biome -> {
                    BiomeExtension.Group group = (BiomeExtension.Group)((Object)((Object)groupFunction.apply(biome)));
                    return group == BiomeExtension.Group.RIVER ? 1 : 0;
                }, 2);
                quartBiomeWeightArray[x + 7 * z] = quartBiomeWeight;
            }
        }
        return quartBiomeWeightArray;
    }

    private static <T> void sampleBiomesAtPositionWithKernel(Object2DoubleMap<T> weights, Sampler<T> biomeSampler, Kernel kernel, int kernelBits, int chunkX, int chunkZ, int xOffsetInKernelBits, int zOffsetInKernelBits) {
        int kernelRadius = kernel.radius();
        int kernelWidth = kernel.width();
        for (int dx = -kernelRadius; dx <= kernelRadius; ++dx) {
            for (int dz = -kernelRadius; dz <= kernelRadius; ++dz) {
                double weight = kernel.values()[dx + kernelRadius + (dz + kernelRadius) * kernelWidth];
                int blockX = chunkX + (xOffsetInKernelBits + dx << kernelBits);
                int blockZ = chunkZ + (zOffsetInKernelBits + dz << kernelBits);
                T biome = biomeSampler.get(blockX, blockZ);
                weights.mergeDouble(biome, weight, Double::sum);
            }
        }
    }

    private static <T> Object2DoubleMap<T>[] newWeightArray(int size) {
        return new Object2DoubleMap[size];
    }

    public TFCChunkGenerator(Registry<StructureSet> structures, Registry<NormalNoise.NoiseParameters> parameters, TFCBiomeSource biomeSource, Holder<NoiseGeneratorSettings> settings, boolean flatBedrock, long seed) {
        super(structures, Optional.empty(), (BiomeSource)biomeSource);
        this.structures = structures;
        this.parameters = parameters;
        this.settings = settings;
        this.customBiomeSource = biomeSource;
        this.flatBedrock = flatBedrock;
        this.seed = seed;
        this.stupidMojangChunkGenerator = new NoiseBasedChunkGenerator(structures, parameters, (BiomeSource)biomeSource, seed, settings);
        this.aquiferCache = new FastConcurrentCache(256);
        this.biomeNoiseSamplers = TFCChunkGenerator.collectBiomeNoiseSamplers(seed);
        this.chunkDataProvider = this.customBiomeSource.getChunkDataProvider();
        this.surfaceManager = new SurfaceManager(seed);
        this.noiseSampler = new NoiseSampler(((NoiseGeneratorSettings)this.settings.m_203334_()).f_64439_(), seed, parameters);
        this.hasStructures = structures.m_183450_() > 0;
    }

    @Override
    public ChunkDataProvider getChunkDataProvider() {
        return this.chunkDataProvider;
    }

    @Override
    public Aquifer getOrCreateAquifer(ChunkAccess chunk) {
        ChunkNoiseSamplingSettings settings = this.createNoiseSamplingSettingsForChunk(chunk);
        ChunkBaseBlockSource baseBlockSource = this.createBaseBlockSourceForChunk(chunk);
        return this.getOrCreateAquifer(chunk, settings, baseBlockSource);
    }

    protected Codec<TFCChunkGenerator> m_6909_() {
        return CODEC;
    }

    public ChunkGenerator m_6819_(long seed) {
        return new TFCChunkGenerator(this.structures, this.parameters, this.customBiomeSource.withSeed(seed), this.settings, this.flatBedrock, seed);
    }

    public CompletableFuture<ChunkAccess> m_196423_(Registry<Biome> biomeRegistry, Executor executor, Blender legacyTerrainBlender, StructureFeatureManager structureFeatureManager, ChunkAccess chunk) {
        this.chunkDataProvider.get(chunk);
        chunk.m_183442_((quartX, quartY, quartZ, sampler) -> this.customBiomeSource.getNoiseBiome(quartX, quartZ), this.m_183403_());
        return CompletableFuture.completedFuture(chunk);
    }

    public Climate.Sampler m_183403_() {
        return NoopClimateSampler.INSTANCE;
    }

    public void m_183516_(WorldGenRegion level, long seed, BiomeManager biomeManager, StructureFeatureManager structureFeatureManager, ChunkAccess chunk, GenerationStep.Carving step) {
        if (step != GenerationStep.Carving.AIR) {
            return;
        }
        BiomeManager customBiomeManager = biomeManager.m_186687_((x, y, z) -> this.customBiomeSource.getNoiseBiome(x, z));
        PositionalRandomFactory fork = new XoroshiroRandomSource(seed).m_183423_();
        Random random = new Random();
        ChunkPos chunkPos = chunk.m_7697_();
        ChunkNoiseSamplingSettings settings = this.createNoiseSamplingSettingsForChunk(chunk);
        ChunkBaseBlockSource baseBlockSource = this.createBaseBlockSourceForChunk(chunk);
        TFCAquifer aquifer = this.getOrCreateAquifer(chunk, settings, baseBlockSource);
        CarvingContext context = new CarvingContext(this.stupidMojangChunkGenerator, null, chunk.m_183618_(), null);
        CarvingMask carvingMask = ((ProtoChunk)chunk).m_183613_(step);
        for (int offsetX = -8; offsetX <= 8; ++offsetX) {
            for (int offsetZ = -8; offsetZ <= 8; ++offsetZ) {
                ChunkPos offsetChunkPos = new ChunkPos(chunkPos.f_45578_ + offsetX, chunkPos.f_45579_ + offsetZ);
                ChunkAccess offsetChunk = level.m_6325_(offsetChunkPos.f_45578_, offsetChunkPos.f_45579_);
                Iterable iterable = ((Biome)offsetChunk.m_204344_(() -> this.customBiomeSource.getNoiseBiome(QuartPos.m_175400_((int)offsetChunkPos.m_45604_()), QuartPos.m_175400_((int)offsetChunkPos.m_45605_()))).m_203334_()).m_47536_().m_204187_(step);
                int i = 1;
                for (Holder holder : iterable) {
                    long chunkSeed = fork.m_183161_(offsetChunkPos.f_45578_, i, offsetChunkPos.f_45579_).nextLong();
                    random.setSeed(chunkSeed);
                    ConfiguredWorldCarver carver = (ConfiguredWorldCarver)holder.m_203334_();
                    if (carver.m_159273_(random)) {
                        carver.m_190712_(context, chunk, arg_0 -> ((BiomeManager)customBiomeManager).m_204214_(arg_0), random, (Aquifer)aquifer, offsetChunkPos, carvingMask);
                    }
                    ++i;
                }
            }
        }
    }

    public void m_183621_(WorldGenRegion level, StructureFeatureManager structureFeatureManager, ChunkAccess chunk) {
        this.makeBedrock(chunk);
    }

    public void m_6929_(WorldGenRegion level) {
        if (!((NoiseGeneratorSettings)this.settings.m_203334_()).f_64445_()) {
            ChunkPos pos = level.m_143488_();
            Holder biome = level.m_204166_(pos.m_45615_().m_175288_(level.m_151558_() - 1));
            WorldgenRandom random = new WorldgenRandom((RandomSource)new XoroshiroRandomSource(RandomSupport.m_189328_()));
            random.m_64690_(level.m_7328_(), pos.m_45604_(), pos.m_45605_());
            NaturalSpawner.m_204175_((ServerLevelAccessor)level, (Holder)biome, (ChunkPos)pos, (Random)random);
        }
    }

    public TFCBiomeSource getBiomeSource() {
        return this.customBiomeSource;
    }

    public int m_6331_() {
        return ((NoiseGeneratorSettings)this.settings.m_203334_()).f_64439_().f_64508_();
    }

    public void m_62199_(RegistryAccess dynamicRegistry, StructureFeatureManager structureFeatureManager, ChunkAccess chunk, StructureManager templateManager, long seed) {
        this.chunkDataProvider.get(chunk);
        super.m_62199_(dynamicRegistry, structureFeatureManager, chunk, templateManager, seed);
    }

    public void m_62177_(WorldGenLevel level, StructureFeatureManager structureFeatureManager, ChunkAccess chunk) {
        super.m_62177_(level, structureFeatureManager, chunk);
    }

    public void m_183372_(WorldGenLevel level, ChunkAccess chunk, StructureFeatureManager structureFeatureManager) {
        ChunkPos chunkPos = chunk.m_7697_();
        SectionPos sectionPos = SectionPos.m_123196_((ChunkPos)chunkPos, (int)level.m_151560_());
        BlockPos originPos = sectionPos.m_123249_();
        Registry structureFeatures = level.m_5962_().m_175515_(Registry.f_122882_);
        Registry placedFeatures = level.m_5962_().m_175515_(Registry.f_194567_);
        Map<Integer, List<ConfiguredStructureFeature>> structureFeaturesByStep = structureFeatures.m_123024_().collect(Collectors.groupingBy(feature -> feature.f_65403_.m_67095_().ordinal()));
        List<BiomeSource.StepFeatureData> orderedFeatures = this.customBiomeSource.m_186733_();
        long baseSeed = Helpers.hash(128739412341L, originPos);
        WorldgenRandom random = new WorldgenRandom((RandomSource)new XoroshiroRandomSource(baseSeed));
        ObjectArraySet allAdjacentBiomes = new ObjectArraySet();
        ChunkPos.m_45596_((ChunkPos)sectionPos.m_123251_(), (int)1).forEach(arg_0 -> TFCChunkGenerator.lambda$applyBiomeDecoration$18(level, (Set)allAdjacentBiomes, arg_0));
        for (int decorationIndex = 0; decorationIndex < Math.max(DECORATION_STEPS, orderedFeatures.size()); ++decorationIndex) {
            if (structureFeatureManager.m_47271_()) {
                int featureIndex = 0;
                for (ConfiguredStructureFeature feature2 : structureFeaturesByStep.getOrDefault(decorationIndex, Collections.emptyList())) {
                    Helpers.seedLargeFeatures((Random)random, baseSeed, featureIndex, decorationIndex);
                    Supplier<String> featureName = () -> structureFeatures.m_7854_((Object)feature2).map(Object::toString).orElseGet(feature2::toString);
                    try {
                        structureFeatureManager.m_207794_(sectionPos, feature2).forEach(arg_0 -> this.lambda$applyBiomeDecoration$20(level, structureFeatureManager, (Random)random, chunk, chunkPos, arg_0));
                    }
                    catch (Exception e) {
                        CrashReport crash = CrashReport.m_127521_((Throwable)e, (String)"Feature placement");
                        crash.m_127514_("Feature").m_128165_("Description", featureName::get);
                        throw new ReportedException(crash);
                    }
                    ++featureIndex;
                }
            }
            if (decorationIndex >= orderedFeatures.size()) continue;
            IntArraySet featureIndices = new IntArraySet();
            for (Biome biome : allAdjacentBiomes) {
                List<HolderSet<PlacedFeature>> featuresPerBiome = TFCBiomes.getExtensionOrThrow((LevelAccessor)level, biome).getFlattenedFeatures(biome);
                if (decorationIndex >= featuresPerBiome.size()) continue;
                HolderSet<PlacedFeature> featuresPerBiomeAtStep = featuresPerBiome.get(decorationIndex);
                BiomeSource.StepFeatureData stepIndex = orderedFeatures.get(decorationIndex);
                for (Holder holder : featuresPerBiomeAtStep) {
                    featureIndices.add(stepIndex.f_196678_().applyAsInt((PlacedFeature)holder.m_203334_()));
                }
            }
            int[] sortedIndices = featureIndices.toIntArray();
            BiomeSource.StepFeatureData step = orderedFeatures.get(decorationIndex);
            Arrays.sort(sortedIndices);
            for (int featureIndex : sortedIndices) {
                PlacedFeature feature3 = (PlacedFeature)step.f_196677_().get(featureIndex);
                Helpers.seedLargeFeatures((Random)random, baseSeed, featureIndex, decorationIndex);
                Supplier<String> featureName = () -> placedFeatures.m_7854_((Object)feature3).map(Object::toString).orElseGet(() -> ((PlacedFeature)feature3).toString());
                try {
                    feature3.m_191806_(level, (ChunkGenerator)this, (Random)random, originPos);
                }
                catch (Exception e) {
                    CrashReport crash = CrashReport.m_127521_((Throwable)e, (String)"Feature placement");
                    crash.m_127514_("Feature").m_128159_("Description", featureName);
                    throw new ReportedException(crash);
                }
            }
        }
        level.m_183406_(null);
    }

    public CompletableFuture<ChunkAccess> m_183489_(Executor mainExecutor, Blender oldTerrainBlender, StructureFeatureManager structureFeatureManager, ChunkAccess chunk) {
        ChunkNoiseSamplingSettings settings = this.createNoiseSamplingSettingsForChunk(chunk);
        LevelAccessor actualLevel = (LevelAccessor)((ChunkAccessAccessor)chunk).accessor$getLevelHeightAccessor();
        ChunkPos chunkPos = chunk.m_7697_();
        XoroshiroRandomSource random = new XoroshiroRandomSource((long)chunkPos.f_45578_ * 1842639486192314L, (long)chunkPos.f_45579_ * 579238196380231L);
        ChunkData chunkData = this.chunkDataProvider.get(chunk);
        RockData rockData = chunkData.getRockData();
        HashSet<LevelChunkSection> sections = new HashSet<LevelChunkSection>();
        for (LevelChunkSection section : chunk.m_7103_()) {
            section.m_62981_();
            sections.add(section);
        }
        Object2DoubleMap<BiomeExtension>[] biomeWeights = TFCChunkGenerator.sampleBiomes(chunkPos, this::sampleBiomeVariants, BiomeExtension::getGroup);
        ChunkBaseBlockSource baseBlockSource = this.createBaseBlockSourceForChunk(chunk);
        ChunkNoiseFiller filler = new ChunkNoiseFiller(actualLevel, (ProtoChunk)chunk, biomeWeights, this.customBiomeSource, this.createBiomeSamplersForChunk(), this.customBiomeSource::getBiome, this.noiseSampler, baseBlockSource, settings, this.m_6337_());
        filler.setupAquiferSurfaceHeight(this::sampleBiomeVariants);
        chunkData.setAquiferSurfaceHeight(filler.aquifer().getSurfaceHeights());
        rockData.setSurfaceHeight(filler.getSurfaceHeight());
        filler.fillFromNoise();
        this.aquiferCache.set(chunkPos.f_45578_, chunkPos.f_45579_, filler.aquifer());
        sections.forEach(LevelChunkSection::m_63006_);
        this.surfaceManager.buildSurface(actualLevel, chunk, this.getRockLayerSettings(), chunkData, filler.getLocalBiomes(), filler.getLocalBiomeWeights(), filler.getSlopeMap(), (RandomSource)random, this.m_6337_(), settings.minY());
        return CompletableFuture.completedFuture(chunk);
    }

    public int m_6337_() {
        return 63;
    }

    public int m_142062_() {
        return ((NoiseGeneratorSettings)this.settings.m_203334_()).f_64439_().f_158688_();
    }

    public int m_142647_(int x, int z, Heightmap.Types type, LevelHeightAccessor level) {
        ChunkPos pos = new ChunkPos(SectionPos.m_123171_((int)x), SectionPos.m_123171_((int)z));
        return (int)this.createHeightFillerForChunk(pos).sampleHeight(x, z);
    }

    public NoiseColumn m_141914_(int x, int z, LevelHeightAccessor level) {
        return new NoiseColumn(0, new BlockState[0]);
    }

    public void m_207076_(List<String> list, BlockPos pos) {
    }

    public WeightedRandomList<MobSpawnSettings.SpawnerData> m_203315_(Holder<Biome> biome, StructureFeatureManager structureManager, MobCategory category, BlockPos pos) {
        return this.hasStructures ? super.m_203315_(biome, structureManager, category, pos) : ((Biome)biome.m_203334_()).m_47518_().m_151798_(category);
    }

    protected void makeBedrock(ChunkAccess chunk) {
        ChunkPos chunkPos = chunk.m_7697_();
        XoroshiroRandomSource random = new XoroshiroRandomSource((long)chunkPos.f_45578_ * 2369412341L, (long)chunkPos.f_45579_ * 8192836412341L);
        LevelChunkSection bottomSection = chunk.m_183278_(0);
        BlockState bedrock = Blocks.f_50752_.m_49966_();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                if (this.flatBedrock) {
                    bottomSection.m_62991_(x, 0, z, bedrock, false);
                    continue;
                }
                for (int y = 0; y < 6; ++y) {
                    if (random.nextInt(6) >= 6 - y) continue;
                    bottomSection.m_62991_(x, y, z, bedrock, false);
                }
            }
        }
    }

    private BoundingBox getBoundingBoxForStructure(ChunkAccess chunk) {
        ChunkPos pos = chunk.m_7697_();
        int blockX = pos.m_45604_();
        int blockZ = pos.m_45605_();
        LevelHeightAccessor level = chunk.m_183618_();
        return new BoundingBox(blockX, level.m_141937_() + 1, blockZ, blockX + 15, level.m_151558_() - 1, blockZ + 15);
    }

    private BiomeExtension sampleBiomeVariants(int blockX, int blockZ) {
        return this.customBiomeSource.getNoiseBiomeVariants(QuartPos.m_175400_((int)blockX), QuartPos.m_175400_((int)blockZ));
    }

    public ChunkHeightFiller createHeightFillerForChunk(ChunkPos pos) {
        Object2DoubleMap<BiomeExtension>[] biomeWeights = TFCChunkGenerator.sampleBiomes(pos, this::sampleBiomeVariants, BiomeExtension::getGroup);
        return new ChunkHeightFiller(this.createBiomeSamplersForChunk(), biomeWeights);
    }

    private ChunkBaseBlockSource createBaseBlockSourceForChunk(ChunkAccess chunk) {
        RockData rockData = this.chunkDataProvider.get(chunk).getRockData();
        return new ChunkBaseBlockSource(rockData, this::sampleBiomeVariants);
    }

    private ChunkNoiseSamplingSettings createNoiseSamplingSettingsForChunk(ChunkAccess chunk) {
        return this.createNoiseSamplingSettingsForChunk(chunk.m_7697_(), chunk.m_183618_());
    }

    private ChunkNoiseSamplingSettings createNoiseSamplingSettingsForChunk(ChunkPos pos, LevelHeightAccessor level) {
        NoiseSettings noiseSettings = ((NoiseGeneratorSettings)this.settings.m_203334_()).f_64439_();
        int cellWidth = noiseSettings.m_189213_();
        int cellHeight = noiseSettings.m_189212_();
        int minY = Math.max(noiseSettings.f_158688_(), level.m_141937_());
        int maxY = Math.min(noiseSettings.f_158688_() + noiseSettings.f_64508_(), level.m_151558_());
        int cellCountY = Math.floorDiv(maxY - minY, noiseSettings.m_189212_());
        int firstCellX = Math.floorDiv(pos.m_45604_(), cellWidth);
        int firstCellY = Math.floorDiv(minY, cellHeight);
        int firstCellZ = Math.floorDiv(pos.m_45605_(), cellWidth);
        return new ChunkNoiseSamplingSettings(minY, 16 / cellWidth, cellCountY, cellWidth, cellHeight, firstCellX, firstCellY, firstCellZ);
    }

    private Map<BiomeExtension, BiomeNoiseSampler> createBiomeSamplersForChunk() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<BiomeExtension, Supplier<BiomeNoiseSampler>> entry : this.biomeNoiseSamplers.entrySet()) {
            builder.put((Object)entry.getKey(), (Object)entry.getValue().get());
        }
        return builder.build();
    }

    private TFCAquifer getOrCreateAquifer(ChunkAccess chunk, ChunkNoiseSamplingSettings settings, ChunkBaseBlockSource baseBlockSource) {
        ChunkPos chunkPos = chunk.m_7697_();
        TFCAquifer aquifer = this.aquiferCache.getIfPresent(chunkPos.f_45578_, chunkPos.f_45579_);
        if (aquifer == null) {
            ChunkData chunkData = this.chunkDataProvider.get(chunk);
            aquifer = new TFCAquifer(chunkPos, settings, baseBlockSource, this.m_6337_(), this.noiseSampler.positionalRandomFactory, this.noiseSampler.barrierNoise);
            aquifer.setSurfaceHeights(chunkData.getAquiferSurfaceHeight());
            this.aquiferCache.set(chunkPos.f_45578_, chunkPos.f_45579_, aquifer);
        }
        return aquifer;
    }

    private /* synthetic */ void lambda$applyBiomeDecoration$20(WorldGenLevel level, StructureFeatureManager structureFeatureManager, Random random, ChunkAccess chunk, ChunkPos chunkPos, StructureStart start) {
        start.m_7129_(level, structureFeatureManager, (ChunkGenerator)this, random, this.getBoundingBoxForStructure(chunk), chunkPos);
    }

    private static /* synthetic */ void lambda$applyBiomeDecoration$18(WorldGenLevel level, Set allAdjacentBiomes, ChunkPos chunkPos1_) {
        ChunkAccess adjChunk = level.m_6325_(chunkPos1_.f_45578_, chunkPos1_.f_45579_);
        for (LevelChunkSection adjSection : adjChunk.m_7103_()) {
            adjSection.m_188013_().m_196879_(biome -> allAdjacentBiomes.add((Biome)biome.m_203334_()));
        }
    }

    static {
        CHUNK_GENERATOR.register("overworld", () -> CODEC);
        KERNEL_9x9 = Kernel.create((x, z) -> 0.0211640211641 * (1.0 - 0.03125 * (double)(z * z + x * x)), 4);
        KERNEL_5x5 = Kernel.create((x, z) -> 0.08 * (1.0 - 0.125 * (double)(z * z + x * x)), 2);
    }
}

