/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.tracker;

import java.util.Random;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.tracker.WorldTrackerCapability;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.ServerLevelData;

public final class WeatherHelpers {
    private static final int MIN_RAIN_TIME = 18000;
    private static final int MAX_RAIN_TIME = 24000;
    private static final int MIN_RAIN_DELAY_TIME = 12000;
    private static final int MAX_RAIN_DELAY_TIME = 84000;

    public static void preAdvancedWeatherCycle(ServerLevel level) {
        LevelData levelData;
        if (level.m_6042_().m_63935_() && level.m_46469_().m_46207_(GameRules.f_46150_) && (levelData = level.m_6106_()) instanceof ServerLevelData) {
            ServerLevelData serverLevelData = (ServerLevelData)levelData;
            int rainTime = serverLevelData.m_6531_();
            if (serverLevelData.m_6537_() <= 0 && rainTime <= 0) {
                if (serverLevelData.m_6533_()) {
                    rainTime = Mth.m_144928_((Random)level.f_46441_, (int)18000, (int)24000);
                    long rainStartTick = Calendars.get((LevelReader)level).getTicks();
                    long rainEndTick = rainStartTick + (long)rainTime;
                    float rainIntensity = level.f_46441_.nextFloat();
                    level.getCapability(WorldTrackerCapability.CAPABILITY).ifPresent(tracker -> tracker.setWeatherData(rainStartTick, rainEndTick, rainIntensity));
                } else {
                    rainTime = Mth.m_144928_((Random)level.f_46441_, (int)12000, (int)84000);
                }
                serverLevelData.m_6399_(rainTime);
            }
        }
    }

    private static void advanceWeatherCycleVanillaImplementation(ServerLevel level, ServerLevelData serverLevelData) {
        boolean isRaining = level.m_46471_();
        if (level.m_6042_().m_63935_()) {
            if (level.m_46469_().m_46207_(GameRules.f_46150_)) {
                int weatherClearTime = serverLevelData.m_6537_();
                int thunderTime = serverLevelData.m_6558_();
                int rainTime = serverLevelData.m_6531_();
                boolean isCurrentlyThundering = serverLevelData.m_6534_();
                boolean isCurrentlyRaining = serverLevelData.m_6533_();
                if (weatherClearTime > 0) {
                    --weatherClearTime;
                    thunderTime = isCurrentlyThundering ? 0 : 1;
                    rainTime = isCurrentlyRaining ? 0 : 1;
                    isCurrentlyThundering = false;
                    isCurrentlyRaining = false;
                } else {
                    if (thunderTime > 0) {
                        if (--thunderTime == 0) {
                            isCurrentlyThundering = !isCurrentlyThundering;
                        }
                    } else {
                        thunderTime = isCurrentlyThundering ? Mth.m_144928_((Random)level.f_46441_, (int)3600, (int)15600) : Mth.m_144928_((Random)level.f_46441_, (int)12000, (int)180000);
                    }
                    if (rainTime > 0) {
                        if (--rainTime == 0) {
                            isCurrentlyRaining = !isCurrentlyRaining;
                        }
                    } else {
                        rainTime = isCurrentlyRaining ? Mth.m_144928_((Random)level.f_46441_, (int)12000, (int)24000) : Mth.m_144928_((Random)level.f_46441_, (int)12000, (int)180000);
                    }
                }
                serverLevelData.m_6398_(thunderTime);
                serverLevelData.m_6399_(rainTime);
                serverLevelData.m_6393_(weatherClearTime);
                serverLevelData.m_5557_(isCurrentlyThundering);
                serverLevelData.m_5565_(isCurrentlyRaining);
            }
            level.f_46439_ = level.f_46440_;
            level.f_46440_ = serverLevelData.m_6534_() ? (level.f_46440_ += 0.01f) : (level.f_46440_ -= 0.01f);
            level.f_46440_ = Mth.m_14036_((float)level.f_46440_, (float)0.0f, (float)1.0f);
            level.f_46437_ = level.f_46438_;
            level.f_46438_ = serverLevelData.m_6533_() ? (level.f_46438_ += 0.01f) : (level.f_46438_ -= 0.01f);
            level.f_46438_ = Mth.m_14036_((float)level.f_46438_, (float)0.0f, (float)1.0f);
        }
        if (level.f_46437_ != level.f_46438_) {
            level.m_142572_().m_6846_().m_11270_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132160_, level.f_46438_), level.m_46472_());
        }
        if (level.f_46439_ != level.f_46440_) {
            level.m_142572_().m_6846_().m_11270_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132161_, level.f_46440_), level.m_46472_());
        }
        if (isRaining != level.m_46471_()) {
            if (isRaining) {
                level.m_142572_().m_6846_().m_11270_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132155_, 0.0f), level.m_46472_());
            } else {
                level.m_142572_().m_6846_().m_11270_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132154_, 0.0f), level.m_46472_());
            }
            level.m_142572_().m_6846_().m_11270_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132160_, level.f_46438_), level.m_46472_());
            level.m_142572_().m_6846_().m_11270_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132161_, level.f_46440_), level.m_46472_());
        }
    }
}

