/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.climate;

import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.crop.Crop;
import net.dries007.tfc.common.blocks.plant.fruit.FruitBlocks;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.RegisteredDataManager;
import net.dries007.tfc.util.climate.ClimateRange;

public class ClimateRanges {
    public static final Supplier<ClimateRange> BANANA_PLANT = ClimateRanges.register("plant/banana_tree");
    public static final Supplier<ClimateRange> CRANBERRY_BUSH = ClimateRanges.register("plant/cranberry_bush");
    public static final Map<FruitBlocks.StationaryBush, Supplier<ClimateRange>> STATIONARY_BUSHES = Helpers.mapOfKeys(FruitBlocks.StationaryBush.class, bush -> ClimateRanges.register("plant/" + bush.name() + "_bush"));
    public static final Map<FruitBlocks.SpreadingBush, Supplier<ClimateRange>> SPREADING_BUSHES = Helpers.mapOfKeys(FruitBlocks.SpreadingBush.class, bush -> ClimateRanges.register("plant/" + bush.name() + "_bush"));
    public static final Map<FruitBlocks.Tree, Supplier<ClimateRange>> FRUIT_TREES = Helpers.mapOfKeys(FruitBlocks.Tree.class, tree -> ClimateRanges.register("plant/" + tree.name() + "_tree"));
    public static final Map<Crop, Supplier<ClimateRange>> CROPS = Helpers.mapOfKeys(Crop.class, crop -> ClimateRanges.register("crop/" + crop.m_7912_()));

    private static RegisteredDataManager.Entry<ClimateRange> register(String name) {
        return ClimateRange.MANAGER.register(Helpers.identifier(name.toLowerCase(Locale.ROOT)));
    }
}

