/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import java.util.List;
import java.util.Locale;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.util.EntityDamageResistance;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.ItemDamageResistance;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public enum PhysicalDamageType implements StringRepresentable
{
    CRUSHING,
    SLASHING,
    PIERCING;

    private static final String THORNS = "thorns";
    private static final String ARROW = "arrow";
    private static final String TRIDENT = "trident";
    private final String serializedName = this.name().toLowerCase(Locale.ROOT);

    public static void addTooltipInfo(ItemStack stack, List<Component> tooltips) {
        Multiplier resistanceType;
        PhysicalDamageType damageType = PhysicalDamageType.getTypeForItem(stack);
        if (damageType != null) {
            tooltips.add((Component)Helpers.translatable("tfc.tooltip.deals_damage." + damageType.m_7912_()));
        }
        if ((resistanceType = PhysicalDamageType.getResistanceForItem(stack)) != null) {
            tooltips.add((Component)Helpers.translatable("tfc.tooltip.resists_damage", PhysicalDamageType.calculatePercentageForDisplay(resistanceType.slashing()), PhysicalDamageType.calculatePercentageForDisplay(resistanceType.piercing()), PhysicalDamageType.calculatePercentageForDisplay(resistanceType.crushing())));
        }
    }

    public static float calculateMultiplier(DamageSource source, Entity entityUnderAttack) {
        EntityDamageResistance naturalMultiplier;
        PhysicalDamageType type = PhysicalDamageType.getTypeForSource(source);
        float resistance = 0.0f;
        if (type != null && (naturalMultiplier = EntityDamageResistance.get(entityUnderAttack)) != null) {
            resistance += naturalMultiplier.value(type);
        }
        for (ItemStack stack : entityUnderAttack.m_6168_()) {
            Multiplier armorMultiplier = PhysicalDamageType.getResistanceForItem(stack);
            if (armorMultiplier == null) continue;
            resistance += armorMultiplier.value(type);
        }
        return (float)Math.pow(Math.E, -0.01 * (double)resistance);
    }

    @Nullable
    public static PhysicalDamageType getTypeForSource(DamageSource source) {
        if (source.m_19376_() || source.m_19378_()) {
            return null;
        }
        if (source == DamageSource.f_19314_ || source == DamageSource.f_146702_ || source.m_19385_().equals(THORNS) || source.m_19385_().equals(TRIDENT) || source.m_19385_().equals(ARROW)) {
            return PIERCING;
        }
        if (source == DamageSource.f_19321_ || source == DamageSource.f_19322_) {
            return CRUSHING;
        }
        Entity entity = source.m_7639_();
        if (entity != null) {
            PhysicalDamageType weaponDamageType;
            LivingEntity livingEntity;
            ItemStack heldItem;
            if (entity instanceof LivingEntity && !(heldItem = (livingEntity = (LivingEntity)entity).m_21205_()).m_41619_() && (weaponDamageType = PhysicalDamageType.getTypeForItem(heldItem)) != null) {
                return weaponDamageType;
            }
            if (Helpers.isEntity(entity, TFCTags.Entities.DEALS_PIERCING_DAMAGE)) {
                return PIERCING;
            }
            if (Helpers.isEntity(entity, TFCTags.Entities.DEALS_SLASHING_DAMAGE)) {
                return SLASHING;
            }
            if (Helpers.isEntity(entity, TFCTags.Entities.DEALS_CRUSHING_DAMAGE)) {
                return CRUSHING;
            }
        }
        return null;
    }

    @Nullable
    public static PhysicalDamageType getTypeForItem(ItemStack stack) {
        if (Helpers.isItem(stack, TFCTags.Items.DEALS_PIERCING_DAMAGE)) {
            return PIERCING;
        }
        if (Helpers.isItem(stack, TFCTags.Items.DEALS_SLASHING_DAMAGE)) {
            return SLASHING;
        }
        if (Helpers.isItem(stack, TFCTags.Items.DEALS_CRUSHING_DAMAGE)) {
            return CRUSHING;
        }
        return null;
    }

    @Nullable
    public static Multiplier getResistanceForItem(ItemStack stack) {
        ArmorItem armor;
        ItemDamageResistance res = ItemDamageResistance.get(stack);
        if (res != null) {
            return res;
        }
        Item item = stack.m_41720_();
        if (item instanceof ArmorItem && (item = (armor = (ArmorItem)item).m_40401_()) instanceof Multiplier) {
            Multiplier armorMultiplier = (Multiplier)item;
            return armorMultiplier;
        }
        return null;
    }

    private static Component calculatePercentageForDisplay(float resistance) {
        float multiplier = 1.0f - (float)Math.pow(Math.E, -0.01 * (double)resistance);
        if ((double)multiplier >= 0.999999) {
            return Helpers.translatable("tfc.tooltip.immune_to_damage");
        }
        return Helpers.literal(String.format("%.0f%%", Float.valueOf(multiplier * 100.0f)));
    }

    public String m_7912_() {
        return this.serializedName;
    }

    public static interface Multiplier {
        public float crushing();

        public float piercing();

        public float slashing();

        default public float value(@Nullable PhysicalDamageType type) {
            if (type == null) {
                return Math.max(this.crushing(), Math.max(this.piercing(), this.slashing()));
            }
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case CRUSHING -> this.crushing();
                case SLASHING -> this.slashing();
                case PIERCING -> this.piercing();
            };
        }
    }
}

