/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCArmorMaterials;
import net.dries007.tfc.common.TFCItemGroup;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.TFCTiers;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.TFCChainBlock;
import net.dries007.tfc.common.blocks.devices.AnvilBlock;
import net.dries007.tfc.common.blocks.devices.LampBlock;
import net.dries007.tfc.common.items.ChiselItem;
import net.dries007.tfc.common.items.IngotItem;
import net.dries007.tfc.common.items.JavelinItem;
import net.dries007.tfc.common.items.LampBlockItem;
import net.dries007.tfc.common.items.MaceItem;
import net.dries007.tfc.common.items.PropickItem;
import net.dries007.tfc.common.items.ScytheItem;
import net.dries007.tfc.common.items.TFCFishingRodItem;
import net.dries007.tfc.common.items.TFCHoeItem;
import net.dries007.tfc.common.items.TFCShieldItem;
import net.dries007.tfc.common.items.ToolItem;
import net.dries007.tfc.network.DataManagerSyncPacket;
import net.dries007.tfc.util.DataManager;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.JsonHelpers;
import net.dries007.tfc.util.registry.RegistryMetal;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.HorseArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.Nullable;

public final class Metal {
    public static final ResourceLocation UNKNOWN_ID = Helpers.identifier("unknown");
    public static final ResourceLocation WROUGHT_IRON_ID = Helpers.identifier("wrought_iron");
    public static final DataManager<Metal> MANAGER = new DataManager<Metal>(Helpers.identifier("metals"), "metal", Metal::new, Metal::new, Metal::encode, Packet::new);
    private static final Map<Fluid, Metal> METAL_FLUIDS = new HashMap<Fluid, Metal>();
    private final int tier;
    private final Fluid fluid;
    private final float meltTemperature;
    private final float specificHeatCapacity;
    private final ResourceLocation id;
    private final ResourceLocation textureId;
    private final String translationKey;
    private final Ingredient ingots;
    private final Ingredient sheets;

    @Nullable
    public static Metal get(Fluid fluid) {
        return METAL_FLUIDS.get(fluid);
    }

    public static Metal unknown() {
        return MANAGER.getOrThrow(UNKNOWN_ID);
    }

    @Nullable
    public static Metal getFromIngot(ItemStack stack) {
        for (Metal metal : MANAGER.getValues()) {
            if (!metal.isIngot(stack)) continue;
            return metal;
        }
        return null;
    }

    @Nullable
    public static Metal getFromSheet(ItemStack stack) {
        for (Metal metal : MANAGER.getValues()) {
            if (!metal.isSheet(stack)) continue;
            return metal;
        }
        return null;
    }

    public static void updateMetalFluidMap() {
        Metal.unknown();
        METAL_FLUIDS.clear();
        for (Metal metal : MANAGER.getValues()) {
            METAL_FLUIDS.put(metal.getFluid(), metal);
        }
    }

    public Metal(ResourceLocation id, JsonObject json) {
        this.id = id;
        this.textureId = new ResourceLocation(id.m_135827_(), "block/metal/full/" + id.m_135815_());
        this.tier = JsonHelpers.m_13824_((JsonObject)json, (String)"tier", (int)0);
        this.fluid = (Fluid)JsonHelpers.getRegistryEntry(json, "fluid", ForgeRegistries.FLUIDS);
        this.specificHeatCapacity = JsonHelpers.m_13915_((JsonObject)json, (String)"specific_heat_capacity");
        this.meltTemperature = JsonHelpers.m_13915_((JsonObject)json, (String)"melt_temperature");
        this.translationKey = "metal." + id.m_135827_() + "." + id.m_135815_();
        this.ingots = Ingredient.m_43917_((JsonElement)JsonHelpers.get(json, "ingots"));
        this.sheets = Ingredient.m_43917_((JsonElement)JsonHelpers.get(json, "sheets"));
    }

    public Metal(ResourceLocation id, FriendlyByteBuf buffer) {
        this.id = id;
        this.textureId = new ResourceLocation(id.m_135827_(), "block/metal/full/" + id.m_135815_());
        this.tier = buffer.m_130242_();
        this.fluid = (Fluid)buffer.readRegistryIdUnsafe(ForgeRegistries.FLUIDS);
        this.meltTemperature = buffer.readFloat();
        this.specificHeatCapacity = buffer.readFloat();
        this.translationKey = buffer.m_130277_();
        this.ingots = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        this.sheets = Ingredient.m_43940_((FriendlyByteBuf)buffer);
    }

    public Metal(ResourceLocation id) {
        this.id = id;
        this.textureId = new ResourceLocation(id.m_135827_(), "block/metal/full/" + id.m_135815_());
        this.tier = 0;
        this.fluid = Fluids.f_76191_;
        this.meltTemperature = 0.0f;
        this.specificHeatCapacity = 0.0f;
        this.translationKey = "";
        this.ingots = Ingredient.f_43901_;
        this.sheets = Ingredient.f_43901_;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.tier);
        buffer.writeRegistryIdUnsafe(ForgeRegistries.FLUIDS, (IForgeRegistryEntry)this.fluid);
        buffer.writeFloat(this.meltTemperature);
        buffer.writeFloat(this.specificHeatCapacity);
        buffer.m_130070_(this.translationKey);
        this.ingots.m_43923_(buffer);
        this.sheets.m_43923_(buffer);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public ResourceLocation getTextureId() {
        return this.textureId;
    }

    public int getTier() {
        return this.tier;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public float getMeltTemperature() {
        return this.meltTemperature;
    }

    public float getHeatCapacity(float mB) {
        return this.getSpecificHeatCapacity() * mB;
    }

    public float getSpecificHeatCapacity() {
        return this.specificHeatCapacity;
    }

    public MutableComponent getDisplayName() {
        return Helpers.translatable(this.translationKey);
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public boolean isIngot(ItemStack stack) {
        return this.ingots.test(stack);
    }

    public Ingredient getIngotIngredient() {
        return this.ingots;
    }

    public boolean isSheet(ItemStack stack) {
        return this.sheets.test(stack);
    }

    public Ingredient getSheetIngredient() {
        return this.sheets;
    }

    public static class Packet
    extends DataManagerSyncPacket<Metal> {
    }

    private static enum Type {
        DEFAULT(metal -> true),
        PART(Default::hasParts),
        TOOL(Default::hasTools),
        ARMOR(Default::hasArmor),
        UTILITY(Default::hasUtilities);

        private final Predicate<Default> predicate;

        private Type(Predicate<Default> predicate) {
            this.predicate = predicate;
        }

        boolean hasType(Default metal) {
            return this.predicate.test(metal);
        }
    }

    public static enum ItemType {
        INGOT(Type.DEFAULT, true, metal -> new IngotItem(ItemType.properties())),
        DOUBLE_INGOT(Type.PART, false),
        SHEET(Type.PART, false),
        DOUBLE_SHEET(Type.PART, false),
        ROD(Type.PART, false),
        TUYERE(Type.TOOL, metal -> new TieredItem(metal.toolTier(), ItemType.properties())),
        FISH_HOOK(Type.TOOL, false),
        FISHING_ROD(Type.TOOL, metal -> new TFCFishingRodItem(ItemType.properties().m_41499_(metal.toolTier().m_6609_()), metal.toolTier())),
        PICKAXE(Type.TOOL, metal -> new PickaxeItem(metal.toolTier(), (int)ToolItem.calculateVanillaAttackDamage(0.75f, metal.toolTier()), -2.8f, ItemType.properties())),
        PICKAXE_HEAD(Type.TOOL, true),
        PROPICK(Type.TOOL, metal -> new PropickItem(metal.toolTier(), ToolItem.calculateVanillaAttackDamage(0.5f, metal.toolTier()), -2.8f, ItemType.properties())),
        PROPICK_HEAD(Type.TOOL, true),
        AXE(Type.TOOL, metal -> new AxeItem(metal.toolTier(), ToolItem.calculateVanillaAttackDamage(1.5f, metal.toolTier()), -3.1f, ItemType.properties())),
        AXE_HEAD(Type.TOOL, true),
        SHOVEL(Type.TOOL, metal -> new ShovelItem(metal.toolTier(), ToolItem.calculateVanillaAttackDamage(0.875f, metal.toolTier()), -3.0f, ItemType.properties())),
        SHOVEL_HEAD(Type.TOOL, true),
        HOE(Type.TOOL, metal -> new TFCHoeItem(metal.toolTier(), -1, -2.0f, ItemType.properties())),
        HOE_HEAD(Type.TOOL, true),
        CHISEL(Type.TOOL, metal -> new ChiselItem(metal.toolTier(), ToolItem.calculateVanillaAttackDamage(0.27f, metal.toolTier()), -1.5f, ItemType.properties())),
        CHISEL_HEAD(Type.TOOL, true),
        HAMMER(Type.TOOL, metal -> new ToolItem(metal.toolTier(), ToolItem.calculateVanillaAttackDamage(1.0f, metal.toolTier()), -3.0f, TFCTags.Blocks.MINEABLE_WITH_HAMMER, ItemType.properties())),
        HAMMER_HEAD(Type.TOOL, true),
        SAW(Type.TOOL, metal -> new AxeItem(metal.toolTier(), ToolItem.calculateVanillaAttackDamage(0.5f, metal.toolTier()), -3.0f, ItemType.properties())),
        SAW_BLADE(Type.TOOL, true),
        JAVELIN(Type.TOOL, metal -> new JavelinItem(metal.toolTier(), ToolItem.calculateVanillaAttackDamage(1.0f, metal.toolTier()), -2.2f, ItemType.properties(), metal.m_7912_())),
        JAVELIN_HEAD(Type.TOOL, true),
        SWORD(Type.TOOL, metal -> new SwordItem(metal.toolTier(), (int)ToolItem.calculateVanillaAttackDamage(1.0f, metal.toolTier()), -2.4f, ItemType.properties())),
        SWORD_BLADE(Type.TOOL, true),
        MACE(Type.TOOL, metal -> new MaceItem(metal.toolTier(), (int)ToolItem.calculateVanillaAttackDamage(1.3f, metal.toolTier()), -3.0f, ItemType.properties())),
        MACE_HEAD(Type.TOOL, true),
        KNIFE(Type.TOOL, metal -> new ToolItem(metal.toolTier(), ToolItem.calculateVanillaAttackDamage(0.6f, metal.toolTier()), -2.0f, TFCTags.Blocks.MINEABLE_WITH_KNIFE, ItemType.properties())),
        KNIFE_BLADE(Type.TOOL, true),
        SCYTHE(Type.TOOL, metal -> new ScytheItem(metal.toolTier(), ToolItem.calculateVanillaAttackDamage(0.7f, metal.toolTier()), -3.2f, TFCTags.Blocks.MINEABLE_WITH_SCYTHE, ItemType.properties())),
        SCYTHE_BLADE(Type.TOOL, true),
        SHEARS(Type.TOOL, metal -> new ShearsItem(ItemType.properties().m_41499_(metal.toolTier().m_6609_()))),
        UNFINISHED_HELMET(Type.ARMOR, false),
        HELMET(Type.ARMOR, metal -> new ArmorItem(metal.armorTier(), EquipmentSlot.HEAD, ItemType.properties())),
        UNFINISHED_CHESTPLATE(Type.ARMOR, false),
        CHESTPLATE(Type.ARMOR, metal -> new ArmorItem(metal.armorTier(), EquipmentSlot.CHEST, ItemType.properties())),
        UNFINISHED_GREAVES(Type.ARMOR, false),
        GREAVES(Type.ARMOR, metal -> new ArmorItem(metal.armorTier(), EquipmentSlot.LEGS, ItemType.properties())),
        UNFINISHED_BOOTS(Type.ARMOR, false),
        BOOTS(Type.ARMOR, metal -> new ArmorItem(metal.armorTier(), EquipmentSlot.FEET, ItemType.properties())),
        HORSE_ARMOR(Type.ARMOR, metal -> new HorseArmorItem(Mth.m_14107_((double)((double)metal.armorTier().m_7365_(EquipmentSlot.CHEST) * 1.5)), Helpers.identifier("textures/entity/animal/horse_armor/" + metal.m_7912_() + ".png"), ItemType.properties())),
        SHIELD(Type.TOOL, metal -> new TFCShieldItem(metal.toolTier(), ItemType.properties()));

        private final Function<RegistryMetal, Item> itemFactory;
        private final Type type;
        private final boolean mold;

        public static Item.Properties properties() {
            return new Item.Properties().m_41491_(TFCItemGroup.METAL);
        }

        private ItemType(Type type, boolean mold) {
            this(type, mold, metal -> new Item(ItemType.properties()));
        }

        private ItemType(Type type, Function<RegistryMetal, Item> itemFactory) {
            this(type, false, itemFactory);
        }

        private ItemType(Type type, boolean mold, Function<RegistryMetal, Item> itemFactory) {
            this.type = type;
            this.mold = mold;
            this.itemFactory = itemFactory;
        }

        public Item create(RegistryMetal metal) {
            return this.itemFactory.apply(metal);
        }

        public boolean has(Default metal) {
            return this.type.hasType(metal);
        }

        public boolean hasMold() {
            return this.mold;
        }
    }

    public static enum BlockType {
        ANVIL(Type.UTILITY, metal -> new AnvilBlock(ExtendedProperties.of(Material.f_76279_, MaterialColor.f_76404_).noOcclusion().sound(SoundType.f_56743_).strength(10.0f, 10.0f).requiresCorrectToolForDrops().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.ANVIL), metal.metalTier())),
        CHAIN(Type.UTILITY, metal -> new TFCChainBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76398_).m_60999_().m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56728_).m_60953_(TFCBlocks.lavaLoggedBlockEmission()))),
        LAMP(Type.UTILITY, metal -> new LampBlock(ExtendedProperties.of(Material.f_76279_, MaterialColor.f_76404_).noOcclusion().sound(SoundType.f_56762_).strength(4.0f, 10.0f).randomTicks().pushReaction(PushReaction.DESTROY).lightLevel(state -> (Boolean)state.m_61143_((Property)LampBlock.LIT) != false ? 15 : 0).blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.LAMP)), (block, properties) -> new LampBlockItem((Block)block, properties.m_41487_(1))),
        TRAPDOOR(Type.UTILITY, metal -> new TrapDoorBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76404_).m_60999_().m_60978_(5.0f).m_60918_(SoundType.f_56743_).m_60955_().m_60922_(TFCBlocks::never)));

        private final Function<RegistryMetal, Block> blockFactory;
        private final BiFunction<Block, Item.Properties, ? extends BlockItem> blockItemFactory;
        private final Type type;

        private BlockType(Type type, Function<RegistryMetal, Block> blockFactory, BiFunction<Block, Item.Properties, ? extends BlockItem> blockItemFactory) {
            this.type = type;
            this.blockFactory = blockFactory;
            this.blockItemFactory = blockItemFactory;
        }

        private BlockType(Type type, Function<RegistryMetal, Block> blockFactory) {
            this(type, blockFactory, BlockItem::new);
        }

        public Supplier<Block> create(RegistryMetal metal) {
            return () -> this.blockFactory.apply(metal);
        }

        public Function<Block, BlockItem> createBlockItem(Item.Properties properties) {
            return block -> this.blockItemFactory.apply((Block)block, properties);
        }

        public boolean has(Default metal) {
            return this.type.hasType(metal);
        }
    }

    public static enum Default implements StringRepresentable,
    RegistryMetal
    {
        BISMUTH(-12031118, Rarity.COMMON, true, false, false),
        BISMUTH_BRONZE(-12480945, Rarity.COMMON, Tier.TIER_II, TFCTiers.BISMUTH_BRONZE, TFCArmorMaterials.BISMUTH_BRONZE, true, true, true),
        BLACK_BRONZE(-12900810, Rarity.COMMON, Tier.TIER_II, TFCTiers.BLACK_BRONZE, TFCArmorMaterials.BLACK_BRONZE, true, true, true),
        BRONZE(-6911698, Rarity.COMMON, Tier.TIER_II, TFCTiers.BRONZE, TFCArmorMaterials.BRONZE, true, true, true),
        BRASS(-8626637, Rarity.COMMON, true, false, false),
        COPPER(-4833241, Rarity.COMMON, Tier.TIER_I, TFCTiers.COPPER, TFCArmorMaterials.COPPER, true, true, true),
        GOLD(-2310373, Rarity.COMMON, true, false, false),
        NICKEL(-11645380, Rarity.COMMON, true, false, false),
        ROSE_GOLD(-1347273, Rarity.COMMON, true, false, false),
        SILVER(-7039851, Rarity.COMMON, true, false, false),
        TIN(-7297861, Rarity.COMMON, true, false, false),
        ZINC(-4474428, Rarity.COMMON, true, false, false),
        STERLING_SILVER(-5467525, Rarity.COMMON, true, false, false),
        WROUGHT_IRON(-6776681, Rarity.COMMON, Tier.TIER_III, TFCTiers.WROUGHT_IRON, TFCArmorMaterials.WROUGHT_IRON, true, true, true),
        CAST_IRON(-6776681, Rarity.COMMON, true, false, false),
        PIG_IRON(-9807524, Rarity.COMMON, false, false, false),
        STEEL(-10526881, Rarity.UNCOMMON, Tier.TIER_IV, TFCTiers.STEEL, TFCArmorMaterials.STEEL, true, true, true),
        BLACK_STEEL(-15658735, Rarity.RARE, Tier.TIER_V, TFCTiers.BLACK_STEEL, TFCArmorMaterials.BLACK_STEEL, true, true, true),
        BLUE_STEEL(-13806186, Rarity.EPIC, Tier.TIER_VI, TFCTiers.BLUE_STEEL, TFCArmorMaterials.BLUE_STEEL, true, true, true),
        RED_STEEL(-9435901, Rarity.EPIC, Tier.TIER_VI, TFCTiers.RED_STEEL, TFCArmorMaterials.RED_STEEL, true, true, true),
        WEAK_STEEL(-15658735, Rarity.COMMON, false, false, false),
        WEAK_BLUE_STEEL(-13806186, Rarity.COMMON, false, false, false),
        WEAK_RED_STEEL(-9435901, Rarity.COMMON, false, false, false),
        HIGH_CARBON_STEEL(-10526881, Rarity.COMMON, false, false, false),
        HIGH_CARBON_BLACK_STEEL(-15658735, Rarity.COMMON, false, false, false),
        HIGH_CARBON_BLUE_STEEL(-13806186, Rarity.COMMON, false, false, false),
        HIGH_CARBON_RED_STEEL(-9435901, Rarity.COMMON, false, false, false),
        UNKNOWN(-13685977, Rarity.COMMON, false, false, false);

        private final String serializedName = this.name().toLowerCase(Locale.ROOT);
        private final boolean parts;
        private final boolean armor;
        private final boolean utility;
        private final Tier metalTier;
        @Nullable
        private final net.minecraft.world.item.Tier toolTier;
        @Nullable
        private final ArmorMaterial armorTier;
        private final Rarity rarity;
        private final int color;

        private Default(int color, Rarity rarity, boolean parts, boolean armor, boolean utility) {
            this(color, rarity, Tier.TIER_0, null, null, parts, armor, utility);
        }

        private Default(int color, @Nullable Rarity rarity, @Nullable Tier metalTier, net.minecraft.world.item.Tier toolTier, ArmorMaterial armorTier, boolean parts, boolean armor, boolean utility) {
            this.metalTier = metalTier;
            this.toolTier = toolTier;
            this.armorTier = armorTier;
            this.rarity = rarity;
            this.color = color;
            this.parts = parts;
            this.armor = armor;
            this.utility = utility;
        }

        public String m_7912_() {
            return this.serializedName;
        }

        public int getColor() {
            return this.color;
        }

        public Rarity getRarity() {
            return this.rarity;
        }

        public boolean hasParts() {
            return this.parts;
        }

        public boolean hasArmor() {
            return this.armor;
        }

        public boolean hasTools() {
            return this.toolTier != null;
        }

        public boolean hasUtilities() {
            return this.utility;
        }

        @Override
        public net.minecraft.world.item.Tier toolTier() {
            return Objects.requireNonNull(this.toolTier, "Tried to get non-existent tier from " + this.name());
        }

        @Override
        public ArmorMaterial armorTier() {
            return Objects.requireNonNull(this.armorTier, "Tried to get non-existent armor tier from " + this.name());
        }

        @Override
        public Tier metalTier() {
            return this.metalTier;
        }
    }

    public static enum Tier {
        TIER_0,
        TIER_I,
        TIER_II,
        TIER_III,
        TIER_IV,
        TIER_V,
        TIER_VI;

        private static final Tier[] VALUES;
        private final String translationKey = Helpers.getEnumTranslationKey(this);

        public static Tier valueOf(int tier) {
            return tier < 0 || tier > VALUES.length ? TIER_I : VALUES[tier];
        }

        public Tier next() {
            return this == TIER_VI ? TIER_VI : VALUES[this.ordinal() + 1];
        }

        public Tier previous() {
            return this == TIER_0 ? TIER_0 : VALUES[this.ordinal() - 1];
        }

        public Component getDisplayName() {
            return Helpers.translatable(this.translationKey);
        }

        static {
            VALUES = Tier.values();
        }
    }
}

