/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import com.google.common.collect.Iterators;
import com.mojang.logging.LogUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.common.TFCEffects;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.capabilities.size.IItemSize;
import net.dries007.tfc.common.capabilities.size.ItemSizeManager;
import net.dries007.tfc.common.capabilities.size.Size;
import net.dries007.tfc.common.capabilities.size.Weight;
import net.dries007.tfc.common.entities.GenderedRenderAnimal;
import net.dries007.tfc.common.entities.ai.prey.PestAi;
import net.dries007.tfc.common.entities.prey.Pest;
import net.dries007.tfc.common.items.TFCShieldItem;
import net.dries007.tfc.mixin.accessor.RecipeManagerAccessor;
import net.dries007.tfc.util.Metal;
import net.dries007.tfc.util.Tooltips;
import net.dries007.tfc.world.feature.MultipleFeature;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleRandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class Helpers {
    public static final Direction[] DIRECTIONS = Direction.values();
    public static final Direction[] DIRECTIONS_NOT_DOWN = (Direction[])Arrays.stream(DIRECTIONS).filter(d -> d != Direction.DOWN).toArray(Direction[]::new);
    public static final DyeColor[] DYE_COLORS = DyeColor.values();
    public static final boolean ASSERTIONS_ENABLED = Helpers.detectAssertionsEnabled();
    public static final boolean BOOTSTRAP_ENVIRONMENT = Helpers.detectBootstrapEnvironment();
    public static final boolean TEST_ENVIRONMENT = Helpers.detectTestSourcesPresent();
    public static final String BLOCK_ENTITY_TAG = "BlockEntityTag";
    public static final String BLOCK_STATE_TAG = "BlockStateTag";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int PRIME_X = 501125321;
    private static final int PRIME_Y = 1136930381;
    @Nullable
    private static RecipeManager CACHED_RECIPE_MANAGER = null;

    public static ResourceLocation identifier(String name) {
        return new ResourceLocation("tfc", name);
    }

    public static <T> Capability<T> capability(CapabilityToken<T> token) {
        return BOOTSTRAP_ENVIRONMENT ? null : CapabilityManager.get(token);
    }

    @Nullable
    public static <T> T getCapability(ICapabilityProvider provider, Capability<T> capability) {
        return (T)provider.getCapability(capability).orElse(null);
    }

    public static <T> boolean mightHaveCapability(ItemStack stack, Capability<T> capability) {
        return Helpers.copyWithSize(stack, 1).getCapability(capability).isPresent();
    }

    public static <T1, T2> boolean mightHaveCapability(ItemStack stack, Capability<T1> first, Capability<T2> second) {
        ItemStack copy = Helpers.copyWithSize(stack, 1);
        return copy.getCapability(first).isPresent() && copy.getCapability(second).isPresent();
    }

    public static <E extends Enum<E>, V> EnumMap<E, V> mapOfKeys(Class<E> enumClass, Function<E, V> valueMapper) {
        return Helpers.mapOfKeys(enumClass, key -> true, valueMapper);
    }

    public static <E extends Enum<E>, V> EnumMap<E, V> mapOfKeys(Class<E> enumClass, Predicate<E> keyPredicate, Function<E, V> valueMapper) {
        return Arrays.stream((Enum[])enumClass.getEnumConstants()).filter(keyPredicate).collect(Collectors.toMap(Function.identity(), valueMapper, (v, v2) -> v, () -> new EnumMap(enumClass)));
    }

    public static <K, V> V getRandomValue(Map<K, V> map, Random random) {
        return (V)Iterators.get(map.values().iterator(), (int)random.nextInt(map.size()));
    }

    public static <R> Stream<? extends R> flatten(Object t) {
        Stream<Object> stream;
        if (t instanceof Collection) {
            Collection c = (Collection)t;
            stream = c.stream();
        } else {
            Stream<Object> s;
            stream = t instanceof Stream ? (s = (Stream<Object>)t) : Stream.of(t);
        }
        return stream;
    }

    public static TranslatableComponent translateEnum(Enum<?> anEnum) {
        return Helpers.translatable(Helpers.getEnumTranslationKey(anEnum));
    }

    public static String getEnumTranslationKey(Enum<?> anEnum) {
        return Helpers.getEnumTranslationKey(anEnum, anEnum.getDeclaringClass().getSimpleName());
    }

    public static TranslatableComponent translatable(String key) {
        return new TranslatableComponent(key);
    }

    public static TranslatableComponent translatable(String key, Object ... args) {
        return new TranslatableComponent(key, args);
    }

    public static TextComponent literal(String literalText) {
        return new TextComponent(literalText);
    }

    public static String getEnumTranslationKey(Enum<?> anEnum, String enumName) {
        return String.join((CharSequence)".", "tfc", "enum", enumName, anEnum.name()).toLowerCase(Locale.ROOT);
    }

    public static boolean isClientSide(LevelReader world) {
        return world instanceof Level ? !(world instanceof ServerLevel) : world.m_5776_();
    }

    @Nullable
    public static Level getUnsafeLevel(Object maybeLevel) {
        if (maybeLevel instanceof Level) {
            Level level = (Level)maybeLevel;
            return level;
        }
        if (maybeLevel instanceof WorldGenRegion) {
            WorldGenRegion level = (WorldGenRegion)maybeLevel;
            return level.m_6018_();
        }
        return null;
    }

    public static BlockHitResult rayTracePlayer(Level level, Player player, ClipContext.Fluid mode) {
        return ItemProtectedAccessor.invokeGetPlayerPOVHitResult(level, player, mode);
    }

    public static void slowEntityInBlock(Entity entity, float factor, int fallDamageReduction) {
        Vec3 motion = entity.m_20184_();
        entity.m_20256_(motion.m_82542_((double)factor, motion.f_82480_ < 0.0 ? (double)(1.0f - 0.2f * (1.0f - factor)) : 1.0, (double)factor));
        if (entity.f_19789_ > (float)fallDamageReduction) {
            entity.m_142535_(entity.f_19789_ - (float)fallDamageReduction, 1.0f, DamageSource.f_19315_);
        }
        entity.f_19789_ = 0.0f;
    }

    public static void rotateEntity(Level level, Entity entity, Vec3 origin, float speed) {
        if (!entity.m_20096_() || entity.m_20184_().f_82480_ > 0.0 || speed == 0.0f) {
            return;
        }
        float rot = (entity.m_6080_() + speed) % 360.0f;
        entity.m_146922_(rot);
        if (level.f_46443_ && entity instanceof Player) {
            Vec3 offset = entity.m_20182_().m_82546_(origin).m_82541_();
            Vec3 movement = new Vec3(-offset.f_82481_, 0.0, offset.f_82479_).m_82490_((double)(speed / 48.0f));
            entity.m_20256_(entity.m_20184_().m_82549_(movement));
            entity.f_19864_ = true;
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            entity.m_5616_(rot);
            entity.m_5618_(rot);
            entity.m_6853_(false);
            living.m_21310_(20);
            living.f_19864_ = true;
        }
    }

    public static BlockState copyProperties(BlockState copyTo, BlockState copyFrom) {
        for (Property property : copyFrom.m_61147_()) {
            copyTo = Helpers.copyProperty(copyTo, copyFrom, property);
        }
        return copyTo;
    }

    public static <T extends Comparable<T>> BlockState copyProperty(BlockState copyTo, BlockState copyFrom, Property<T> property) {
        return copyTo.m_61138_(property) ? (BlockState)copyTo.m_61124_(property, copyFrom.m_61143_(property)) : copyTo;
    }

    public static <T extends Comparable<T>> BlockState setProperty(BlockState state, Property<T> property, T value) {
        return state.m_61138_(property) ? (BlockState)state.m_61124_(property, value) : state;
    }

    public static <C extends Container, R extends Recipe<C>> Map<ResourceLocation, R> getRecipes(Level level, Supplier<RecipeType<R>> type) {
        return Helpers.getRecipes(level.m_7465_(), type);
    }

    public static <C extends Container, R extends Recipe<C>> Map<ResourceLocation, R> getRecipes(RecipeManager recipeManager, Supplier<RecipeType<R>> type) {
        return ((RecipeManagerAccessor)recipeManager).invoke$byType(type.get());
    }

    public static RecipeManager getUnsafeRecipeManager() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            return server.m_129894_();
        }
        try {
            Level level = ClientHelpers.getLevel();
            if (level != null) {
                return level.m_7465_();
            }
        }
        catch (Throwable t) {
            LOGGER.info("^ This is fine - No client or server recipe manager present upon initial resource reload on physical server");
        }
        if (CACHED_RECIPE_MANAGER != null) {
            LOGGER.info("Successfully captured server recipe manager");
            return CACHED_RECIPE_MANAGER;
        }
        throw new IllegalStateException("No recipe manager was present - tried server, client, and captured value. This will cause problems!");
    }

    public static void setCachedRecipeManager(RecipeManager manager) {
        CACHED_RECIPE_MANAGER = manager;
    }

    public static ItemStack damageCraftingItem(ItemStack stack, int amount) {
        Player player = ForgeHooks.getCraftingPlayer();
        if (player != null) {
            stack.m_41622_(amount, (LivingEntity)player, entity -> {});
        } else {
            Helpers.damageItem(stack, amount);
        }
        return stack;
    }

    public static void damageItem(ItemStack stack, int amount) {
        if (stack.m_41629_(amount, new Random(), null)) {
            stack.m_41774_(1);
            stack.m_41721_(0);
        }
    }

    public static void removeBlock(LevelAccessor level, BlockPos pos, int flags) {
        level.m_7731_(pos, level.m_6425_(pos).m_76188_(), flags);
    }

    public static ItemStack copyWithSize(ItemStack stack, int size) {
        ItemStack copy = stack.m_41777_();
        copy.m_41764_(size);
        return copy;
    }

    public static Iterable<ItemStack> iterate(IItemHandler inventory) {
        return Helpers.iterate(inventory, 0, inventory.getSlots());
    }

    public static void tickInfestation(Level level, BlockPos pos, int infestation, @Nullable Player player) {
        if ((infestation = Mth.m_14045_((int)infestation, (int)0, (int)5)) == 0) {
            return;
        }
        if (level.f_46441_.nextInt(120 - 20 * infestation) == 0) {
            float chanceBasedOnCurrentPests = 1.0f - Mth.m_184631_((float)level.m_45976_(Pest.class, new AABB(pos).m_82400_(40.0)).size(), (float)0.0f, (float)8.0f, (float)0.0f, (float)1.0f);
            if (level.f_46441_.nextFloat() > chanceBasedOnCurrentPests) {
                return;
            }
            Helpers.getRandomElement(ForgeRegistries.ENTITIES, TFCTags.Entities.PESTS, level.f_46441_).ifPresent(type -> {
                Entity entity = type.m_20615_(level);
                if (entity instanceof PathfinderMob) {
                    PathfinderMob mob = (PathfinderMob)entity;
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        mob.m_20219_(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()));
                        Vec3 checkPos = LandRandomPos.m_148488_((PathfinderMob)mob, (int)15, (int)5);
                        if (checkPos != null) {
                            mob.m_20219_(checkPos);
                            mob.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(new BlockPos(checkPos)), MobSpawnType.EVENT, null, null);
                            serverLevel.m_7967_((Entity)mob);
                            if (mob instanceof Pest) {
                                Pest pest = (Pest)mob;
                                PestAi.setSmelledPos(pest, pos);
                            }
                            if (player != null) {
                                player.m_5661_((Component)Helpers.translatable("tfc.tooltip.infestation"), true);
                            }
                        }
                    }
                }
            });
        }
    }

    public static int countOverburdened(Container container) {
        int count = 0;
        for (int i = 0; i < container.m_6643_(); ++i) {
            IItemSize size;
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_() || (size = ItemSizeManager.get(stack)).getWeight(stack) != Weight.VERY_HEAVY || size.getSize(stack) != Size.HUGE || ++count != 2) continue;
            return count;
        }
        return count;
    }

    public static MobEffectInstance getOverburdened(boolean visible) {
        return new MobEffectInstance((MobEffect)TFCEffects.OVERBURDENED.get(), 25, 0, false, visible);
    }

    public static MobEffectInstance getExhausted(boolean visible) {
        return new MobEffectInstance((MobEffect)TFCEffects.EXHAUSTED.get(), 25, 0, false, visible);
    }

    public static Iterable<ItemStack> iterate(final IItemHandler inventory, final int startSlotInclusive, final int endSlotExclusive) {
        return () -> new Iterator<ItemStack>(){
            private int slot;
            {
                this.slot = startSlotInclusive;
            }

            @Override
            public boolean hasNext() {
                return this.slot < endSlotExclusive;
            }

            @Override
            public ItemStack next() {
                return inventory.getStackInSlot(this.slot++);
            }

            @Override
            public void remove() {
                Helpers.removeStack(inventory, this.slot - 1);
            }
        };
    }

    public static ListTag writeItemStacksToNbt(List<ItemStack> stacks) {
        ListTag list = new ListTag();
        for (ItemStack stack : stacks) {
            list.add((Object)stack.m_41739_(new CompoundTag()));
        }
        return list;
    }

    public static ListTag writeItemStacksToNbt(@Nullable ItemStack[] stacks) {
        ListTag list = new ListTag();
        for (ItemStack stack : stacks) {
            list.add((Object)(stack == null ? ItemStack.f_41583_ : stack).m_41739_(new CompoundTag()));
        }
        return list;
    }

    public static void readItemStacksFromNbt(List<ItemStack> stacks, ListTag list) {
        stacks.clear();
        for (int i = 0; i < list.size(); ++i) {
            stacks.add(ItemStack.m_41712_((CompoundTag)list.m_128728_(i)));
        }
    }

    public static void readItemStacksFromNbt(ItemStack[] stacks, ListTag list) {
        assert (list.size() == stacks.length);
        for (int i = 0; i < list.size(); ++i) {
            stacks[i] = ItemStack.m_41712_((CompoundTag)list.m_128728_(i));
        }
    }

    public static void consumeInStackSizeIncrements(ItemStack stack, int totalCount, Consumer<ItemStack> consumer) {
        while (totalCount > 0) {
            ItemStack splitStack = stack.m_41777_();
            int splitCount = Math.min(splitStack.m_41741_(), totalCount);
            splitStack.m_41764_(splitCount);
            totalCount -= splitCount;
            consumer.accept(splitStack);
        }
    }

    public static void gatherAndConsumeItems(Level level, AABB bounds, IItemHandler inventory, int minSlotInclusive, int maxSlotInclusive) {
        Helpers.gatherAndConsumeItems(level.m_6443_(ItemEntity.class, bounds, EntitySelector.f_20402_), inventory, minSlotInclusive, maxSlotInclusive);
    }

    public static void gatherAndConsumeItems(Level level, AABB bounds, IItemHandler inventory, int minSlotInclusive, int maxSlotInclusive, int maxItemsOverride) {
        Helpers.gatherAndConsumeItems(level.m_6443_(ItemEntity.class, bounds, EntitySelector.f_20402_), inventory, minSlotInclusive, maxSlotInclusive, maxItemsOverride);
    }

    public static void gatherAndConsumeItems(Collection<ItemEntity> items, IItemHandler inventory, int minSlotInclusive, int maxSlotInclusive) {
        Helpers.gatherAndConsumeItems(items, inventory, minSlotInclusive, maxSlotInclusive, Integer.MAX_VALUE);
    }

    public static void gatherAndConsumeItems(Collection<ItemEntity> items, IItemHandler inventory, int minSlotInclusive, int maxSlotInclusive, int maxItemsOverride) {
        ArrayList<ItemEntity> availableItemEntities = new ArrayList<ItemEntity>();
        int availableItems = 0;
        for (ItemEntity entity : items) {
            if (!inventory.isItemValid(maxSlotInclusive, entity.m_32055_())) continue;
            availableItems += entity.m_32055_().m_41613_();
            availableItemEntities.add(entity);
        }
        if (availableItems > maxItemsOverride) {
            availableItems = maxItemsOverride;
        }
        Helpers.safelyConsumeItemsFromEntitiesIndividually(availableItemEntities, availableItems, item -> Helpers.insertSlots(inventory, item, minSlotInclusive, 1 + maxSlotInclusive).m_41619_());
    }

    public static void consumeItemsFromEntitiesIndividually(Collection<ItemEntity> entities, int maximum, Consumer<ItemStack> consumer) {
        int consumed = 0;
        for (ItemEntity entity : entities) {
            ItemStack stack = entity.m_32055_();
            while (consumed < maximum && !stack.m_41619_()) {
                consumer.accept(stack.m_41620_(1));
                ++consumed;
                if (!stack.m_41619_()) continue;
                entity.m_146870_();
            }
        }
    }

    public static void safelyConsumeItemsFromEntitiesIndividually(Collection<ItemEntity> entities, int maximum, Predicate<ItemStack> consumer) {
        int consumed = 0;
        for (ItemEntity entity : entities) {
            ItemStack stack = entity.m_32055_();
            while (consumed < maximum && !stack.m_41619_()) {
                ItemStack offer = Helpers.copyWithSize(stack, 1);
                if (!consumer.test(offer)) {
                    return;
                }
                ++consumed;
                stack.m_41774_(1);
                if (!stack.m_41619_()) continue;
                entity.m_146870_();
            }
        }
    }

    public static ItemStack removeStack(IItemHandler inventory, int slot) {
        return inventory.extractItem(slot, Integer.MAX_VALUE, false);
    }

    public static ItemStack mergeInsertStack(IItemHandler inventory, int slot, ItemStack stack) {
        ItemStack existing = Helpers.removeStack(inventory, slot);
        ItemStack remainder = stack.m_41777_();
        ItemStack merged = FoodCapability.mergeItemStacks(existing, remainder);
        inventory.insertItem(slot, merged, false);
        return remainder;
    }

    public static ItemStack insertAllSlots(IItemHandler inventory, ItemStack stack) {
        return Helpers.insertSlots(inventory, stack, 0, inventory.getSlots());
    }

    public static ItemStack insertSlots(IItemHandler inventory, ItemStack stack, int slotStartInclusive, int slotEndExclusive) {
        for (int slot = slotStartInclusive; slot < slotEndExclusive; ++slot) {
            if (!(stack = inventory.insertItem(slot, stack, false)).m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return stack;
    }

    public static boolean insertOne(Level level, BlockPos pos, BlockEntityType<? extends BlockEntity> type, ItemStack stack) {
        return Helpers.insertOne(level.m_141902_(pos, type), stack);
    }

    public static boolean insertOne(Optional<? extends BlockEntity> blockEntity, ItemStack stack) {
        ItemStack toInsert = stack.m_41777_();
        return blockEntity.flatMap(entity -> entity.getCapability(Capabilities.ITEM).resolve()).map(cap -> {
            toInsert.m_41764_(1);
            return Helpers.insertAllSlots(cap, toInsert).m_41619_();
        }).orElse(false);
    }

    public static NonNullList<ItemStack> extractAllItems(IItemHandlerModifiable inventory) {
        NonNullList saved = NonNullList.m_122780_((int)inventory.getSlots(), (Object)ItemStack.f_41583_);
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            saved.set(slot, (Object)inventory.getStackInSlot(slot).m_41777_());
            inventory.setStackInSlot(slot, ItemStack.f_41583_);
        }
        return saved;
    }

    public static void insertAllItems(IItemHandlerModifiable inventory, NonNullList<ItemStack> from) {
        for (int slot = 0; slot < Math.min(inventory.getSlots(), from.size()); ++slot) {
            inventory.setStackInSlot(slot, (ItemStack)from.get(slot));
        }
    }

    public static boolean isEmpty(IItemHandler inventory) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            if (inventory.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public static void fireSpreaderTick(ServerLevel level, BlockPos pos, Random random, int radius) {
        if (level.m_46469_().m_46207_(GameRules.f_46131_)) {
            int x = pos.m_123341_();
            int y = pos.m_123342_();
            int z = pos.m_123343_();
            int radiusSquared = radius * radius;
            for (BlockPos checkPos : BlockPos.m_121957_((Random)random, (int)(radius * 2), (int)(x - radius), (int)y, (int)(z - radius), (int)(x + radius), (int)(y + radius), (int)(z + radius))) {
                BlockState state;
                if (!(checkPos.m_123331_((Vec3i)pos) < (double)radiusSquared) || !level.m_46749_(checkPos) || !(state = level.m_8055_(checkPos)).m_60795_() || !Helpers.hasFlammableNeighbours((LevelReader)level, checkPos)) continue;
                level.m_46597_(checkPos, Blocks.f_50083_.m_49966_());
                return;
            }
        }
    }

    private static boolean hasFlammableNeighbours(LevelReader level, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (Direction direction : DIRECTIONS) {
            mutable.m_122159_((Vec3i)pos, direction);
            if (!level.m_8055_((BlockPos)mutable).isFlammable((BlockGetter)level, (BlockPos)mutable, direction.m_122424_())) continue;
            return true;
        }
        return false;
    }

    public static void destroyBlockAndDropBlocksManually(ServerLevel level, BlockPos pos, Consumer<LootContext.Builder> builder) {
        BlockState state = level.m_8055_(pos);
        if (!state.m_60795_()) {
            FluidState fluidstate = level.m_6425_(pos);
            if (!(state.m_60734_() instanceof BaseFireBlock)) {
                level.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
            }
            Helpers.dropWithContext(level, state, pos, builder, true);
            level.m_6933_(pos, fluidstate.m_76188_(), 3, 512);
        }
    }

    public static void dropWithContext(ServerLevel level, BlockState state, BlockPos pos, Consumer<LootContext.Builder> builder, boolean randomized) {
        BlockEntity tileEntity = state.m_155947_() ? level.m_7702_(pos) : null;
        LootContext.Builder lootContext = new LootContext.Builder(level).m_78977_(level.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_78972_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_78984_(LootContextParams.f_81455_, null).m_78984_(LootContextParams.f_81462_, (Object)tileEntity);
        builder.accept(lootContext);
        state.m_60724_(lootContext).forEach(stackToSpawn -> {
            if (randomized) {
                Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stackToSpawn);
            } else {
                Helpers.spawnDropsAtExactCenter((Level)level, pos, stackToSpawn);
            }
        });
        state.m_60612_(level, pos, ItemStack.f_41583_);
    }

    public static void spawnDropsAtExactCenter(Level level, BlockPos pos, ItemStack stack) {
        if (!level.f_46443_ && !stack.m_41619_() && level.m_46469_().m_46207_(GameRules.f_46136_) && !level.restoringBlockSnapshots) {
            ItemEntity entity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stack, 0.0, 0.0, 0.0);
            entity.m_32060_();
            level.m_7967_((Entity)entity);
        }
    }

    public static void playSound(Level level, BlockPos pos, SoundEvent sound) {
        Random rand = level.m_5822_();
        level.m_5594_(null, pos, sound, SoundSource.BLOCKS, 1.0f + rand.nextFloat(), rand.nextFloat() + 0.7f + 0.3f);
    }

    public static void playPlaceSound(Level level, BlockPos pos, BlockState state) {
        Helpers.playPlaceSound(level, pos, state.getSoundType((LevelReader)level, pos, null));
    }

    public static void playPlaceSound(Level level, BlockPos pos, SoundType st) {
        level.m_5594_(null, pos, st.m_56777_(), SoundSource.BLOCKS, (st.m_56773_() + 1.0f) / 2.0f, st.m_56774_() * 0.8f);
    }

    public static boolean spawnItem(Level level, Vec3 pos, ItemStack stack) {
        return level.m_7967_((Entity)new ItemEntity(level, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), stack));
    }

    public static boolean spawnItem(Level level, BlockPos pos, ItemStack stack, double yOffset) {
        return level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + yOffset, (double)pos.m_123343_() + 0.5, stack));
    }

    public static boolean spawnItem(Level level, BlockPos pos, ItemStack stack) {
        return Helpers.spawnItem(level, pos, stack, 0.5);
    }

    public static FluidStack mergeOutputFluidIntoSlot(IItemHandlerModifiable inventory, FluidStack fluidStack, float temperature, int slot) {
        if (!fluidStack.isEmpty()) {
            ItemStack mergeStack = inventory.getStackInSlot(slot);
            return mergeStack.getCapability(Capabilities.FLUID).map(fluidCap -> {
                int filled = fluidCap.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                if (filled > 0) {
                    Metal metal = Objects.requireNonNullElse(Metal.get(fluidStack.getFluid()), Metal.unknown());
                    float heatCapacity = metal.getHeatCapacity(filled);
                    mergeStack.getCapability(HeatCapability.CAPABILITY).ifPresent(heatCap -> heatCap.addTemperatureFromSourceWithHeatCapacity(temperature, heatCapacity));
                }
                FluidStack remainder = fluidStack.copy();
                remainder.shrink(filled);
                return remainder;
            }).orElse(fluidStack);
        }
        return FluidStack.EMPTY;
    }

    public static <E> void encodeArray(FriendlyByteBuf buffer, E[] array, BiConsumer<E, FriendlyByteBuf> encoder) {
        buffer.m_130130_(array.length);
        for (E e : array) {
            encoder.accept(e, buffer);
        }
    }

    public static <E> E[] decodeArray(FriendlyByteBuf buffer, IntFunction<E[]> arrayCtor, Function<FriendlyByteBuf, E> decoder) {
        int size = buffer.m_130242_();
        E[] array = arrayCtor.apply(size);
        for (int i = 0; i < size; ++i) {
            array[i] = decoder.apply(buffer);
        }
        return array;
    }

    public static <E, C extends Collection<E>> C decodeAll(FriendlyByteBuf buffer, C collection, Function<FriendlyByteBuf, E> decoder) {
        int size = buffer.m_130242_();
        for (int i = 0; i < size; ++i) {
            collection.add(decoder.apply(buffer));
        }
        return collection;
    }

    public static <E, C extends Collection<E>> void encodeAll(FriendlyByteBuf buffer, C collection, BiConsumer<E, FriendlyByteBuf> encoder) {
        buffer.m_130130_(collection.size());
        for (E e : collection) {
            encoder.accept(e, buffer);
        }
    }

    public static <T> void encodeNullable(@Nullable T instance, FriendlyByteBuf buffer, BiConsumer<T, FriendlyByteBuf> encoder) {
        if (instance != null) {
            buffer.writeBoolean(true);
            encoder.accept(instance, buffer);
        } else {
            buffer.writeBoolean(false);
        }
    }

    @Nullable
    public static <T> T decodeNullable(FriendlyByteBuf buffer, Function<FriendlyByteBuf, T> decoder) {
        if (buffer.readBoolean()) {
            return decoder.apply(buffer);
        }
        return null;
    }

    public static BlockPos quartToBlock(int x, int y, int z) {
        return new BlockPos(x << 2, y << 2, z << 2);
    }

    public static VoxelShape rotateShape(Direction direction, double x1, double y1, double z1, double x2, double y2, double z2) {
        return switch (direction) {
            case Direction.NORTH -> Block.m_49796_((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
            case Direction.EAST -> Block.m_49796_((double)(16.0 - z2), (double)y1, (double)x1, (double)(16.0 - z1), (double)y2, (double)x2);
            case Direction.SOUTH -> Block.m_49796_((double)(16.0 - x2), (double)y1, (double)(16.0 - z2), (double)(16.0 - x1), (double)y2, (double)(16.0 - z1));
            case Direction.WEST -> Block.m_49796_((double)z1, (double)y1, (double)(16.0 - x2), (double)z2, (double)y2, (double)(16.0 - x1));
            default -> throw new IllegalArgumentException("Not horizontal!");
        };
    }

    public static VoxelShape[] computeHorizontalShapes(Function<Direction, VoxelShape> shapeGetter) {
        return new VoxelShape[]{shapeGetter.apply(Direction.SOUTH), shapeGetter.apply(Direction.WEST), shapeGetter.apply(Direction.NORTH), shapeGetter.apply(Direction.EAST)};
    }

    public static <T> List<T> uniqueRandomSample(List<T> list, int n, Random r) {
        int length = list.size();
        if (length < n) {
            throw new IllegalArgumentException("Cannot select n=" + n + " from a list of size = " + length);
        }
        for (int i = length - 1; i >= length - n; --i) {
            Collections.swap(list, i, r.nextInt(i + 1));
        }
        return list.subList(length - n, length);
    }

    public static <T> void insertBefore(List<? super T> list, T element, T before) {
        int index = list.indexOf(before);
        if (index == -1) {
            list.add(element);
        } else {
            list.add(index, element);
        }
    }

    public static <T extends IForgeRegistryEntry<T>> List<T> getAllTagValues(TagKey<T> tag, IForgeRegistry<T> registry) {
        return Helpers.streamAllTagValues(tag, registry).toList();
    }

    public static <T extends IForgeRegistryEntry<T>> Stream<T> streamAllTagValues(TagKey<T> tag, IForgeRegistry<T> registry) {
        return Objects.requireNonNull(registry.tags()).getTag(tag).stream();
    }

    public static <T> T uncheck(Callable<?> action) {
        try {
            return (T)action.call();
        }
        catch (Exception e) {
            return Helpers.throwAsUnchecked(e);
        }
    }

    public static void warnWhenCalledFromClientThread() {
        if (ASSERTIONS_ENABLED && EffectiveSide.get().isClient()) {
            LOGGER.warn("This method should not be called from client thread, this is a bug!", (Throwable)new RuntimeException("Stacktrace"));
        }
    }

    public static float lerp(float delta, float min, float max) {
        return min + (max - min) * delta;
    }

    public static float lerp4(float value00, float value01, float value10, float value11, float delta0, float delta1) {
        float value0 = Helpers.lerp(delta1, value00, value01);
        float value1 = Helpers.lerp(delta1, value10, value11);
        return Helpers.lerp(delta0, value0, value1);
    }

    public static float inverseLerp(float value, float min, float max) {
        return (value - min) / (max - min);
    }

    public static int hash(long salt, BlockPos pos) {
        return Helpers.hash(salt, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public static int hash(long salt, int x, int y, int z) {
        long hash = salt ^ (long)x * 501125321L ^ (long)y * 1136930381L ^ (long)z;
        return (int)(hash *= 668265261L);
    }

    public static RandomSource fork(Random random) {
        return new XoroshiroRandomSource(random.nextLong(), random.nextLong());
    }

    public static float catMullRomSpline(float lerp, float lowAnchor, float start, float end, float endAnchor) {
        return 0.5f * (2.0f * start + (end - lowAnchor) * lerp + (2.0f * lowAnchor - 5.0f * start + 4.0f * end - endAnchor) * lerp * lerp + (3.0f * start - lowAnchor - 3.0f * end + endAnchor) * lerp * lerp * lerp);
    }

    public static float triangle(float amplitude, float midpoint, float frequency, float value) {
        return midpoint + amplitude * (Math.abs(4.0f * frequency * value + 1.0f - 4.0f * (float)Mth.m_14143_((float)(frequency * value + 0.75f))) - 1.0f);
    }

    public static int uniform(RandomSource random, int min, int max) {
        return min == max ? min : min + random.nextInt(max - min);
    }

    public static int uniform(Random random, int min, int max) {
        return min == max ? min : min + random.nextInt(max - min);
    }

    public static float uniform(RandomSource random, float min, float max) {
        return random.nextFloat() * (max - min) + min;
    }

    public static float uniform(Random random, float min, float max) {
        return random.nextFloat() * (max - min) + min;
    }

    public static float triangle(Random random) {
        return random.nextFloat() - random.nextFloat() * 0.5f;
    }

    public static int triangle(Random random, int range) {
        return random.nextInt(range) - random.nextInt(range);
    }

    public static float triangle(RandomSource random, float delta) {
        return (random.nextFloat() - random.nextFloat()) * delta;
    }

    public static float easeInOutCubic(float x) {
        return x < 0.5f ? 4.0f * x * x * x : 1.0f - Helpers.cube(-2.0f * x + 2.0f) / 2.0f;
    }

    public static float cube(float x) {
        return x * x * x;
    }

    public static int ceilDiv(int num, int div) {
        return (num + div - 1) / div;
    }

    public static void openScreen(ServerPlayer player, MenuProvider containerSupplier) {
        NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)containerSupplier);
    }

    public static void openScreen(ServerPlayer player, MenuProvider containerSupplier, BlockPos pos) {
        NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)containerSupplier, (BlockPos)pos);
    }

    public static void openScreen(ServerPlayer player, MenuProvider containerSupplier, Consumer<FriendlyByteBuf> extraDataWriter) {
        NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)containerSupplier, extraDataWriter);
    }

    public static void maybeDisableShield(ItemStack axe, ItemStack shield, Player player, LivingEntity attacker) {
        if (!axe.m_41619_() && !shield.m_41619_() && axe.canDisableShield(shield, (LivingEntity)player, attacker)) {
            float vanillaDisableChance;
            float chanceToDisable = vanillaDisableChance = 0.25f + (float)EnchantmentHelper.m_44926_((LivingEntity)attacker) * 0.05f;
            Item shieldItem = shield.m_41720_();
            if (shieldItem.equals(Items.f_42740_)) {
                chanceToDisable = 1.0f;
            } else if (shieldItem instanceof TFCShieldItem) {
                TFCShieldItem tfcShield = (TFCShieldItem)shieldItem;
                chanceToDisable = 0.25f * vanillaDisableChance + 0.75f * tfcShield.getDisableChance();
            }
            if (attacker.m_21187_().nextFloat() < chanceToDisable) {
                player.m_36335_().m_41524_(shieldItem, 100);
                attacker.f_19853_.m_7605_((Entity)player, (byte)30);
            }
        }
    }

    public static <T> boolean perfectMatchExists(List<T> inputs, List<? extends Predicate<T>> tests) {
        if (inputs.size() != tests.size()) {
            return false;
        }
        int size = inputs.size();
        boolean[][] matrices = new boolean[size][];
        for (int i = 0; i < size; ++i) {
            matrices[i] = new boolean[(size + 1) * (size + 1)];
        }
        boolean[] matrix = matrices[size - 1];
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                matrix[i + size * j] = tests.get(i).test(inputs.get(j));
            }
        }
        return Helpers.perfectMatchDet(matrices, size);
    }

    public static void addInventoryTooltipInfo(IItemHandler inventory, List<Component> tooltips) {
        int maximumItems = 0;
        int totalItems = 0;
        for (ItemStack stack : Helpers.iterate(inventory)) {
            if (stack.m_41619_()) continue;
            ++totalItems;
            if (maximumItems > 4) continue;
            ++maximumItems;
            tooltips.add((Component)stack.m_41786_().m_6881_().m_130946_(" x").m_130946_(String.valueOf(stack.m_41613_())));
        }
        if (totalItems - maximumItems > 0) {
            tooltips.add((Component)Helpers.translatable("container.shulkerBox.more", totalItems - maximumItems).m_130940_(ChatFormatting.ITALIC));
        }
    }

    public static Optional<TooltipComponent> getTooltipImage(IItemHandler inventory, int width, int height, int startIndex, int endIndex) {
        NonNullList list = NonNullList.m_122779_();
        boolean empty = true;
        for (int i = startIndex; i <= endIndex; ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (!stack.m_41619_()) {
                empty = false;
            }
            list.add(stack);
        }
        return empty || list.isEmpty() ? Optional.empty() : Optional.of(new Tooltips.DeviceImageTooltip((List<ItemStack>)list, width, height));
    }

    @Deprecated(forRemoval=true)
    public static void addFluidStackTooltipInfo(FluidStack fluid, List<Component> tooltips) {
        if (!fluid.isEmpty()) {
            tooltips.add((Component)Tooltips.fluidUnitsOf(fluid));
        }
    }

    public static boolean isItem(ItemStack first, Item second) {
        return first.m_150930_(second);
    }

    public static boolean isItem(ItemStack stack, TagKey<Item> tag) {
        return Helpers.checkTag(ForgeRegistries.ITEMS, stack.m_41720_(), tag);
    }

    public static boolean isItem(Item item, TagKey<Item> tag) {
        return Helpers.checkTag(ForgeRegistries.ITEMS, item, tag);
    }

    public static boolean isBlock(BlockState first, Block second) {
        return first.m_60713_(second);
    }

    public static boolean isBlock(BlockState state, TagKey<Block> tag) {
        return Helpers.isBlock(state.m_60734_(), tag);
    }

    public static boolean isBlock(Block block, TagKey<Block> tag) {
        return Helpers.checkTag(ForgeRegistries.BLOCKS, block, tag);
    }

    public static boolean isFluid(FluidState state, TagKey<Fluid> tag) {
        return Helpers.checkTag(ForgeRegistries.FLUIDS, state.m_76152_(), tag);
    }

    public static boolean isFluid(Fluid first, TagKey<Fluid> second) {
        return Helpers.checkTag(ForgeRegistries.FLUIDS, first, second);
    }

    public static boolean isFluid(FluidState first, Fluid second) {
        return first.m_192917_(second);
    }

    public static boolean isEntity(Entity entity, TagKey<EntityType<?>> tag) {
        return Helpers.checkTag(ForgeRegistries.ENTITIES, entity.m_6095_(), tag);
    }

    public static boolean isEntity(EntityType<?> entity, TagKey<EntityType<?>> tag) {
        return Helpers.checkTag(ForgeRegistries.ENTITIES, entity, tag);
    }

    public static <T extends IForgeRegistryEntry<T>> Holder<T> getHolder(IForgeRegistry<T> registry, T object) {
        return (Holder)registry.getHolder(object).orElseThrow();
    }

    public static <T extends IForgeRegistryEntry<T>> boolean checkTag(IForgeRegistry<T> registry, T object, TagKey<T> tag) {
        return Objects.requireNonNull(registry.tags()).getTag(tag).contains(object);
    }

    public static <T extends IForgeRegistryEntry<T>> Optional<T> getRandomElement(IForgeRegistry<T> registry, TagKey<T> tag, Random random) {
        return Objects.requireNonNull(registry.tags()).getTag(tag).getRandomElement(random);
    }

    public static double sampleNoiseAndMapToRange(NormalNoise noise, double x, double y, double z, double min, double max) {
        return Mth.m_144914_((double)noise.m_75380_(x, y, z), (double)-1.0, (double)1.0, (double)min, (double)max);
    }

    public static ResourceLocation animalTexture(String name) {
        return Helpers.identifier("textures/entity/animal/" + name + ".png");
    }

    public static <T> ResourceLocation getGenderedTexture(GenderedRenderAnimal animal, String name) {
        ResourceLocation male = Helpers.animalTexture(name + "_male");
        ResourceLocation female = Helpers.animalTexture(name + "_female");
        return animal.displayMaleCharacteristics() ? male : female;
    }

    public static List<HolderSet<PlacedFeature>> flattenTopLevelMultipleFeature(BiomeGenerationSettings settings) {
        return settings.m_47818_().stream().map(set -> HolderSet.m_205800_(set.m_203614_().flatMap(holder -> {
            FeatureConfiguration patt58366$temp;
            ConfiguredFeature feature = (ConfiguredFeature)((PlacedFeature)holder.m_203334_()).f_191775_().m_203334_();
            if (feature.f_65377_() instanceof MultipleFeature && (patt58366$temp = feature.f_65378_()) instanceof SimpleRandomFeatureConfiguration) {
                SimpleRandomFeatureConfiguration features = (SimpleRandomFeatureConfiguration)patt58366$temp;
                return features.f_68090_.m_203614_();
            }
            return Stream.of(holder);
        }).toList())).toList();
    }

    public static void seedLargeFeatures(Random random, long baseSeed, int index, int decoration) {
        random.setSeed(baseSeed);
        long seed = (long)index * random.nextLong() * 203704237L ^ (long)decoration * random.nextLong() * 758031792L ^ baseSeed;
        random.setSeed(seed);
    }

    private static boolean perfectMatchDet(boolean[][] matrices, int size) {
        boolean[] matrix = matrices[size - 1];
        switch (size) {
            case 1: {
                return matrix[0];
            }
            case 2: {
                return matrix[0] && matrix[3] || matrix[1] && matrix[2];
            }
        }
        for (int c = 0; c < size; ++c) {
            if (!matrix[c]) continue;
            Helpers.perfectMatchSub(matrices, size, c);
            if (!Helpers.perfectMatchDet(matrices, size - 1)) continue;
            return true;
        }
        return false;
    }

    private static void perfectMatchSub(boolean[][] matrices, int size, int dc) {
        int subSize = size - 1;
        boolean[] matrix = matrices[subSize];
        boolean[] sub = matrices[subSize - 1];
        for (int c = 0; c < subSize; ++c) {
            int c0 = c + (c >= dc ? 1 : 0);
            for (int r = 0; r < subSize; ++r) {
                sub[c + subSize * r] = matrix[c0 + size * (r + 1)];
            }
        }
    }

    public static void injectZippedDatapack(AddPackFindersEvent event) {
        IModFile modFile = ModList.get().getModFileById("tfc").getFile();
        Path resourcePath = modFile.getFilePath();
        Path dataZip = resourcePath.resolve("data_zipped.zip");
        Path assetZip = resourcePath.resolve("assets_zipped.zip");
        if (!Files.exists(dataZip, new LinkOption[0]) || !Files.exists(assetZip, new LinkOption[0])) {
            LOGGER.error("No override datapack or resource pack found.");
        } else if (event.getPackType() == PackType.SERVER_DATA) {
            LOGGER.info("Injecting TFC override datapack");
            event.addRepositorySource((consumer, constructor) -> consumer.accept(Pack.m_10430_((String)"tfc_data", (boolean)true, () -> new FilePackResources(dataZip.toFile()), (Pack.PackConstructor)constructor, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_)));
        } else {
            LOGGER.info("Injecting TFC override resource pack");
            event.addRepositorySource((consumer, constructor) -> consumer.accept(Pack.m_10430_((String)"tfc_assets", (boolean)true, () -> new FilePackResources(assetZip.toFile()), (Pack.PackConstructor)constructor, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_)));
        }
    }

    public static <E extends Throwable, T> T throwAsUnchecked(Throwable exception) throws E {
        throw exception;
    }

    private static boolean detectAssertionsEnabled() {
        boolean enabled = false;
        if (!$assertionsDisabled) {
            enabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return enabled;
    }

    private static boolean detectBootstrapEnvironment() {
        return System.getProperty("forge.enabledGameTestNamespaces") == null && Helpers.detectTestSourcesPresent();
    }

    private static boolean detectTestSourcesPresent() {
        try {
            Class.forName("net.dries007.tfc.TestMarker");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    static abstract class ItemProtectedAccessor
    extends Item {
        static BlockHitResult invokeGetPlayerPOVHitResult(Level level, Player player, ClipContext.Fluid mode) {
            return Item.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)mode);
        }

        private ItemProtectedAccessor() {
            super(null);
        }
    }
}

