/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import com.google.gson.JsonObject;
import java.util.Collection;
import net.dries007.tfc.common.recipes.ingredients.FluidIngredient;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;

public class FluidDefinition {
    protected final ResourceLocation id;
    protected final FluidIngredient ingredient;

    protected FluidDefinition(ResourceLocation id, JsonObject json) {
        this(id, FluidIngredient.fromJson(JsonHelpers.get(json, "ingredient")));
    }

    protected FluidDefinition(ResourceLocation id, FluidIngredient ingredient) {
        this.id = id;
        this.ingredient = ingredient;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public boolean matches(Fluid fluid) {
        return this.ingredient.test(fluid);
    }

    public Collection<Fluid> getFluids() {
        return this.ingredient.getMatchingFluids();
    }
}

