/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.dries007.tfc.network.DataManagerSyncPacket;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.SelfTests;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class DataManager<T>
extends SimpleJsonResourceReloadListener {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Gson GSON = new Gson();
    private static final Map<Class<?>, DataManager<?>> NETWORK_TYPES = new HashMap();
    protected final BiMap<ResourceLocation, T> types;
    protected final String typeName;
    @Nullable
    protected final BiFunction<ResourceLocation, FriendlyByteBuf, T> networkFactory;
    @Nullable
    protected final BiConsumer<T, FriendlyByteBuf> networkEncoder;
    @Nullable
    protected final Supplier<? extends DataManagerSyncPacket<T>> networkPacketFactory;
    private final BiFunction<ResourceLocation, JsonObject, T> factory;

    private static <T> void assertUniquePacketTypes(DataManager<?> instance, @Nullable Supplier<? extends DataManagerSyncPacket<T>> networkPacketFactory) {
        Class<?> packetType;
        DataManager<?> old;
        if (Helpers.ASSERTIONS_ENABLED && networkPacketFactory != null && (old = NETWORK_TYPES.put(packetType = networkPacketFactory.get().getClass(), instance)) != null) {
            throw new IllegalStateException("Packet class " + packetType.getSimpleName() + " registered for managers for " + old.typeName + " and " + instance.typeName);
        }
    }

    public DataManager(ResourceLocation domain, String typeName, BiFunction<ResourceLocation, JsonObject, T> factory) {
        this(domain, typeName, factory, null, null, null);
    }

    public DataManager(ResourceLocation domain, String typeName, BiFunction<ResourceLocation, JsonObject, T> factory, @Nullable BiFunction<ResourceLocation, FriendlyByteBuf, T> networkFactory, @Nullable BiConsumer<T, FriendlyByteBuf> networkEncoder, @Nullable Supplier<? extends DataManagerSyncPacket<T>> networkPacketFactory) {
        super(GSON, domain.m_135827_() + "/" + domain.m_135815_());
        DataManager.assertUniquePacketTypes(this, networkPacketFactory);
        this.factory = factory;
        this.networkFactory = networkFactory;
        this.networkEncoder = networkEncoder;
        this.networkPacketFactory = networkPacketFactory;
        this.types = HashBiMap.create();
        this.typeName = typeName;
    }

    @Nullable
    public T get(ResourceLocation id) {
        return (T)this.types.get((Object)id);
    }

    public Supplier<T> getLazyOrThrow(ResourceLocation id) {
        return Lazy.of(() -> this.getOrThrow(id));
    }

    public T getOrThrow(ResourceLocation id) {
        Object t = this.types.get((Object)id);
        if (t == null) {
            throw new IllegalArgumentException("No " + this.typeName + " with id " + id);
        }
        return (T)t;
    }

    public ResourceLocation getIdOrThrow(T type) {
        ResourceLocation id = this.getId(type);
        if (id == null) {
            throw new IllegalArgumentException("No id for " + this.typeName + ": " + type);
        }
        return id;
    }

    @Nullable
    public ResourceLocation getId(T type) {
        return (ResourceLocation)this.types.inverse().get(type);
    }

    public Set<T> getValues() {
        return this.types.values();
    }

    public void toNetwork(T element, FriendlyByteBuf buffer) {
        buffer.m_130085_(this.getIdOrThrow(element));
    }

    public Supplier<T> fromNetwork(FriendlyByteBuf buffer) {
        ResourceLocation id = buffer.m_130281_();
        return Suppliers.memoize(() -> this.getOrThrow(id));
    }

    public DataManagerSyncPacket<T> createSyncPacket() {
        return this.createEmptyPacket().with((Map<ResourceLocation, T>)this.types);
    }

    public DataManagerSyncPacket<T> createEmptyPacket() {
        assert (this.networkPacketFactory != null);
        return this.networkPacketFactory.get();
    }

    public T read(ResourceLocation id, JsonObject obj) {
        return this.factory.apply(id, obj);
    }

    public void rawToNetwork(FriendlyByteBuf buffer, T element) {
        assert (this.networkEncoder != null);
        this.networkEncoder.accept(element, buffer);
    }

    public T rawFromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
        assert (this.networkFactory != null);
        return this.networkFactory.apply(id, buffer);
    }

    public void onSync(NetworkEvent.Context context, Map<ResourceLocation, T> elements) {
        if (context.getNetworkManager().m_129531_()) {
            LOGGER.info("Ignored {}(s) sync from logical server", (Object)this.typeName);
        } else {
            this.types.clear();
            this.types.putAll(elements);
            LOGGER.info("Received {} {}(s) from physical server", (Object)this.types.size(), (Object)this.typeName);
        }
    }

    protected void apply(Map<ResourceLocation, JsonElement> elements, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        this.types.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : elements.entrySet()) {
            ResourceLocation name = entry.getKey();
            JsonObject json = GsonHelper.m_13918_((JsonElement)entry.getValue(), (String)this.typeName);
            try {
                if (CraftingHelper.processConditions((JsonObject)json, (String)"conditions", (ICondition.IContext)ICondition.IContext.EMPTY)) {
                    T object = this.read(name, json);
                    this.types.put((Object)name, object);
                    continue;
                }
                LOGGER.debug("Skipping loading {} '{}' as it's conditions were not met", (Object)this.typeName, (Object)name);
            }
            catch (JsonParseException | IllegalArgumentException e) {
                LOGGER.error("{} '{}' failed to parse. {}: {}", new Object[]{this.typeName, name, e.getClass().getSimpleName(), e.getMessage()});
                SelfTests.reportExternalError();
            }
        }
        LOGGER.info("Loaded {} {}(s).", (Object)this.types.size(), (Object)this.typeName);
    }
}

