/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import com.google.gson.JsonObject;
import net.dries007.tfc.common.recipes.ingredients.BlockIngredient;
import net.dries007.tfc.common.recipes.ingredients.BlockIngredients;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;

public class BlockDefinition {
    protected final ResourceLocation id;
    protected final BlockIngredient ingredient;

    public BlockDefinition(ResourceLocation id, JsonObject json) {
        this.id = id;
        this.ingredient = BlockIngredients.fromJson(json.get("ingredient"));
    }

    public BlockDefinition(ResourceLocation id, FriendlyByteBuf buffer) {
        this.id = id;
        this.ingredient = BlockIngredients.fromNetwork(buffer);
    }

    public boolean matches(BlockState state) {
        return this.ingredient.test(state);
    }

    public void encode(FriendlyByteBuf buffer) {
        this.ingredient.toNetwork(buffer);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public BlockIngredient getIngredient() {
        return this.ingredient;
    }
}

