/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.dries007.tfc.TerraFirmaCraft;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.Nullable;

public final class NetworkRecipeParityCheck {
    private static final int HEADER = 1234567890;

    public static <T extends Recipe<?>> void encodeRecipePrefix(FriendlyByteBuf buffer, T recipe) {
        RecipeSerializer serializer = recipe.m_7707_();
        ByteBuf raw = Unpooled.buffer();
        serializer.m_6178_(new FriendlyByteBuf(raw), recipe);
        int size = raw.readableBytes();
        ResourceLocation serializerId = Registry.f_122865_.m_7981_((Object)serializer);
        if (serializerId == null) {
            throw new IllegalStateException("Missing recipe serializer! No serializer for recipe '" + recipe.m_6423_() + "' of type '" + recipe.m_6671_() + "'");
        }
        buffer.writeInt(1234567890);
        buffer.writeInt(size);
    }

    @Nullable
    public static Recipe<?> decodeRecipe(FriendlyByteBuf buffer) {
        Recipe recipe;
        int header = buffer.readInt();
        if (header != 1234567890) {
            throw new IllegalStateException("Received an invalid header to decode a recipe, expected 1234567890, got " + header);
        }
        int expected = buffer.readInt();
        ResourceLocation serializerId = buffer.m_130281_();
        ResourceLocation recipeId = buffer.m_130281_();
        RecipeSerializer serializer = (RecipeSerializer)Registry.f_122865_.m_6612_(serializerId).orElseThrow(() -> new IllegalStateException("Unknown recipe serializer '" + serializerId + "' when decoding recipe '" + recipeId + "'. [Parity: Expected " + expected + " bytes | Read 0 bytes]"));
        int before = buffer.readableBytes();
        try {
            recipe = serializer.m_8005_(recipeId, buffer);
        }
        catch (RuntimeException e) {
            TerraFirmaCraft.LOGGER.error("Trace", (Throwable)e);
            throw new IllegalStateException("Recipe '" + recipeId + "' with serializer '" + serializerId + "' threw an exception trying to decode: " + e.getMessage(), e);
        }
        int after = buffer.readableBytes();
        int actual = before - after;
        if (actual != expected) {
            throw new IllegalStateException("Recipe '" + recipeId + "' of type '" + (recipe == null ? "<null>" : recipe.m_6671_()) + "' with serializer '" + serializerId + "' didn't pass parity check! [Parity: Expected " + expected + " bytes | Read " + actual + " bytes]");
        }
        return recipe;
    }
}

