/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.mixin;

import java.util.Random;
import net.dries007.tfc.common.blocks.IcePileBlock;
import net.dries007.tfc.util.climate.Climate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={IceBlock.class})
public abstract class IceBlockMixin
extends Block {
    private IceBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Inject(method={"randomTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void meltRarelyDueToTemperature(BlockState state, ServerLevel level, BlockPos pos, Random random, CallbackInfo ci) {
        if (random.nextInt(200) == 0 && Climate.getTemperature((Level)level, pos) > 2.0f) {
            IcePileBlock.removeIcePileOrIce((LevelAccessor)level, pos, state);
            ci.cancel();
        }
    }
}

