/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.config;

import com.mojang.logging.LogUtils;
import java.util.function.Function;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.slf4j.Logger;

public class CommonConfig {
    private static final Logger LOGGER = LogUtils.getLogger();
    public final ForgeConfigSpec.BooleanValue setTFCWorldTypeAsDefault;
    public final ForgeConfigSpec.IntValue defaultMonthLength;
    public final ForgeConfigSpec.IntValue defaultCalendarStartDay;
    private final ForgeConfigSpec.BooleanValue enableNetworkDebugging;
    private boolean hasLoggedNetworkDebugInfoMessage = false;
    public final ForgeConfigSpec.BooleanValue enableDatapackTests;

    CommonConfig(ForgeConfigSpec.Builder innerBuilder) {
        Function<String, ForgeConfigSpec.Builder> builder = name -> innerBuilder.translation("tfc.config.general." + name);
        innerBuilder.push("general");
        this.setTFCWorldTypeAsDefault = builder.apply("setTFCWorldTypeAsDefault").comment(new String[]{" If the TFC world type (tfc:tng) should be set as the default world generation.", " 1. This ONLY sets the corresponding config option in Forge's config.", " 2. This ONLY will set the default if it was set to 'default' (or vanilla generation)", " 3. This DOES NOT guarantee that the world generation will be TFC, if another mod sets the default another way"}).define("setTFCWorldTypeAsDefault", true);
        innerBuilder.pop().push("calendar");
        this.defaultMonthLength = builder.apply("defaultMonthLength").comment(new String[]{" The number of days in a month, for newly created worlds.", " This can be modified in existing worlds using the /time command"}).defineInRange("defaultMonthLength", 8, 1, Integer.MAX_VALUE);
        this.defaultCalendarStartDay = builder.apply("defaultCalendarStartDay").comment(new String[]{" The start date for newly created worlds, in a number of ticks, for newly created worlds", " This represents a number of days offset from January 1, 1000", " The default is (5 * daysInMonth) = 40, which starts at June 1, 1000 (with the default daysInMonth = 8)"}).defineInRange("defaultCalendarStartDay", 40, -1, Integer.MAX_VALUE);
        innerBuilder.pop().push("debug");
        this.enableNetworkDebugging = builder.apply("enableNetworkDebugging").comment(new String[]{" Enables a series of network fail-safes that are used to debug network connections between client and servers.", " Important: this MUST BE THE SAME as what the server has set, otherwise you are liable to see even stranger errors."}).define("enableNetworkDebugging", () -> !FMLEnvironment.production);
        this.enableDatapackTests = builder.apply("enableDatapackTests").comment("If enabled, TFC will validate that certain pieces of reloadable data fit the conditions we expect, for example heating recipes having heatable items. It will error or warn in the log if these conditions are not met.").define("enableDatapackTests", () -> !FMLEnvironment.production);
    }

    public boolean enableNetworkDebugging() {
        if (!this.hasLoggedNetworkDebugInfoMessage) {
            this.hasLoggedNetworkDebugInfoMessage = true;
            LOGGER.info("TFC Network Debugging = {}", this.enableNetworkDebugging.get());
        }
        return (Boolean)this.enableNetworkDebugging.get();
    }
}

