/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.patchouli.component;

import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.dries007.tfc.compat.patchouli.component.CustomComponent;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.IVariable;

public class MultiMultiBlockComponent
extends CustomComponent {
    @SerializedName(value="multiblocks")
    private String multiblocks;
    @Nullable
    private transient List<Supplier<IMultiblock>> resolvedMultiblocks;
    @Nullable
    private transient List<CustomComponent.MultiblockRenderer> renderers;

    @Override
    public void onVariablesAvailable(UnaryOperator<IVariable> lookup) {
        this.resolvedMultiblocks = ((IVariable)lookup.apply(IVariable.wrap((String)this.multiblocks))).asStream().map(this::asMultiblock).flatMap(Optional::stream).toList();
    }

    @Override
    public void build(int componentX, int componentY, int pageNum) {
        super.build(componentX, componentY, pageNum);
        this.renderers = Optional.ofNullable(this.resolvedMultiblocks).map(r -> r.stream().map(this::asMultiblockRenderer).flatMap(Optional::stream).toList()).orElse(null);
    }

    @Override
    public void render(PoseStack poseStack, IComponentRenderContext context, float partialTicks, int mouseX, int mouseY) {
        if (this.renderers != null && !this.renderers.isEmpty()) {
            this.renderers.get(context.getTicksInBook() / 20 % this.renderers.size()).render(context, poseStack, mouseX, mouseY, partialTicks);
        }
    }
}

