/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.jei.category;

import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.dries007.tfc.client.screen.KnappingScreen;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.rock.Rock;
import net.dries007.tfc.common.recipes.RockKnappingRecipe;
import net.dries007.tfc.compat.jei.JEIIntegration;
import net.dries007.tfc.compat.jei.category.KnappingRecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class RockKnappingRecipeCategory
extends KnappingRecipeCategory<RockKnappingRecipe> {
    private static final String ROCK_SLOT_NAME = "input";
    private final IDrawableStatic blank;
    private final IGuiHelper helper;

    public RockKnappingRecipeCategory(RecipeType<RockKnappingRecipe> type, IGuiHelper helper) {
        super(type, helper, new ItemStack((ItemLike)TFCBlocks.ROCK_BLOCKS.get(Rock.CHERT).get((Object)Rock.BlockType.LOOSE).get()), null, null);
        this.helper = helper;
        this.blank = helper.createBlankDrawable(1, 1);
    }

    @Override
    @Nullable
    public IDrawable getHigh(RockKnappingRecipe recipe, IRecipeSlotsView slots) {
        return (IDrawable)slots.findSlotByName(ROCK_SLOT_NAME).flatMap(slot -> slot.getDisplayedIngredient(JEIIntegration.ITEM_STACK)).map(displayed -> {
            ResourceLocation high = KnappingScreen.getButtonLocation(displayed.m_41720_(), false);
            return this.helper.drawableBuilder(high, 0, 0, 16, 16).setTextureSize(16, 16).build();
        }).orElse(this.blank);
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, RockKnappingRecipe recipe, IFocusGroup focuses) {
        IRecipeSlotBuilder inputSlot = builder.addSlot(RecipeIngredientRole.INPUT, 89, 61);
        inputSlot.addIngredients(recipe.getIngredient());
        inputSlot.setSlotName(ROCK_SLOT_NAME);
        inputSlot.setBackground((IDrawable)this.slot, -1, -1);
        super.setRecipe(builder, recipe, focuses);
    }
}

