/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.jei.category;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.compat.jei.JEIIntegration;
import net.dries007.tfc.compat.jei.category.BaseRecipeCategory;
import net.dries007.tfc.config.HeatTooltipStyle;
import net.dries007.tfc.config.TFCConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;

public class HeatingCategory
extends BaseRecipeCategory<HeatingRecipe> {
    public HeatingCategory(RecipeType<HeatingRecipe> type, IGuiHelper helper) {
        super(type, helper, (IDrawable)helper.createBlankDrawable(120, 38), new ItemStack((ItemLike)TFCBlocks.FIREPIT.get()));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, HeatingRecipe recipe, IFocusGroup focuses) {
        IRecipeSlotBuilder inputSlot = builder.addSlot(RecipeIngredientRole.INPUT, 21, 17);
        IRecipeSlotBuilder outputSlot = builder.addSlot(RecipeIngredientRole.OUTPUT, 85, 17);
        inputSlot.addIngredients(recipe.getIngredient());
        inputSlot.setBackground((IDrawable)this.slot, -1, -1);
        List<ItemStack> outputItems = Arrays.stream(recipe.getIngredient().m_43908_()).map(stack -> recipe.assemble(new ItemStackInventory((ItemStack)stack))).toList();
        FluidStack resultFluid = recipe.getDisplayOutputFluid();
        if (!outputItems.isEmpty() && !outputItems.stream().allMatch(ItemStack::m_41619_)) {
            outputSlot.addItemStacks(outputItems);
        }
        if (!resultFluid.isEmpty()) {
            outputSlot.addIngredient(JEIIntegration.FLUID_STACK, (Object)resultFluid);
            outputSlot.setFluidRenderer(1, false, 16, 16);
        }
        outputSlot.setBackground((IDrawable)this.slot, -1, -1);
    }

    public void draw(HeatingRecipe recipe, IRecipeSlotsView recipeSlots, PoseStack stack, double mouseX, double mouseY) {
        this.fire.draw(stack, 54, 16);
        this.fireAnimated.draw(stack, 54, 16);
        MutableComponent color = ((HeatTooltipStyle)((Object)TFCConfig.CLIENT.heatTooltipStyle.get())).formatColored(recipe.getTemperature());
        if (color != null) {
            Minecraft mc = Minecraft.m_91087_();
            Font font = mc.f_91062_;
            font.m_92889_(stack, (Component)color, 60.0f - (float)font.m_92852_((FormattedText)color) / 2.0f, 4.0f, 0xFFFFFF);
        }
    }
}

