/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.jei.category;

import java.util.Arrays;
import java.util.List;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.recipes.ingredients.BlockIngredient;
import net.dries007.tfc.common.recipes.ingredients.FluidStackIngredient;
import net.dries007.tfc.common.recipes.ingredients.ItemStackIngredient;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.compat.jei.JEIIntegration;
import net.dries007.tfc.util.Helpers;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;

public abstract class BaseRecipeCategory<T>
implements IRecipeCategory<T> {
    public static final ResourceLocation ICONS = new ResourceLocation("tfc", "textures/gui/jei/icons.png");
    protected final IDrawableStatic slot;
    protected final IDrawableStatic fire;
    protected final IDrawableAnimated fireAnimated;
    protected final IDrawableStatic arrow;
    protected final IDrawableAnimated arrowAnimated;
    private final RecipeType<T> type;
    private final Component title;
    private final IDrawable background;
    private final IDrawable icon;

    public static List<FluidStack> collapse(FluidStackIngredient ingredient) {
        return ingredient.ingredient().getMatchingFluids().stream().map(fluid -> new FluidStack(fluid, ingredient.amount())).toList();
    }

    public static List<ItemStack> collapse(ItemStackIngredient input) {
        return Arrays.stream(input.ingredient().m_43908_()).map(stack -> Helpers.copyWithSize(stack, input.count())).map(FoodCapability::setStackNonDecaying).toList();
    }

    public static List<ItemStack> collapse(List<ItemStack> inputs, ItemStackProvider output) {
        return inputs.stream().map(output::getStack).map(FoodCapability::setStackNonDecaying).toList();
    }

    public static Ingredient collapse(BlockIngredient ingredient) {
        return Ingredient.m_43921_(ingredient.getValidBlocks().stream().map(ItemStack::new).filter(item -> !item.m_41619_()));
    }

    public BaseRecipeCategory(RecipeType<T> type, IGuiHelper helper, IDrawable background, ItemStack icon) {
        this.type = type;
        this.title = Helpers.translatable("tfc.jei." + type.getUid().m_135815_());
        this.background = background;
        this.icon = helper.createDrawableIngredient(JEIIntegration.ITEM_STACK, (Object)icon);
        this.slot = helper.getSlotDrawable();
        this.fire = helper.createDrawable(ICONS, 0, 0, 14, 14);
        IDrawableStatic fireAnimated = helper.createDrawable(ICONS, 14, 0, 14, 14);
        this.fireAnimated = helper.createAnimatedDrawable(fireAnimated, 160, IDrawableAnimated.StartDirection.TOP, true);
        this.arrow = helper.createDrawable(ICONS, 0, 14, 22, 16);
        IDrawableStatic arrowAnimated = helper.createDrawable(ICONS, 22, 14, 22, 16);
        this.arrowAnimated = helper.createAnimatedDrawable(arrowAnimated, 80, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public Class<? extends T> getRecipeClass() {
        return this.type.getRecipeClass();
    }

    public ResourceLocation getUid() {
        return this.type.getUid();
    }

    public RecipeType<T> getRecipeType() {
        return this.type;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }
}

