/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.jei;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.client.screen.KnappingScreen;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.common.recipes.AdvancedShapelessRecipe;
import net.dries007.tfc.common.recipes.AlloyRecipe;
import net.dries007.tfc.common.recipes.AnvilRecipe;
import net.dries007.tfc.common.recipes.BlastFurnaceRecipe;
import net.dries007.tfc.common.recipes.BloomeryRecipe;
import net.dries007.tfc.common.recipes.CastingRecipe;
import net.dries007.tfc.common.recipes.ChiselRecipe;
import net.dries007.tfc.common.recipes.ExtraProductsCraftingRecipe;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.common.recipes.InstantBarrelRecipe;
import net.dries007.tfc.common.recipes.InstantFluidBarrelRecipe;
import net.dries007.tfc.common.recipes.KnappingRecipe;
import net.dries007.tfc.common.recipes.LoomRecipe;
import net.dries007.tfc.common.recipes.PotRecipe;
import net.dries007.tfc.common.recipes.QuernRecipe;
import net.dries007.tfc.common.recipes.RockKnappingRecipe;
import net.dries007.tfc.common.recipes.ScrapingRecipe;
import net.dries007.tfc.common.recipes.SealedBarrelRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.WeldingRecipe;
import net.dries007.tfc.compat.jei.category.AlloyRecipeCategory;
import net.dries007.tfc.compat.jei.category.AnvilRecipeCategory;
import net.dries007.tfc.compat.jei.category.BlastFurnaceRecipeCategory;
import net.dries007.tfc.compat.jei.category.BloomeryRecipeCategory;
import net.dries007.tfc.compat.jei.category.CastingRecipeCategory;
import net.dries007.tfc.compat.jei.category.ChiselRecipeCategory;
import net.dries007.tfc.compat.jei.category.HeatingCategory;
import net.dries007.tfc.compat.jei.category.InstantBarrelRecipeCategory;
import net.dries007.tfc.compat.jei.category.InstantFluidBarrelRecipeCategory;
import net.dries007.tfc.compat.jei.category.KnappingRecipeCategory;
import net.dries007.tfc.compat.jei.category.LoomRecipeCategory;
import net.dries007.tfc.compat.jei.category.QuernRecipeCategory;
import net.dries007.tfc.compat.jei.category.RockKnappingRecipeCategory;
import net.dries007.tfc.compat.jei.category.ScrapingRecipeCategory;
import net.dries007.tfc.compat.jei.category.SealedBarrelRecipeCategory;
import net.dries007.tfc.compat.jei.category.SimplePotRecipeCategory;
import net.dries007.tfc.compat.jei.category.SoupPotRecipeCategory;
import net.dries007.tfc.compat.jei.category.WeldingRecipeCategory;
import net.dries007.tfc.compat.jei.extension.AdvancedShapelessExtension;
import net.dries007.tfc.compat.jei.extension.ExtraProductsExtension;
import net.dries007.tfc.util.Helpers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

@JeiPlugin
public final class JEIIntegration
implements IModPlugin {
    public static final IIngredientTypeWithSubtypes<Item, ItemStack> ITEM_STACK = VanillaTypes.ITEM_STACK;
    public static final IIngredientType<FluidStack> FLUID_STACK = ForgeTypes.FLUID_STACK;
    public static final RecipeType<HeatingRecipe> HEATING = JEIIntegration.type("heating", HeatingRecipe.class);
    public static final RecipeType<ScrapingRecipe> SCRAPING = JEIIntegration.type("scraping", ScrapingRecipe.class);
    public static final RecipeType<QuernRecipe> QUERN = JEIIntegration.type("quern", QuernRecipe.class);
    public static final RecipeType<KnappingRecipe> CLAY_KNAPPING = JEIIntegration.type("clay_knapping", KnappingRecipe.class);
    public static final RecipeType<KnappingRecipe> FIRE_CLAY_KNAPPING = JEIIntegration.type("fire_clay_knapping", KnappingRecipe.class);
    public static final RecipeType<KnappingRecipe> LEATHER_KNAPPING = JEIIntegration.type("leather_knapping", KnappingRecipe.class);
    public static final RecipeType<RockKnappingRecipe> ROCK_KNAPPING = JEIIntegration.type("rock_knapping", RockKnappingRecipe.class);
    public static final RecipeType<PotRecipe> SOUP_POT = JEIIntegration.type("soup_pot", PotRecipe.class);
    public static final RecipeType<PotRecipe> SIMPLE_POT = JEIIntegration.type("simple_pot", PotRecipe.class);
    public static final RecipeType<CastingRecipe> CASTING = JEIIntegration.type("casting", CastingRecipe.class);
    public static final RecipeType<LoomRecipe> LOOM = JEIIntegration.type("loom", LoomRecipe.class);
    public static final RecipeType<AlloyRecipe> ALLOYING = JEIIntegration.type("alloying", AlloyRecipe.class);
    public static final RecipeType<SealedBarrelRecipe> SEALED_BARREL = JEIIntegration.type("sealed_barrel", SealedBarrelRecipe.class);
    public static final RecipeType<InstantBarrelRecipe> INSTANT_BARREL = JEIIntegration.type("instant_barrel", InstantBarrelRecipe.class);
    public static final RecipeType<InstantFluidBarrelRecipe> INSTANT_FLUID_BARREL = JEIIntegration.type("instant_fluid_barrel", InstantFluidBarrelRecipe.class);
    public static final RecipeType<BloomeryRecipe> BLOOMERY = JEIIntegration.type("bloomery", BloomeryRecipe.class);
    public static final RecipeType<WeldingRecipe> WELDING = JEIIntegration.type("welding", WeldingRecipe.class);
    public static final RecipeType<AnvilRecipe> ANVIL = JEIIntegration.type("anvil", AnvilRecipe.class);
    public static final RecipeType<ChiselRecipe> CHISEL = JEIIntegration.type("chisel", ChiselRecipe.class);
    public static final RecipeType<BlastFurnaceRecipe> BLAST_FURNACE = JEIIntegration.type("blast_furnace", BlastFurnaceRecipe.class);

    private static <T> RecipeType<T> type(String name, Class<T> tClass) {
        return RecipeType.create((String)"tfc", (String)name, tClass);
    }

    private static <C extends Container, T extends Recipe<C>> List<T> recipes(net.minecraft.world.item.crafting.RecipeType<T> type) {
        return ClientHelpers.getLevelOrThrow().m_7465_().m_44013_(type);
    }

    private static <C extends Container, T extends Recipe<C>> List<T> recipes(net.minecraft.world.item.crafting.RecipeType<T> type, Predicate<T> filter) {
        return JEIIntegration.recipes(type).stream().filter(filter).collect(Collectors.toList());
    }

    private static void addRecipeCatalyst(IRecipeCatalystRegistration registry, TagKey<Item> tag, RecipeType<?> recipeType) {
        Helpers.getAllTagValues(tag, ForgeRegistries.ITEMS).forEach(item -> registry.addRecipeCatalyst(new ItemStack((ItemLike)item), new RecipeType[]{recipeType}));
    }

    private static void addRecipeCatalyst(IRecipeCatalystRegistration registry, Wood.BlockType wood, RecipeType<?> recipeType) {
        TFCBlocks.WOODS.values().stream().map(map -> (RegistryObject)map.get((Object)wood)).forEach(i -> registry.addRecipeCatalyst(new ItemStack((ItemLike)i.get()), new RecipeType[]{recipeType}));
    }

    public ResourceLocation getPluginUid() {
        return Helpers.identifier("jei");
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper gui = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new HeatingCategory(HEATING, gui), new QuernRecipeCategory(QUERN, gui), new ScrapingRecipeCategory(SCRAPING, gui), new KnappingRecipeCategory<KnappingRecipe>(CLAY_KNAPPING, gui, new ItemStack((ItemLike)Items.f_42461_), KnappingScreen.CLAY, KnappingScreen.CLAY_DISABLED), new KnappingRecipeCategory<KnappingRecipe>(FIRE_CLAY_KNAPPING, gui, new ItemStack((ItemLike)TFCItems.FIRE_CLAY.get()), KnappingScreen.FIRE_CLAY, KnappingScreen.FIRE_CLAY_DISABLED), new KnappingRecipeCategory<KnappingRecipe>(LEATHER_KNAPPING, gui, new ItemStack((ItemLike)Items.f_42454_), KnappingScreen.LEATHER, null), new RockKnappingRecipeCategory(ROCK_KNAPPING, gui), new SoupPotRecipeCategory(SOUP_POT, gui), new SimplePotRecipeCategory(SIMPLE_POT, gui), new CastingRecipeCategory(CASTING, gui), new LoomRecipeCategory(LOOM, gui), new AlloyRecipeCategory(ALLOYING, gui), new SealedBarrelRecipeCategory(SEALED_BARREL, gui), new InstantBarrelRecipeCategory(INSTANT_BARREL, gui), new InstantFluidBarrelRecipeCategory(INSTANT_FLUID_BARREL, gui), new BloomeryRecipeCategory(BLOOMERY, gui), new WeldingRecipeCategory(WELDING, gui), new AnvilRecipeCategory(ANVIL, gui), new ChiselRecipeCategory(CHISEL, gui), new BlastFurnaceRecipeCategory(BLAST_FURNACE, gui)});
    }

    public void registerRecipes(IRecipeRegistration registry) {
        registry.addRecipes(HEATING, JEIIntegration.recipes((net.minecraft.world.item.crafting.RecipeType)TFCRecipeTypes.HEATING.get()));
        registry.addRecipes(SCRAPING, JEIIntegration.recipes((net.minecraft.world.item.crafting.RecipeType)TFCRecipeTypes.SCRAPING.get()));
        registry.addRecipes(QUERN, JEIIntegration.recipes((net.minecraft.world.item.crafting.RecipeType)TFCRecipeTypes.QUERN.get()));
        registry.addRecipes(CLAY_KNAPPING, JEIIntegration.recipes((net.minecraft.world.item.crafting.RecipeType)TFCRecipeTypes.CLAY_KNAPPING.get()));
        registry.addRecipes(FIRE_CLAY_KNAPPING, JEIIntegration.recipes((net.minecraft.world.item.crafting.RecipeType)TFCRecipeTypes.FIRE_CLAY_KNAPPING.get()));
        registry.addRecipes(LEATHER_KNAPPING, JEIIntegration.recipes((net.minecraft.world.item.crafting.RecipeType)TFCRecipeTypes.LEATHER_KNAPPING.get()));
        registry.addRecipes(ROCK_KNAPPING, JEIIntegration.recipes((net.minecraft.world.item.crafting.RecipeType)TFCRecipeTypes.ROCK_KNAPPING.get()));
        registry.addRecipes(SOUP_POT, JEIIntegration.recipes((net.minecraft.world.item.crafting.RecipeType)TFCRecipeTypes.POT.get(), recipe -> recipe.m_7707_() == TFCRecipeSerializers.POT_SOUP.get()));
        registry.addRecipes(SIMPLE_POT, JEIIntegration.recipes((net.minecraft.world.item.crafting.RecipeType)TFCRecipeTypes.POT.get(), recipe -> recipe.m_7707_() == TFCRecipeSerializers.POT_SIMPLE.get()));
        registry.addRecipes(CASTING, JEIIntegration.recipes((net.minecraft.world.item.crafting.RecipeType)TFCRecipeTypes.CASTING.get()));
        registry.addRecipes(LOOM, JEIIntegration.recipes((net.minecraft.world.item.crafting.RecipeType)TFCRecipeTypes.LOOM.get()));
        registry.addRecipes(ALLOYING, JEIIntegration.recipes((net.minecraft.world.item.crafting.RecipeType)TFCRecipeTypes.ALLOY.get()));
        registry.addRecipes(SEALED_BARREL, JEIIntegration.recipes((net.minecraft.world.item.crafting.RecipeType)TFCRecipeTypes.BARREL_SEALED.get()));
        registry.addRecipes(INSTANT_BARREL, JEIIntegration.recipes((net.minecraft.world.item.crafting.RecipeType)TFCRecipeTypes.BARREL_INSTANT.get()));
        registry.addRecipes(INSTANT_FLUID_BARREL, JEIIntegration.recipes((net.minecraft.world.item.crafting.RecipeType)TFCRecipeTypes.BARREL_INSTANT_FLUID.get()));
        registry.addRecipes(BLOOMERY, JEIIntegration.recipes((net.minecraft.world.item.crafting.RecipeType)TFCRecipeTypes.BLOOMERY.get()));
        registry.addRecipes(WELDING, JEIIntegration.recipes((net.minecraft.world.item.crafting.RecipeType)TFCRecipeTypes.WELDING.get()));
        registry.addRecipes(ANVIL, JEIIntegration.recipes((net.minecraft.world.item.crafting.RecipeType)TFCRecipeTypes.ANVIL.get()));
        registry.addRecipes(CHISEL, JEIIntegration.recipes((net.minecraft.world.item.crafting.RecipeType)TFCRecipeTypes.CHISEL.get()));
        registry.addRecipes(BLAST_FURNACE, JEIIntegration.recipes((net.minecraft.world.item.crafting.RecipeType)TFCRecipeTypes.BLAST_FURNACE.get()));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst(new ItemStack((ItemLike)TFCBlocks.FIREPIT.get()), new RecipeType[]{HEATING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)TFCBlocks.QUERN.get()), new RecipeType[]{QUERN});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)TFCItems.POT.get()), new RecipeType[]{SIMPLE_POT});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)TFCItems.POT.get()), new RecipeType[]{SOUP_POT});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)TFCBlocks.CRUCIBLE.get()), new RecipeType[]{ALLOYING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)TFCItems.VESSEL.get()), new RecipeType[]{ALLOYING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)TFCBlocks.BLOOMERY.get()), new RecipeType[]{BLOOMERY});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)TFCBlocks.BLAST_FURNACE.get()), new RecipeType[]{BLAST_FURNACE});
        for (RegistryObject<Item> reg : TFCItems.GLAZED_VESSELS.values()) {
            registry.addRecipeCatalyst(new ItemStack((ItemLike)reg.get()), new RecipeType[]{ALLOYING});
        }
        JEIIntegration.addRecipeCatalyst(registry, TFCTags.Items.KNIVES, SCRAPING);
        JEIIntegration.addRecipeCatalyst(registry, TFCTags.Items.HANDSTONE, QUERN);
        JEIIntegration.addRecipeCatalyst(registry, TFCTags.Items.CLAY_KNAPPING, CLAY_KNAPPING);
        JEIIntegration.addRecipeCatalyst(registry, TFCTags.Items.FIRE_CLAY_KNAPPING, FIRE_CLAY_KNAPPING);
        JEIIntegration.addRecipeCatalyst(registry, TFCTags.Items.LEATHER_KNAPPING, LEATHER_KNAPPING);
        JEIIntegration.addRecipeCatalyst(registry, TFCTags.Items.ROCK_KNAPPING, ROCK_KNAPPING);
        JEIIntegration.addRecipeCatalyst(registry, TFCTags.Items.ANVILS, WELDING);
        JEIIntegration.addRecipeCatalyst(registry, TFCTags.Items.ANVILS, ANVIL);
        JEIIntegration.addRecipeCatalyst(registry, TFCTags.Items.TUYERES, BLAST_FURNACE);
        JEIIntegration.addRecipeCatalyst(registry, Wood.BlockType.LOOM, LOOM);
        JEIIntegration.addRecipeCatalyst(registry, Wood.BlockType.BARREL, SEALED_BARREL);
        JEIIntegration.addRecipeCatalyst(registry, Wood.BlockType.BARREL, INSTANT_BARREL);
        JEIIntegration.addRecipeCatalyst(registry, Wood.BlockType.BARREL, INSTANT_FLUID_BARREL);
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registry) {
        registry.getCraftingCategory().addCategoryExtension(AdvancedShapelessRecipe.class, AdvancedShapelessExtension::new);
        registry.getCraftingCategory().addCategoryExtension(ExtraProductsCraftingRecipe.class, ExtraProductsExtension::new);
    }
}

