/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.PotBlockEntity;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodData;
import net.dries007.tfc.common.capabilities.food.IFood;
import net.dries007.tfc.common.capabilities.food.Nutrient;
import net.dries007.tfc.common.items.DynamicBowlFood;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.common.recipes.PotRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.ingredients.FluidStackIngredient;
import net.dries007.tfc.util.Helpers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.ItemHandlerHelper;

public class SoupPotRecipe
extends PotRecipe {
    public static final PotRecipe.OutputType OUTPUT_TYPE = nbt -> {
        ItemStack stack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("item"));
        return new SoupOutput(stack);
    };
    public static final int SOUP_HUNGER_VALUE = 4;
    public static final float SOUP_DECAY_MODIFIER = 3.5f;

    public SoupPotRecipe(ResourceLocation id, List<Ingredient> itemIngredients, FluidStackIngredient fluidIngredient, int duration, float minTemp) {
        super(id, itemIngredients, fluidIngredient, duration, minTemp);
    }

    @Override
    public PotRecipe.Output getOutput(PotBlockEntity.PotInventory inventory) {
        Object data;
        int ingredientCount = 0;
        float water = 20.0f;
        float saturation = 2.0f;
        float[] nutrition = new float[Nutrient.TOTAL];
        ItemStack soupStack = ItemStack.f_41583_;
        ArrayList<ItemStack> itemIngredients = new ArrayList<ItemStack>();
        for (int i = 4; i <= 8; ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            IFood food = stack.getCapability(FoodCapability.CAPABILITY).resolve().orElse(null);
            if (food == null) continue;
            itemIngredients.add(stack);
            if (food.isRotten()) {
                ingredientCount = 0;
                break;
            }
            data = food.getData();
            water += ((FoodData)data).water();
            saturation += ((FoodData)data).saturation();
            Nutrient[] nutrientArray = Nutrient.VALUES;
            int n = nutrientArray.length;
            for (int j = 0; j < n; ++j) {
                Nutrient nutrient = nutrientArray[j];
                int n2 = nutrient.ordinal();
                nutrition[n2] = nutrition[n2] + ((FoodData)data).nutrient(nutrient);
            }
            ++ingredientCount;
        }
        if (ingredientCount > 0) {
            float multiplier = 1.0f - 0.05f * (float)ingredientCount;
            water *= multiplier;
            saturation *= multiplier;
            Nutrient maxNutrient = Nutrient.GRAIN;
            float maxNutrientValue = 0.0f;
            for (Nutrient nutrient : Nutrient.VALUES) {
                int idx;
                int n = idx = nutrient.ordinal();
                nutrition[n] = nutrition[n] * multiplier;
                if (!(nutrition[idx] > maxNutrientValue)) continue;
                maxNutrientValue = nutrition[idx];
                maxNutrient = nutrient;
            }
            data = FoodData.create(4, water, saturation, nutrition, 3.5f);
            int servings = (int)((float)ingredientCount / 2.0f) + 1;
            long created = FoodCapability.getRoundedCreationDate();
            soupStack = new ItemStack((ItemLike)TFCItems.SOUPS.get((Object)maxNutrient).get(), servings);
            IFood food = soupStack.getCapability(FoodCapability.CAPABILITY).resolve().orElse(null);
            if (food instanceof DynamicBowlFood.DynamicBowlHandler) {
                DynamicBowlFood.DynamicBowlHandler handler = (DynamicBowlFood.DynamicBowlHandler)food;
                handler.setCreationDate(created);
                handler.setIngredients(itemIngredients);
                handler.setFood((FoodData)data);
            }
        }
        return new SoupOutput(soupStack);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TFCRecipeSerializers.POT_SOUP.get();
    }

    public record SoupOutput(ItemStack stack) implements PotRecipe.Output
    {
        @Override
        public boolean isEmpty() {
            return this.stack.m_41619_();
        }

        @Override
        public InteractionResult onInteract(PotBlockEntity entity, Player player, ItemStack clickedWith) {
            if (Helpers.isItem(clickedWith.m_41720_(), TFCTags.Items.SOUP_BOWLS) && !this.stack.m_41619_()) {
                this.stack.getCapability(FoodCapability.CAPABILITY).filter(food -> food instanceof DynamicBowlFood.DynamicBowlHandler).ifPresent(food -> ((DynamicBowlFood.DynamicBowlHandler)food).setBowl(clickedWith));
                clickedWith.m_41774_(1);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.stack.m_41620_(1));
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }

        @Override
        public int getFluidColor() {
            return -5881324;
        }

        @Override
        public void write(CompoundTag nbt) {
            nbt.m_128365_("item", (Tag)this.stack.m_41739_(new CompoundTag()));
        }

        @Override
        public PotRecipe.OutputType getType() {
            return OUTPUT_TYPE;
        }
    }

    public static class Serializer
    extends PotRecipe.Serializer<SoupPotRecipe> {
        @Override
        protected SoupPotRecipe fromJson(ResourceLocation recipeId, JsonObject json, List<Ingredient> ingredients, FluidStackIngredient fluidIngredient, int duration, float minTemp) {
            return new SoupPotRecipe(recipeId, ingredients, fluidIngredient, duration, minTemp);
        }

        @Override
        protected SoupPotRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer, List<Ingredient> ingredients, FluidStackIngredient fluidIngredient, int duration, float minTemp) {
            return new SoupPotRecipe(recipeId, ingredients, fluidIngredient, duration, minTemp);
        }
    }
}

