/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.container.KnappingContainer;
import net.dries007.tfc.common.recipes.KnappingRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.TypedRecipeSerializer;
import net.dries007.tfc.util.KnappingPattern;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class RockKnappingRecipe
extends KnappingRecipe {
    protected final Ingredient ingredient;

    public RockKnappingRecipe(ResourceLocation id, KnappingPattern matrix, ItemStack result, Ingredient ingredient) {
        super(id, matrix, result, (TypedRecipeSerializer)((Object)TFCRecipeSerializers.ROCK_KNAPPING.get()));
        this.ingredient = ingredient;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    @Override
    public boolean matches(KnappingContainer.Query query, Level level) {
        return query.container().getPattern().matches(this.getPattern()) && this.ingredient.test(query.container().getOriginalStack());
    }

    public boolean matchesItem(ItemStack stack) {
        return this.ingredient.test(stack);
    }

    public static class RockSerializer
    extends TypedRecipeSerializer<RockKnappingRecipe> {
        public RockKnappingRecipe fromJson(ResourceLocation id, JsonObject json) {
            ItemStack stack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            Ingredient ingredient = json.has("ingredient") ? Ingredient.m_43917_((JsonElement)json.get("ingredient")) : Ingredient.m_204132_(TFCTags.Items.ROCK_KNAPPING);
            return new RockKnappingRecipe(id, KnappingPattern.fromJson(json), stack, ingredient);
        }

        @Nullable
        public RockKnappingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            KnappingPattern pattern = KnappingPattern.fromNetwork(buffer);
            ItemStack stack = buffer.m_130267_();
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            return new RockKnappingRecipe(id, pattern, stack, ingredient);
        }

        public void toNetwork(FriendlyByteBuf buffer, RockKnappingRecipe recipe) {
            recipe.getPattern().toNetwork(buffer);
            buffer.m_130055_(recipe.m_8043_());
            recipe.ingredient.m_43923_(buffer);
        }

        @Override
        public RecipeType<?> getRecipeType() {
            return (RecipeType)TFCRecipeTypes.ROCK_KNAPPING.get();
        }
    }
}

