/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.dries007.tfc.common.blockentities.PotBlockEntity;
import net.dries007.tfc.common.recipes.ISimpleRecipe;
import net.dries007.tfc.common.recipes.RecipeSerializerImpl;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.ingredients.FluidStackIngredient;
import net.dries007.tfc.util.Helpers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class PotRecipe
implements ISimpleRecipe<PotBlockEntity.PotInventory> {
    private static final BiMap<ResourceLocation, OutputType> OUTPUT_TYPES = HashBiMap.create();
    private static final ResourceLocation EMPTY_ID = Helpers.identifier("empty");
    private static final Output EMPTY_INSTANCE = new Output(){};
    private static final OutputType EMPTY = PotRecipe.register(EMPTY_ID, nbt -> EMPTY_INSTANCE);
    protected final ResourceLocation id;
    protected final List<Ingredient> itemIngredients;
    protected final FluidStackIngredient fluidIngredient;
    protected final int duration;
    protected final float minTemp;

    public static synchronized OutputType register(ResourceLocation id, OutputType outputType) {
        if (OUTPUT_TYPES.containsKey((Object)id)) {
            throw new IllegalArgumentException("Duplicate key: " + id);
        }
        OUTPUT_TYPES.put((Object)id, (Object)outputType);
        return outputType;
    }

    protected PotRecipe(ResourceLocation id, List<Ingredient> itemIngredients, FluidStackIngredient fluidIngredient, int duration, float minTemp) {
        this.id = id;
        this.itemIngredients = itemIngredients;
        this.fluidIngredient = fluidIngredient;
        this.duration = duration;
        this.minTemp = minTemp;
    }

    public boolean matches(PotBlockEntity.PotInventory inventory, Level worldIn) {
        if (!this.fluidIngredient.test(inventory.getFluidInTank(0))) {
            return false;
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 4; i <= 8; ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            stacks.add(stack);
        }
        return Helpers.perfectMatchExists(stacks, this.itemIngredients);
    }

    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TFCRecipeTypes.POT.get();
    }

    public FluidStackIngredient getFluidIngredient() {
        return this.fluidIngredient;
    }

    public List<Ingredient> getItemIngredients() {
        return this.itemIngredients;
    }

    public boolean isHotEnough(float tempIn) {
        return tempIn > this.minTemp;
    }

    public int getDuration() {
        return this.duration;
    }

    public abstract Output getOutput(PotBlockEntity.PotInventory var1);

    public static interface Output {
        public static Output read(CompoundTag nbt) {
            OutputType type = (OutputType)OUTPUT_TYPES.getOrDefault((Object)new ResourceLocation(nbt.m_128461_("type")), (Object)EMPTY);
            return type.read(nbt);
        }

        public static CompoundTag write(Output output) {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("type", ((ResourceLocation)OUTPUT_TYPES.inverse().getOrDefault((Object)output.getType(), (Object)EMPTY_ID)).toString());
            output.write(nbt);
            return nbt;
        }

        default public boolean isEmpty() {
            return true;
        }

        @Deprecated
        default public boolean renderDefaultFluid() {
            return this.getFluidColor() == -5881324;
        }

        default public int getFluidColor() {
            return -1;
        }

        default public void onFinish(PotBlockEntity.PotInventory inventory) {
        }

        default public InteractionResult onInteract(PotBlockEntity entity, Player player, ItemStack clickedWith) {
            return InteractionResult.PASS;
        }

        default public OutputType getType() {
            return EMPTY;
        }

        default public void write(CompoundTag nbt) {
        }
    }

    public static interface OutputType {
        public Output read(CompoundTag var1);
    }

    public static abstract class Serializer<R extends PotRecipe>
    extends RecipeSerializerImpl<R> {
        public R fromJson(ResourceLocation recipeId, JsonObject json) {
            JsonArray array = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
            for (JsonElement element : array) {
                ingredients.add(Ingredient.m_43917_((JsonElement)element));
            }
            FluidStackIngredient fluidIngredient = FluidStackIngredient.fromJson(GsonHelper.m_13930_((JsonObject)json, (String)"fluid_ingredient"));
            int duration = GsonHelper.m_13927_((JsonObject)json, (String)"duration");
            float minTemp = GsonHelper.m_13915_((JsonObject)json, (String)"temperature");
            return this.fromJson(recipeId, json, ingredients, fluidIngredient, duration, minTemp);
        }

        @Nullable
        public R fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int count = buffer.m_130242_();
            ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
            for (int i = 0; i < count; ++i) {
                ingredients.add(Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            FluidStackIngredient fluidIngredient = FluidStackIngredient.fromNetwork(buffer);
            int duration = buffer.m_130242_();
            float minTemp = buffer.readFloat();
            return this.fromNetwork(recipeId, buffer, ingredients, fluidIngredient, duration, minTemp);
        }

        public void toNetwork(FriendlyByteBuf buffer, R recipe) {
            buffer.m_130130_(((PotRecipe)recipe).itemIngredients.size());
            for (Ingredient ingredient : ((PotRecipe)recipe).itemIngredients) {
                ingredient.m_43923_(buffer);
            }
            ((PotRecipe)recipe).fluidIngredient.toNetwork(buffer);
            buffer.m_130130_(((PotRecipe)recipe).duration);
            buffer.writeFloat(((PotRecipe)recipe).minTemp);
        }

        protected abstract R fromJson(ResourceLocation var1, JsonObject var2, List<Ingredient> var3, FluidStackIngredient var4, int var5, float var6);

        protected abstract R fromNetwork(ResourceLocation var1, FriendlyByteBuf var2, List<Ingredient> var3, FluidStackIngredient var4, int var5, float var6);
    }
}

