/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import java.util.ArrayList;
import java.util.Random;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.entities.TFCFallingBlockEntity;
import net.dries007.tfc.common.recipes.SimpleBlockRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.ingredients.BlockIngredient;
import net.dries007.tfc.common.recipes.inventory.BlockInventory;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Support;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.dries007.tfc.util.events.CollapseEvent;
import net.dries007.tfc.util.tracker.Collapse;
import net.dries007.tfc.util.tracker.WorldTrackerCapability;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;

public class CollapseRecipe
extends SimpleBlockRecipe {
    public static final IndirectHashCollection<Block, CollapseRecipe> CACHE = IndirectHashCollection.createForRecipe(recipe -> recipe.getBlockIngredient().getValidBlocks(), TFCRecipeTypes.COLLAPSE);

    @Nullable
    public static CollapseRecipe getRecipe(Level world, BlockInventory wrapper) {
        for (CollapseRecipe recipe : CACHE.getAll(wrapper.getState().m_60734_())) {
            if (!recipe.matches(wrapper, world)) continue;
            return recipe;
        }
        return null;
    }

    public static boolean tryTriggerCollapse(Level level, BlockPos pos) {
        Random random = level.m_5822_();
        if (!level.m_5776_() && level.isAreaLoaded(pos, 32)) {
            boolean fakeCollapse;
            boolean realCollapse = (double)random.nextFloat() < (Double)TFCConfig.SERVER.collapseTriggerChance.get();
            boolean bl = fakeCollapse = !realCollapse && (double)random.nextFloat() < (Double)TFCConfig.SERVER.collapseFakeTriggerChance.get();
            if (realCollapse || fakeCollapse) {
                int radX = (random.nextInt(5) + 4) / 2;
                int radY = (random.nextInt(3) + 2) / 2;
                int radZ = (random.nextInt(5) + 4) / 2;
                ArrayList<BlockPos> fakeCollapseStarts = new ArrayList<BlockPos>();
                for (BlockPos checking : Support.findUnsupportedPositions((BlockGetter)level, pos.m_142082_(-radX, -radY, -radZ), pos.m_142082_(radX, radY, radZ))) {
                    if (checking.equals((Object)pos) || !CollapseRecipe.canStartCollapse((LevelAccessor)level, checking)) continue;
                    if (fakeCollapse) {
                        fakeCollapseStarts.add(checking.m_7949_());
                        continue;
                    }
                    if (CollapseRecipe.startCollapse(level, checking)) {
                        level.m_5594_(null, pos, (SoundEvent)TFCSounds.ROCK_SLIDE_LONG.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                    return true;
                }
                if (!fakeCollapseStarts.isEmpty()) {
                    level.m_5594_(null, pos, (SoundEvent)TFCSounds.ROCK_SLIDE_LONG_FAKE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    ArrayList<BlockPos> startsToDisplay = fakeCollapseStarts.size() < 4 ? fakeCollapseStarts : Helpers.uniqueRandomSample(fakeCollapseStarts, Math.min(12, 3 + random.nextInt(fakeCollapseStarts.size() - 3)), random);
                    MinecraftForge.EVENT_BUS.post((Event)new CollapseEvent(level, pos, startsToDisplay, 0.0, true));
                    for (BlockPos start : startsToDisplay) {
                        BlockState fakeStartState = level.m_8055_(start);
                        level.m_5898_(null, 2001, start, Block.m_49956_((BlockState)fakeStartState));
                    }
                    return false;
                }
            }
        }
        return false;
    }

    public static boolean canStartCollapse(LevelAccessor level, BlockPos pos) {
        BlockPos posBelow = pos.m_7495_();
        BlockState state = level.m_8055_(pos);
        BlockState stateBelow = level.m_8055_(posBelow);
        return Helpers.isBlock(state, TFCTags.Blocks.CAN_START_COLLAPSE) && (TFCFallingBlockEntity.canFallThrough((BlockGetter)level, posBelow, stateBelow, Direction.DOWN, state) || !stateBelow.m_60838_((BlockGetter)level, posBelow) || Helpers.isBlock(stateBelow, TFCTags.Blocks.NOT_SOLID_SUPPORTING));
    }

    public static boolean startCollapse(Level level, BlockPos centerPos) {
        Random random = level.m_5822_();
        int radius = (Integer)TFCConfig.SERVER.collapseMinRadius.get() + random.nextInt((Integer)TFCConfig.SERVER.collapseRadiusVariance.get());
        int radiusSquared = radius * radius;
        ArrayList<BlockPos> secondaryPositions = new ArrayList<BlockPos>();
        TerraFirmaCraft.LOGGER.info("Collapse started at pos {}, with the block column {} -> (start: {}) -> {}", new Object[]{centerPos, level.m_8055_(centerPos.m_7494_()), level.m_8055_(centerPos), level.m_8055_(centerPos.m_7495_())});
        block0: for (BlockPos pos : BlockPos.m_121940_((BlockPos)centerPos.m_142082_(-radius, -4, -radius), (BlockPos)centerPos.m_142082_(radius, -4, radius))) {
            boolean foundEmpty = false;
            for (int y = 0; y <= 8; ++y) {
                BlockPos posAt = pos.m_6630_(y);
                BlockState stateAt = level.m_8055_(posAt);
                if (foundEmpty && Helpers.isBlock(stateAt, TFCTags.Blocks.CAN_COLLAPSE) && posAt.m_123331_((Vec3i)centerPos) < (double)radiusSquared && (double)random.nextFloat() < (Double)TFCConfig.SERVER.collapsePropagateChance.get() && CollapseRecipe.collapseBlock(level, posAt, stateAt, true)) {
                    secondaryPositions.add(posAt.m_7494_());
                    continue block0;
                }
                foundEmpty = !stateAt.m_60838_((BlockGetter)level, posAt);
            }
        }
        if (!secondaryPositions.isEmpty()) {
            level.getCapability(WorldTrackerCapability.CAPABILITY).ifPresent(cap -> cap.addCollapseData(new Collapse(centerPos, secondaryPositions, radiusSquared)));
        }
        return !secondaryPositions.isEmpty();
    }

    public static boolean collapseBlock(Level level, BlockPos pos, BlockState state) {
        return CollapseRecipe.collapseBlock(level, pos, state, false);
    }

    public static boolean collapseBlock(Level level, BlockPos pos, BlockState state, boolean destroyBlockBelow) {
        BlockInventory wrapper = new BlockInventory(pos, state);
        CollapseRecipe recipe = CollapseRecipe.getRecipe(level, wrapper);
        if (recipe != null) {
            BlockPos posBelow = pos.m_7495_();
            if (destroyBlockBelow && !TFCFallingBlockEntity.canFallThrough((BlockGetter)level, posBelow, Direction.DOWN, Blocks.f_50752_.m_49966_())) {
                level.m_46961_(posBelow, true);
            }
            BlockState collapseState = recipe.getBlockCraftingResult(wrapper);
            level.m_46597_(pos, collapseState);
            level.m_7967_((Entity)new TFCFallingBlockEntity(level, (double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, collapseState, 2.0f, 20));
            return true;
        }
        return false;
    }

    CollapseRecipe(ResourceLocation id, BlockIngredient ingredient, BlockState outputState, boolean copyInputState) {
        super(id, ingredient, outputState, copyInputState);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TFCRecipeSerializers.COLLAPSE.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TFCRecipeTypes.COLLAPSE.get();
    }
}

