/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.dries007.tfc.common.capabilities.MoldLike;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.recipes.ISimpleRecipe;
import net.dries007.tfc.common.recipes.RecipeSerializerImpl;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.ingredients.FluidStackIngredient;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.util.JsonHelpers;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CastingRecipe
implements ISimpleRecipe<MoldLike> {
    public static final IndirectHashCollection<Item, CastingRecipe> CACHE = IndirectHashCollection.createForRecipe(recipe -> Arrays.stream(recipe.ingredient.m_43908_()).map(ItemStack::m_41720_).collect(Collectors.toList()), TFCRecipeTypes.CASTING);
    private final ResourceLocation id;
    private final Ingredient ingredient;
    private final FluidStackIngredient fluidIngredient;
    private final ItemStackProvider result;
    private final float breakChance;

    @Nullable
    public static CastingRecipe get(MoldLike mold) {
        for (CastingRecipe recipe : CACHE.getAll(mold.getContainer().m_41720_())) {
            if (!recipe.matches(mold, null)) continue;
            return recipe;
        }
        return null;
    }

    public CastingRecipe(ResourceLocation id, Ingredient ingredient, FluidStackIngredient fluidIngredient, ItemStackProvider result, float breakChance) {
        this.id = id;
        this.ingredient = ingredient;
        this.fluidIngredient = fluidIngredient;
        this.result = result;
        this.breakChance = breakChance;
    }

    public float getBreakChance() {
        return this.breakChance;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public FluidStackIngredient getFluidIngredient() {
        return this.fluidIngredient;
    }

    public boolean matches(MoldLike mold, @Nullable Level level) {
        return this.ingredient.test(mold.getContainer()) && this.fluidIngredient.test(mold.getFluidInTank(0));
    }

    public ItemStack assemble(MoldLike inventory) {
        ItemStack stack = this.result.getSingleStack(inventory.getContainer().m_41777_());
        stack.getCapability(HeatCapability.CAPABILITY).ifPresent(h -> h.setTemperatureIfWarmer(inventory.getTemperature()));
        return stack;
    }

    public ItemStack m_8043_() {
        return this.result.getEmptyStack();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TFCRecipeSerializers.CASTING.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TFCRecipeTypes.CASTING.get();
    }

    public static class Serializer
    extends RecipeSerializerImpl<CastingRecipe> {
        public CastingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)JsonHelpers.get(json, "mold"));
            FluidStackIngredient fluidIngredient = FluidStackIngredient.fromJson(JsonHelpers.m_13930_((JsonObject)json, (String)"fluid"));
            ItemStackProvider result = ItemStackProvider.fromJson(JsonHelpers.m_13930_((JsonObject)json, (String)"result"));
            float breakChance = JsonHelpers.m_13915_((JsonObject)json, (String)"break_chance");
            return new CastingRecipe(recipeId, ingredient, fluidIngredient, result, breakChance);
        }

        @Nullable
        public CastingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            FluidStackIngredient fluidIngredient = FluidStackIngredient.fromNetwork(buffer);
            ItemStackProvider result = ItemStackProvider.fromNetwork(buffer);
            float breakChance = buffer.readFloat();
            return new CastingRecipe(recipeId, ingredient, fluidIngredient, result, breakChance);
        }

        public void toNetwork(FriendlyByteBuf buffer, CastingRecipe recipe) {
            recipe.ingredient.m_43923_(buffer);
            recipe.fluidIngredient.toNetwork(buffer);
            recipe.result.toNetwork(buffer);
            buffer.writeFloat(recipe.breakChance);
        }
    }
}

