/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import net.dries007.tfc.common.blockentities.BarrelBlockEntity;
import net.dries007.tfc.common.blockentities.BarrelInventoryCallback;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.DelegateFluidHandler;
import net.dries007.tfc.common.capabilities.FluidTankCallback;
import net.dries007.tfc.common.container.ISlotCallback;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.items.TooltipBlockItem;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BarrelBlockItem
extends TooltipBlockItem {
    public BarrelBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        InteractionResult result = this.tryInteractWithFluid(level, player, hand);
        if (result != InteractionResult.PASS) {
            return new InteractionResultHolder(result, (Object)player.m_21120_(hand));
        }
        return super.m_7203_(level, player, hand);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        InteractionResult result;
        Player player = context.m_43723_();
        if (player != null && (result = this.tryInteractWithFluid(context.m_43725_(), player, context.m_43724_())) != InteractionResult.PASS) {
            return result;
        }
        return super.m_6225_(context);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new BarrelItemStackInventory(stack);
    }

    private InteractionResult tryInteractWithFluid(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        IFluidHandler handler = (IFluidHandler)Helpers.getCapability((ICapabilityProvider)stack, Capabilities.FLUID_ITEM);
        if (handler == null) {
            return InteractionResult.PASS;
        }
        BlockHitResult hit = Helpers.rayTracePlayer(level, player, ClipContext.Fluid.SOURCE_ONLY);
        if (FluidHelpers.transferBetweenWorldAndItem(stack, level, hit, player, hand, false, false, true)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return new ItemStack((ItemLike)this);
    }

    private static class BarrelItemStackInventory
    implements ICapabilityProvider,
    DelegateFluidHandler,
    IFluidHandlerItem,
    ISlotCallback,
    FluidTankCallback,
    BarrelInventoryCallback {
        private final LazyOptional<BarrelItemStackInventory> capability = LazyOptional.of(() -> this);
        private final ItemStack stack;
        private final BarrelBlockEntity.BarrelInventory inventory;
        private boolean hasActiveRecipe;

        BarrelItemStackInventory(ItemStack stack) {
            this.stack = stack;
            this.inventory = new BarrelBlockEntity.BarrelInventory(this);
            this.hasActiveRecipe = false;
            this.load();
        }

        @Override
        public boolean canModify() {
            return this.stack.m_41783_() == null || !this.hasActiveRecipe;
        }

        @Override
        public void fluidTankChanged() {
            this.save();
        }

        @Override
        public IFluidHandler getFluidHandler() {
            return this.inventory;
        }

        @NotNull
        public ItemStack getContainer() {
            return this.stack.m_41777_();
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            if (cap == Capabilities.FLUID_ITEM || cap == Capabilities.FLUID) {
                return this.capability.cast();
            }
            return LazyOptional.empty();
        }

        private void load() {
            CompoundTag tag = this.stack.m_41783_();
            if (tag != null && tag.m_128425_("BlockEntityTag", 10)) {
                CompoundTag blockEntityTag = tag.m_128469_("BlockEntityTag");
                this.hasActiveRecipe = blockEntityTag.m_128425_("recipe", 8);
                this.inventory.deserializeNBT(blockEntityTag.m_128469_("inventory"));
            }
        }

        private void save() {
            if (this.inventory.isInventoryEmpty()) {
                this.stack.m_41749_("BlockEntityTag");
            } else {
                this.stack.m_41698_("BlockEntityTag").m_128365_("inventory", (Tag)this.inventory.serializeNBT());
            }
        }
    }
}

