/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.fluids;

import java.awt.Color;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.fluids.Alcohol;
import net.dries007.tfc.common.fluids.FlowingFluidRegistryObject;
import net.dries007.tfc.common.fluids.FluidType;
import net.dries007.tfc.common.fluids.MixingFluid;
import net.dries007.tfc.common.fluids.MoltenFluid;
import net.dries007.tfc.common.fluids.RiverWaterFluid;
import net.dries007.tfc.common.fluids.SaltWaterAttributes;
import net.dries007.tfc.common.fluids.SimpleFluid;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.dries007.tfc.util.registry.RegistrationHelpers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public final class TFCFluids {
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"tfc");
    public static final ResourceLocation WATER_STILL = new ResourceLocation("block/water_still");
    public static final ResourceLocation WATER_FLOW = new ResourceLocation("block/water_flow");
    public static final ResourceLocation WATER_OVERLAY = new ResourceLocation("block/water_overlay");
    public static final ResourceLocation MOLTEN_STILL = Helpers.identifier("block/molten_still");
    public static final ResourceLocation MOLTEN_FLOW = Helpers.identifier("block/molten_flow");
    public static final int ALPHA_MASK = -16777216;
    public static final Map<Metal.Default, FlowingFluidRegistryObject<ForgeFlowingFluid>> METALS = Helpers.mapOfKeys(Metal.Default.class, metal -> TFCFluids.register("metal/" + metal.m_7912_(), "metal/flowing_" + metal.m_7912_(), properties -> properties.block((Supplier)TFCBlocks.METAL_FLUIDS.get(metal)).bucket((Supplier)TFCItems.FLUID_BUCKETS.get(FluidType.asType(metal))).explosionResistance(100.0f), FluidAttributes.builder((ResourceLocation)MOLTEN_STILL, (ResourceLocation)MOLTEN_FLOW).translationKey("fluid.tfc.metal." + metal.m_7912_()).color(0xFF000000 | metal.getColor()).rarity(metal.getRarity()).luminosity(15).density(3000).viscosity(6000).temperature(1300).sound(SoundEvents.f_11783_, SoundEvents.f_11780_), MoltenFluid.Source::new, MoltenFluid.Flowing::new));
    public static final FlowingFluidRegistryObject<ForgeFlowingFluid> SALT_WATER = TFCFluids.register("salt_water", "flowing_salt_water", properties -> properties.block(TFCBlocks.SALT_WATER).bucket((Supplier)TFCItems.FLUID_BUCKETS.get(FluidType.SALT_WATER)).canMultiply(), new FluidAttributes.Builder(WATER_STILL, WATER_FLOW, SaltWaterAttributes::new){}.translationKey("fluid.tfc.salt_water").overlay(WATER_OVERLAY).color(-12618012).sound(SoundEvents.f_11781_, SoundEvents.f_11778_), MixingFluid.Source::new, MixingFluid.Flowing::new);
    public static final FlowingFluidRegistryObject<ForgeFlowingFluid> SPRING_WATER = TFCFluids.register("spring_water", "flowing_spring_water", properties -> properties.block(TFCBlocks.SPRING_WATER).bucket((Supplier)TFCItems.FLUID_BUCKETS.get(FluidType.SPRING_WATER)).canMultiply(), FluidAttributes.builder((ResourceLocation)WATER_STILL, (ResourceLocation)WATER_FLOW).translationKey("fluid.tfc.spring_water").color(-11613225).overlay(WATER_OVERLAY).sound(SoundEvents.f_11781_, SoundEvents.f_11778_), MixingFluid.Source::new, MixingFluid.Flowing::new);
    public static final RegistryObject<RiverWaterFluid> RIVER_WATER = TFCFluids.register("river_water", RiverWaterFluid::new);
    public static final Map<SimpleFluid, FlowingFluidRegistryObject<ForgeFlowingFluid>> SIMPLE_FLUIDS = Helpers.mapOfKeys(SimpleFluid.class, fluid -> TFCFluids.register(fluid.getId(), "flowing_" + fluid.getId(), properties -> properties.block((Supplier)TFCBlocks.SIMPLE_FLUIDS.get(fluid)).bucket((Supplier)TFCItems.FLUID_BUCKETS.get(FluidType.asType(fluid))), FluidAttributes.builder((ResourceLocation)WATER_STILL, (ResourceLocation)WATER_FLOW).translationKey("fluid.tfc." + fluid.getId()).color(fluid.isTransparent() ? 0xFF000000 | fluid.getColor() : fluid.getColor()).overlay(WATER_OVERLAY).sound(SoundEvents.f_11781_, SoundEvents.f_11778_), MixingFluid.Source::new, MixingFluid.Flowing::new));
    public static final Map<Alcohol, FlowingFluidRegistryObject<ForgeFlowingFluid>> ALCOHOLS = Helpers.mapOfKeys(Alcohol.class, fluid -> TFCFluids.register(fluid.getId(), "flowing_" + fluid.getId(), properties -> properties.block((Supplier)TFCBlocks.ALCOHOLS.get(fluid)).bucket((Supplier)TFCItems.FLUID_BUCKETS.get(FluidType.asType(fluid))), FluidAttributes.builder((ResourceLocation)WATER_STILL, (ResourceLocation)WATER_FLOW).translationKey("fluid.tfc." + fluid.getId()).color(fluid.getColor()).overlay(WATER_OVERLAY).sound(SoundEvents.f_11781_, SoundEvents.f_11778_), MixingFluid.Source::new, MixingFluid.Flowing::new));
    public static final Map<DyeColor, FlowingFluidRegistryObject<ForgeFlowingFluid>> COLORED_FLUIDS = Helpers.mapOfKeys(DyeColor.class, color -> TFCFluids.register(color.m_41065_() + "_dye", "flowing_" + color.m_41065_() + "_dye", properties -> properties.block((Supplier)TFCBlocks.COLORED_FLUIDS.get(color)).bucket((Supplier)TFCItems.FLUID_BUCKETS.get(FluidType.asType(color))), FluidAttributes.builder((ResourceLocation)WATER_STILL, (ResourceLocation)WATER_FLOW).translationKey("fluid.tfc." + color.m_41065_() + "_dye").color(TFCFluids.dyeColorToInt(color)).overlay(WATER_OVERLAY).sound(SoundEvents.f_11781_, SoundEvents.f_11778_), MixingFluid.Source::new, MixingFluid.Flowing::new));

    public static int dyeColorToInt(DyeColor dye) {
        float[] colors = dye.m_41068_();
        return new Color(colors[0], colors[1], colors[2]).getRGB();
    }

    private static FlowingFluidRegistryObject<ForgeFlowingFluid> register(String sourceName, String flowingName, Consumer<ForgeFlowingFluid.Properties> builder, FluidAttributes.Builder attributes) {
        return RegistrationHelpers.registerFluid(FLUIDS, sourceName, flowingName, builder, attributes);
    }

    private static <F extends FlowingFluid> FlowingFluidRegistryObject<F> register(String sourceName, String flowingName, Consumer<ForgeFlowingFluid.Properties> builder, FluidAttributes.Builder attributes, Function<ForgeFlowingFluid.Properties, F> sourceFactory, Function<ForgeFlowingFluid.Properties, F> flowingFactory) {
        return RegistrationHelpers.registerFluid(FLUIDS, sourceName, flowingName, builder, attributes, sourceFactory, flowingFactory);
    }

    private static <F extends Fluid> RegistryObject<F> register(String name, Supplier<F> factory) {
        return FLUIDS.register(name, factory);
    }
}

