/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.fluids;

import net.dries007.tfc.common.blocks.RiverWaterBlock;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.fluids.FlowingFluidExtension;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.world.river.Flow;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.WaterFluid;
import net.minecraft.world.phys.Vec3;

public class RiverWaterFluid
extends WaterFluid
implements FlowingFluidExtension {
    public static final EnumProperty<Flow> FLOW = TFCBlockStateProperties.FLOW;

    private static boolean isSameAbove(FluidState fluid, BlockGetter level, BlockPos pos) {
        return fluid.m_76152_().m_6212_(level.m_6425_(pos.m_7494_()).m_76152_());
    }

    public boolean m_7444_(FluidState state) {
        return true;
    }

    public boolean m_6212_(Fluid fluid) {
        return super.m_6212_(fluid) || fluid == TFCFluids.RIVER_WATER.get();
    }

    public float m_6098_(FluidState fluid, BlockGetter level, BlockPos pos) {
        return RiverWaterFluid.isSameAbove(fluid, level, pos) ? 1.0f : this.m_7427_(fluid);
    }

    public BlockState m_5804_(FluidState state) {
        return (BlockState)((RiverWaterBlock)TFCBlocks.RIVER_WATER.get()).m_49966_().m_61124_(FLOW, (Comparable)((Object)((Flow)((Object)state.m_61143_(FLOW)))));
    }

    @Override
    public FluidState getSource(LevelReader level, BlockPos pos, boolean falling) {
        Flow flow = Flow.lerp(this.getFlowFromDirection(level, pos, Direction.NORTH), this.getFlowFromDirection(level, pos, Direction.EAST), this.getFlowFromDirection(level, pos, Direction.WEST), this.getFlowFromDirection(level, pos, Direction.SOUTH), 0.5f, 0.5f);
        if (flow == Flow.NONE) {
            return this.m_76068_(falling);
        }
        return (FluidState)((FluidState)((RiverWaterFluid)TFCFluids.RIVER_WATER.get()).m_76145_().m_61124_((Property)BlockStateProperties.f_61434_, (Comparable)Boolean.valueOf(falling))).m_61124_(FLOW, (Comparable)((Object)flow));
    }

    protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> builder) {
        super.m_7180_(builder.m_61104_(new Property[]{FLOW}));
    }

    public Vec3 m_7000_(BlockGetter level, BlockPos pos, FluidState fluid) {
        Flow flow = (Flow)((Object)fluid.m_61143_(FLOW));
        Vec3 vector = flow.getVector();
        if (((Boolean)fluid.m_61143_((Property)f_75947_)).booleanValue()) {
            BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                cursor.m_122159_((Vec3i)pos, direction);
                if (!this.m_75990_(level, (BlockPos)cursor, direction) && !this.m_75990_(level, cursor.m_7494_(), direction)) continue;
                vector = vector.m_82541_().m_82520_(0.0, -6.0, 0.0);
                break;
            }
        }
        return vector.m_82541_();
    }

    public int m_7430_(FluidState state) {
        return 8;
    }

    private Flow getFlowFromDirection(LevelReader level, BlockPos pos, Direction direction) {
        FluidState adjacentFluid = level.m_6425_(pos.m_142300_(direction));
        if (adjacentFluid.m_61138_(TFCBlockStateProperties.FLOW)) {
            return (Flow)((Object)adjacentFluid.m_61143_(TFCBlockStateProperties.FLOW));
        }
        return Flow.NONE;
    }
}

