/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.livestock;

import java.util.Locale;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.IFood;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.GenderedRenderAnimal;
import net.dries007.tfc.common.entities.livestock.CommonAnimalData;
import net.dries007.tfc.config.animals.AnimalConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.advancements.TFCAdvancements;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendar;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;

public interface TFCAnimalProperties
extends GenderedRenderAnimal {
    public static final long MATING_COOLDOWN_DEFAULT_TICKS = 24000L;
    public static final float READY_TO_MATE_FAMILIARITY = 0.3f;
    public static final float FAMILIARITY_DECAY_LIMIT = 0.3f;
    public static final float[] AGE_SCALES = (float[])Util.m_137537_(() -> {
        float[] scales = new float[32];
        for (int i = 0; i < scales.length; ++i) {
            scales[i] = Mth.m_184637_((float)(i + 1), (float)1.0f, (float)32.0f, (float)0.8f, (float)1.2f);
        }
        return scales;
    });

    default public LivingEntity getEntity() {
        return (LivingEntity)this;
    }

    default public ICalendar getCalendar() {
        return Calendars.get((LevelReader)this.getEntity().m_183503_());
    }

    private SynchedEntityData entityData() {
        return this.getEntity().m_20088_();
    }

    public CommonAnimalData animalData();

    public AnimalConfig animalConfig();

    public long getLastFamiliarityDecay();

    public void setLastFamiliarityDecay(long var1);

    public void setLastFed(long var1);

    public long getLastFed();

    public void setMated(long var1);

    public long getMated();

    public Age getLastAge();

    public void setLastAge(Age var1);

    default public boolean isHungry() {
        return this.getLastFed() < this.getCalendar().getTotalDays();
    }

    public TagKey<Item> getFoodTag();

    default public EntityType<?> getEntityTypeForBaby() {
        return this.getEntity().m_6095_();
    }

    default public void tickAnimalData() {
        Age age;
        float familiarity;
        if (this.getLastFamiliarityDecay() > -1L && this.getLastFamiliarityDecay() + 1L < this.getCalendar().getTotalDays() && (familiarity = this.getFamiliarity()) < 0.3f) {
            familiarity = (float)((double)familiarity - 0.02 * (double)(this.getCalendar().getTotalDays() - this.getLastFamiliarityDecay()));
            this.setLastFamiliarityDecay(this.getCalendar().getTotalDays());
            this.setFamiliarity(familiarity);
        }
        if ((age = this.getAgeType()) != this.getLastAge()) {
            this.setLastAge(age);
            this.getEntity().m_6210_();
        }
        if (!this.getEntity().f_19853_.f_46443_ && age == Age.ADULT && this.getUses() > this.getUsesToElderly() && this.getOldDay() == -1L) {
            long oldDay = this.getCalendar().getTotalDays() + 1L + (long)this.getEntity().m_21187_().nextInt(5);
            this.setOldDay(oldDay);
        }
    }

    default public InteractionResult mobInteract(Player player, InteractionHand hand) {
        Level level = player.f_19853_;
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_()) {
            if (stack.m_41720_() instanceof SpawnEggItem) {
                return InteractionResult.PASS;
            }
            if (this.isFood(stack)) {
                if (this.isHungry()) {
                    return this.eatFood(stack, hand, player);
                }
                if (!level.m_5776_()) {
                    this.showExtraClickInfo(player);
                }
                return InteractionResult.FAIL;
            }
        }
        return InteractionResult.PASS;
    }

    default public void showExtraClickInfo(Player player) {
    }

    default public InteractionResult eatFood(@Nonnull ItemStack stack, InteractionHand hand, Player player) {
        Level level = this.getEntity().f_19853_;
        this.getEntity().m_5634_(1.0f);
        if (!level.f_46443_) {
            long days = this.getCalendar().getTotalDays();
            this.setLastFed(days);
            this.setLastFamiliarityDecay(days);
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            if (this.getAgeType() == Age.CHILD || this.getFamiliarity() < this.getAdultFamiliarityCap()) {
                float familiarity = this.getFamiliarity() + 0.06f;
                if (this.getAgeType() != Age.CHILD) {
                    familiarity = Math.min(familiarity, this.getAdultFamiliarityCap());
                }
                this.setFamiliarity(familiarity);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    TFCAdvancements.FED_ANIMAL.trigger(serverPlayer, (Entity)this.getEntity());
                }
            }
            this.getEntity().m_5496_(this.eatingSound(stack), 1.0f, 1.0f);
        }
        return InteractionResult.SUCCESS;
    }

    default public SoundEvent eatingSound(ItemStack food) {
        return SoundEvents.f_12321_;
    }

    default public void registerCommonData() {
        this.entityData().m_135372_(this.animalData().gender(), (Object)true);
        this.entityData().m_135372_(this.animalData().birthday(), (Object)0L);
        this.entityData().m_135372_(this.animalData().familiarity(), (Object)Float.valueOf(0.0f));
        this.entityData().m_135372_(this.animalData().uses(), (Object)0);
        this.entityData().m_135372_(this.animalData().fertilized(), (Object)false);
        this.entityData().m_135372_(this.animalData().oldDay(), (Object)-1L);
        this.entityData().m_135372_(this.animalData().geneticSize(), (Object)16);
    }

    default public void saveCommonAnimalData(CompoundTag nbt) {
        nbt.m_128379_("gender", this.getGender().toBool());
        nbt.m_128356_("birth", this.getBirthDay());
        nbt.m_128379_("fertilized", this.isFertilized());
        nbt.m_128350_("familiarity", this.getFamiliarity());
        nbt.m_128405_("uses", this.getUses());
        nbt.m_128356_("fed", this.getLastFed());
        nbt.m_128356_("decay", this.getLastFamiliarityDecay());
        nbt.m_128356_("mating", this.getMated());
        nbt.m_128405_("lastAge", this.getLastAge().ordinal());
        nbt.m_128356_("oldDay", this.getOldDay());
        nbt.m_128405_("geneticSize", this.getGeneticSize());
    }

    default public void readCommonAnimalData(CompoundTag nbt) {
        this.setGender(Gender.valueOf(nbt.m_128471_("gender")));
        this.setBirthDay(nbt.m_128454_("birth"));
        this.setFertilized(nbt.m_128471_("fertilized"));
        this.setFamiliarity(nbt.m_128457_("familiarity"));
        this.setUses(nbt.m_128451_("uses"));
        this.setLastFed(nbt.m_128454_("fed"));
        this.setLastFamiliarityDecay(nbt.m_128454_("decay"));
        this.setMated(nbt.m_128454_("mating"));
        this.setLastAge(Age.valueOf(nbt.m_128451_("lastAge")));
        this.setOldDay(nbt.m_128454_("oldDay"));
        this.setGeneticSize(EntityHelpers.getIntOrDefault(nbt, "geneticSize", 16));
    }

    default public void initCommonAnimalData() {
        Random random = this.getEntity().m_21187_();
        this.setGender(Gender.valueOf(random.nextBoolean()));
        this.setBirthDay(EntityHelpers.getRandomGrowth((Entity)this.getEntity(), random, this.getDaysToAdulthood()));
        this.setFamiliarity(0.0f);
        this.setOldDay(-1L);
        this.setUses(0);
        this.setGeneticSize(Mth.m_14072_((Random)random, (int)4, (int)18));
        this.setFertilized(false);
        LivingEntity livingEntity = this.getEntity();
        if (livingEntity instanceof AgeableMob) {
            AgeableMob mob = (AgeableMob)livingEntity;
            mob.m_146762_(0);
        }
    }

    default public boolean isReadyToMate() {
        return this.getAgeType() == Age.ADULT && this.getFamiliarity() >= 0.3f && !this.isFertilized() && !this.isHungry() && this.getMated() + 24000L <= this.getCalendar().getTicks();
    }

    default public Gender getGender() {
        return Gender.valueOf((Boolean)this.entityData().m_135370_(this.animalData().gender()));
    }

    default public void setGender(Gender gender) {
        this.entityData().m_135381_(this.animalData().gender(), (Object)gender.toBool());
    }

    default public long getBirthDay() {
        return (Long)this.entityData().m_135370_(this.animalData().birthday());
    }

    default public void setBirthDay(long value) {
        this.entityData().m_135381_(this.animalData().birthday(), (Object)value);
    }

    default public long getOldDay() {
        return (Long)this.entityData().m_135370_(this.animalData().oldDay());
    }

    default public void setOldDay(long day) {
        this.entityData().m_135381_(this.animalData().oldDay(), (Object)day);
    }

    default public float getFamiliarity() {
        return ((Float)this.entityData().m_135370_(this.animalData().familiarity())).floatValue();
    }

    default public void setFamiliarity(float value) {
        this.entityData().m_135381_(this.animalData().familiarity(), (Object)Float.valueOf(Mth.m_14036_((float)value, (float)0.0f, (float)1.0f)));
    }

    default public int getGeneticSize() {
        return (Integer)this.entityData().m_135370_(this.animalData().geneticSize());
    }

    default public void setGeneticSize(int size) {
        this.entityData().m_135381_(this.animalData().geneticSize(), (Object)Mth.m_14045_((int)size, (int)1, (int)32));
    }

    default public float getAgeScale() {
        return AGE_SCALES[this.getGeneticSize() - 1];
    }

    default public void addUses(int uses) {
        this.setUses(this.getUses() + uses);
    }

    default public void setUses(int uses) {
        this.entityData().m_135381_(this.animalData().uses(), (Object)uses);
    }

    default public int getUses() {
        return (Integer)this.entityData().m_135370_(this.animalData().uses());
    }

    default public boolean isFertilized() {
        return (Boolean)this.entityData().m_135370_(this.animalData().fertilized());
    }

    default public void setFertilized(boolean value) {
        this.entityData().m_135381_(this.animalData().fertilized(), (Object)value);
    }

    default public void onFertilized(TFCAnimalProperties male) {
        this.setFertilized(true);
        this.setLastFed(this.getLastFed() - 1L);
        male.setLastFed(this.getLastFed() - 1L);
        male.addUses(5);
    }

    default public void setBabyTraits(TFCAnimalProperties baby) {
        baby.setGender(Gender.valueOf(this.getEntity().m_21187_().nextBoolean()));
        baby.setBirthDay(Calendars.SERVER.getTotalDays());
        baby.setFamiliarity(this.getFamiliarity() < 0.9f ? this.getFamiliarity() / 2.0f : this.getFamiliarity() * 0.9f);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    default public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob other) {
        if (other != this && this.getGender() == Gender.FEMALE && other instanceof TFCAnimalProperties) {
            TFCAnimalProperties otherFertile = (TFCAnimalProperties)other;
            if (!this.isFertilized()) {
                this.onFertilized(otherFertile);
                return null;
            }
        }
        if (other != this) return null;
        Entity baby = this.getEntityTypeForBaby().m_20615_((Level)level);
        if (!(baby instanceof TFCAnimalProperties)) return null;
        TFCAnimalProperties properties = (TFCAnimalProperties)baby;
        if (!(baby instanceof AgeableMob)) return null;
        AgeableMob ageable = (AgeableMob)baby;
        this.setBabyTraits(properties);
        return ageable;
    }

    default public boolean checkExtraBreedConditions(TFCAnimalProperties other) {
        return true;
    }

    default public Age getAgeType() {
        long totalDays = this.getCalendar().getTotalDays();
        long oldDay = this.getOldDay();
        if (oldDay != -1L && totalDays > oldDay) {
            return Age.OLD;
        }
        long adulthoodDays = totalDays - this.getBirthDay();
        if (adulthoodDays > (long)this.getDaysToAdulthood()) {
            return Age.ADULT;
        }
        return Age.CHILD;
    }

    default public float getAdultFamiliarityCap() {
        return ((Double)this.animalConfig().familiarityCap().get()).floatValue();
    }

    default public int getDaysToAdulthood() {
        return (Integer)this.animalConfig().adulthoodDays().get();
    }

    default public int getUsesToElderly() {
        return (Integer)this.animalConfig().uses().get();
    }

    default public boolean eatsRottenFood() {
        return (Boolean)this.animalConfig().eatsRottenFood().get();
    }

    default public boolean isReadyForAnimalProduct() {
        return false;
    }

    default public boolean hasProduct() {
        return false;
    }

    default public void setProductsCooldown() {
    }

    default public long getProductsCooldown() {
        return 0L;
    }

    @Override
    default public boolean displayMaleCharacteristics() {
        return !this.getEntity().m_6162_() && this.getGender() == Gender.MALE;
    }

    @Override
    default public boolean displayFemaleCharacteristics() {
        return !this.getEntity().m_6162_() && this.getGender() == Gender.FEMALE;
    }

    default public boolean isFood(ItemStack stack) {
        Optional rot;
        if (!this.eatsRottenFood() && (rot = stack.getCapability(FoodCapability.CAPABILITY).map(IFood::isRotten)).isPresent() && ((Boolean)rot.get()).booleanValue()) {
            return false;
        }
        return Helpers.isItem(stack, this.getFoodTag());
    }

    default public Component getGenderedTypeName() {
        return Helpers.translatable(this.getEntity().m_6095_().m_20675_() + "." + this.getGender().name().toLowerCase(Locale.ROOT));
    }

    default public MutableComponent getProductReadyName() {
        return Helpers.translatable("tfc.jade.product.generic");
    }

    public static enum Age {
        CHILD,
        ADULT,
        OLD;


        public static Age valueOf(int value) {
            return value == 0 ? CHILD : (value == 1 ? ADULT : OLD);
        }
    }

    public static enum Gender {
        MALE,
        FEMALE;


        public static Gender valueOf(boolean value) {
            return value ? MALE : FEMALE;
        }

        public boolean toBool() {
            return this == MALE;
        }
    }
}

