/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.livestock;

import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.entities.livestock.ProducingMammal;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.config.animals.ProducingMammalConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.events.AnimalProductEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public abstract class DairyAnimal
extends ProducingMammal {
    public DairyAnimal(EntityType<? extends DairyAnimal> animal, Level level, TFCSounds.EntitySound sounds, ProducingMammalConfig config) {
        super(animal, level, sounds, config);
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack held = player.m_21120_(hand);
        IFluidHandlerItem destFluidItemHandler = Helpers.getCapability((ICapabilityProvider)held, Capabilities.FLUID_ITEM);
        if (!held.m_41619_() && destFluidItemHandler != null) {
            if ((double)this.getFamiliarity() > (Double)this.produceFamiliarity.get() && this.isReadyForAnimalProduct()) {
                FluidStack milk = new FluidStack(this.getMilkFluid(), 1000);
                AnimalProductEvent event = new AnimalProductEvent(this.f_19853_, this.m_142538_(), player, (TFCAnimalProperties)this, milk, held, 1);
                if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
                    FluidTank sourceFluidHandler = new FluidTank(Integer.MAX_VALUE);
                    sourceFluidHandler.setFluid(event.getFluidProduct());
                    FluidHelpers.transferBetweenItemAndOther(held, destFluidItemHandler, (IFluidHandler)sourceFluidHandler, (IFluidHandler)destFluidItemHandler, sound -> player.m_5496_(SoundEvents.f_11833_, 1.0f, 1.0f), new FluidHelpers.AfterTransferWithPlayer(player, hand));
                    this.setProductsCooldown();
                    this.addUses(event.getUses());
                    return InteractionResult.SUCCESS;
                }
            } else {
                this.sendTooltip(this.f_19853_, player);
            }
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public boolean hasProduct() {
        return this.getGender() == TFCAnimalProperties.Gender.FEMALE && this.getAgeType() == TFCAnimalProperties.Age.ADULT && this.getProductsCooldown() == 0L;
    }

    private void sendTooltip(Level level, Player player) {
        TranslatableComponent component = null;
        if (this.getGender() == TFCAnimalProperties.Gender.MALE) {
            component = Helpers.translatable("tfc.tooltip.animal.male_milk", this.m_5677_().getString());
        } else if (this.getAgeType() == TFCAnimalProperties.Age.OLD) {
            component = Helpers.translatable("tfc.tooltip.animal.old", this.m_5677_().getString());
        } else if (this.getAgeType() == TFCAnimalProperties.Age.CHILD) {
            component = Helpers.translatable("tfc.tooltip.animal.young", this.m_5677_().getString());
        } else if ((double)this.getFamiliarity() <= (Double)this.produceFamiliarity.get()) {
            component = Helpers.translatable("tfc.tooltip.animal.low_familiarity", this.m_5677_().getString());
        } else if (!this.hasProduct()) {
            component = Helpers.translatable("tfc.tooltip.animal.no_milk", this.m_5677_().getString());
        }
        if (component != null && level.f_46443_) {
            player.m_5661_((Component)component, true);
        }
    }

    public Fluid getMilkFluid() {
        return (Fluid)ForgeMod.MILK.get();
    }

    @Override
    public MutableComponent getProductReadyName() {
        return Helpers.translatable("tfc.jade.product.milk");
    }
}

