/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.aquatic;

import java.util.function.Predicate;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.entities.AnimationState;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.ai.TFCAvoidEntityGoal;
import net.dries007.tfc.common.entities.aquatic.AquaticMob;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.util.Helpers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class AquaticCritter
extends WaterAnimal
implements AquaticMob {
    public final AnimationState swimmingAnimation = new AnimationState();
    private final Predicate<Fluid> fluidTest;

    public static AquaticCritter salty(EntityType<? extends WaterAnimal> type, Level level) {
        return new AquaticCritter(type, level, true);
    }

    public static AquaticCritter fresh(EntityType<? extends WaterAnimal> type, Level level) {
        return new AquaticCritter(type, level, false);
    }

    public AquaticCritter(EntityType<? extends WaterAnimal> type, Level level, boolean salty) {
        super(type, level);
        this.fluidTest = salty ? f -> f.m_6212_((Fluid)TFCFluids.SALT_WATER.getSource()) : f -> f.m_6212_((Fluid)Fluids.f_76193_);
    }

    public void m_8119_() {
        if (this.f_19853_.f_46443_) {
            EntityHelpers.startOrStop(this.swimmingAnimation, !this.f_19861_, this.f_19797_);
        }
        super.m_8119_();
    }

    public void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, new CritterEscapeGoal<Player>((PathfinderMob)this, Player.class, 8.0f, 2.0, 2.0));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, WaterAnimal.class, 8.0f, 5.0, (double)5.4f, e -> Helpers.isEntity((Entity)e, TFCTags.Entities.OCEAN_PREDATORS)));
        this.f_21345_.m_25352_(3, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 30));
    }

    @Override
    public boolean canSpawnIn(Fluid fluid) {
        return this.fluidTest.test(fluid);
    }

    protected PathNavigation m_6037_(Level pLevel) {
        return new WaterBoundPathNavigation((Mob)this, pLevel);
    }

    static class CritterEscapeGoal<T extends LivingEntity>
    extends TFCAvoidEntityGoal<T> {
        public CritterEscapeGoal(PathfinderMob mob, Class<T> avoidClass, float maxDist, double walkSpeedModifier, double sprintSpeedModifier) {
            super(mob, avoidClass, maxDist, walkSpeedModifier, sprintSpeedModifier);
        }

        public boolean shouldEscape() {
            return this.f_25015_.m_142581_() != null;
        }

        @Override
        public boolean m_8036_() {
            return this.shouldEscape() && super.m_8036_();
        }

        @Override
        public boolean m_8045_() {
            return this.f_25016_ != null && (!this.f_25019_.m_26571_() || this.f_25015_.m_20280_((Entity)this.f_25016_) > 49.0);
        }
    }
}

