/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai.livestock;

import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import net.dries007.tfc.common.entities.Temptable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class DelegatingTemptingSensor
extends Sensor<PathfinderMob> {
    public static final int TEMPTATION_RANGE = 10;
    private static final TargetingConditions TEMPT_TARGETING = TargetingConditions.m_148353_().m_26883_(10.0).m_148355_();

    protected void doTick(ServerLevel level, PathfinderMob animal) {
        Brain brain = animal.m_6274_();
        List<ServerPlayer> list = level.m_6907_().stream().filter(EntitySelector.f_20408_).filter(p -> TEMPT_TARGETING.m_26885_((LivingEntity)animal, (LivingEntity)p)).filter(p -> animal.m_19950_((Entity)p, 10.0)).filter(p -> this.playerHoldingTemptation((Player)p, animal)).sorted(Comparator.comparingDouble(arg_0 -> ((PathfinderMob)animal).m_20280_(arg_0))).toList();
        if (!list.isEmpty()) {
            Player player = (Player)list.get(0);
            brain.m_21879_(MemoryModuleType.f_148196_, (Object)player);
        } else {
            brain.m_21936_(MemoryModuleType.f_148196_);
        }
    }

    private boolean playerHoldingTemptation(Player player, PathfinderMob animal) {
        return this.isTemptation(player.m_21205_(), animal) || this.isTemptation(player.m_21206_(), animal);
    }

    private boolean isTemptation(ItemStack stack, PathfinderMob animal) {
        Temptable temptable;
        return animal instanceof Temptable && (temptable = (Temptable)animal).isFood(stack);
    }

    public Set<MemoryModuleType<?>> m_7163_() {
        return ImmutableSet.of((Object)MemoryModuleType.f_148196_);
    }
}

