/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai.amphibian;

import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.TryFindWater;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;

public class TryFindWaterBehavior
extends TryFindWater {
    private final int range;
    private final float speedModifier;
    private long nextStartTick;

    public TryFindWaterBehavior(int range, float speedModifier) {
        super(range, speedModifier);
        this.range = range;
        this.speedModifier = speedModifier;
    }

    protected void m_6732_(ServerLevel level, PathfinderMob entity, long gameTime) {
        this.nextStartTick = gameTime + 20L + 2L;
    }

    protected boolean m_6114_(ServerLevel level, PathfinderMob entity) {
        return !entity.f_19853_.m_6425_(entity.m_142538_()).m_205070_(FluidTags.f_13131_);
    }

    protected void m_6735_(ServerLevel level, PathfinderMob entity, long gameTime) {
        if (gameTime >= this.nextStartTick) {
            BlockPos waterPos = null;
            BlockPos notPreferredWaterPos = null;
            BlockPos entityPos = entity.m_142538_();
            for (BlockPos pos : BlockPos.m_121925_((BlockPos)entityPos, (int)this.range, (int)this.range, (int)this.range)) {
                if (pos.m_123341_() == entityPos.m_123341_() && pos.m_123343_() == entityPos.m_123343_()) continue;
                BlockState aboveState = entity.f_19853_.m_8055_(pos.m_7494_());
                BlockState state = entity.f_19853_.m_8055_(pos);
                if (!Helpers.isFluid(state.m_60819_(), (TagKey<Fluid>)FluidTags.f_13131_)) continue;
                if (aboveState.m_60795_()) {
                    waterPos = pos.m_7949_();
                    break;
                }
                if (notPreferredWaterPos != null || pos.m_203195_((Position)entity.m_20182_(), 1.5)) continue;
                notPreferredWaterPos = pos.m_7949_();
            }
            if (waterPos == null) {
                waterPos = notPreferredWaterPos;
            }
            if (waterPos != null) {
                this.nextStartTick = gameTime + 40L;
                BehaviorUtils.m_22617_((LivingEntity)entity, waterPos, (float)this.speedModifier, (int)0);
            }
        }
    }
}

