/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities;

import java.util.function.IntConsumer;
import net.dries007.tfc.common.blockentities.PowderkegBlockEntity;
import net.dries007.tfc.common.blocks.devices.PowderkegBlock;
import net.dries007.tfc.common.blocks.devices.SealableDeviceBlock;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.TFCEntities;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.PowderKegExplosion;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HoldingMinecart
extends AbstractMinecart {
    public static final EntityDataAccessor<ItemStack> DATA_HOLD_ITEM = SynchedEntityData.m_135353_(HoldingMinecart.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private int fuse = -1;

    public static void copyMinecart(AbstractMinecart oldCart, AbstractMinecart newCart) {
        newCart.m_146922_(oldCart.m_146908_());
        newCart.m_146926_(oldCart.m_146909_());
        newCart.m_20256_(oldCart.m_20184_());
        if (oldCart.m_8077_()) {
            newCart.m_6593_(oldCart.m_7770_());
        }
    }

    public HoldingMinecart(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public HoldingMinecart(Level level, double x, double y, double z) {
        super((EntityType)TFCEntities.HOLDING_MINECART.get(), level, x, y, z);
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (player.m_36341_() && player.m_6144_() && !this.f_19853_.f_46443_) {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.m_142340_());
            this.setHoldItem(ItemStack.f_41583_);
            Minecart minecart = new Minecart(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
            HoldingMinecart.copyMinecart(this, (AbstractMinecart)minecart);
            this.m_146870_();
            this.f_19853_.m_7967_((Entity)minecart);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public AbstractMinecart.Type m_6064_() {
        return AbstractMinecart.Type.CHEST;
    }

    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128365_("holdItem", (Tag)this.getHoldItem().m_41739_(new CompoundTag()));
        tag.m_128405_("TNTFuse", this.fuse);
    }

    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setHoldItem(ItemStack.m_41712_((CompoundTag)tag.m_128469_("holdItem")));
        this.fuse = EntityHelpers.getIntOrDefault(tag, "TNTFuse", -1);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_HOLD_ITEM, (Object)ItemStack.f_41583_);
    }

    public ItemStack getHoldItem() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_HOLD_ITEM);
    }

    public void setHoldItem(ItemStack item) {
        this.f_19804_.m_135381_(DATA_HOLD_ITEM, (Object)item.m_41777_());
    }

    @NotNull
    public ItemStack m_142340_() {
        return ((ItemStack)this.f_19804_.m_135370_(DATA_HOLD_ITEM)).m_41777_();
    }

    public BlockState m_38178_() {
        Item item = this.getHoldItem().m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            BlockState state = blockItem.m_40614_().m_49966_();
            if (state.m_61138_((Property)SealableDeviceBlock.SEALED) && this.getHoldItem().m_41782_()) {
                state = (BlockState)state.m_61124_((Property)SealableDeviceBlock.SEALED, (Comparable)Boolean.valueOf(true));
            }
            if (state.m_60734_() instanceof PowderkegBlock && this.isPrimed()) {
                state = (BlockState)state.m_61124_((Property)PowderkegBlock.LIT, (Comparable)Boolean.valueOf(true));
            }
            return state;
        }
        return Blocks.f_50016_.m_49966_();
    }

    public void m_7617_(DamageSource source) {
        super.m_7617_(source);
        if ((source.m_19384_() || source.m_19372_()) && this.ifPowderkeg(this::explode)) {
            return;
        }
        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
            this.m_19983_(this.getHoldItem().m_41777_());
        }
    }

    public boolean m_38184_() {
        return true;
    }

    @Nullable
    public ItemEntity m_19998_(ItemLike item) {
        if (item == Blocks.f_50087_) {
            return null;
        }
        return super.m_19998_(item);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_142535_(float distance, float multiplier, DamageSource source) {
        if (distance >= 3.0f) {
            this.ifPowderkeg(this::explode);
        }
        return super.m_142535_(distance, multiplier, source);
    }

    public void m_6025_(int x, int y, int z, boolean powered) {
        if (powered && this.fuse < 0) {
            this.primeFuse();
        }
    }

    public void m_7822_(byte id) {
        if (id == 10) {
            this.primeFuse();
        } else {
            super.m_7822_(id);
        }
    }

    public void primeFuse() {
        this.ifPowderkeg(str -> {
            this.fuse = 80;
            if (!this.f_19853_.f_46443_) {
                this.f_19853_.m_7605_((Entity)this, (byte)10);
                if (!this.m_20067_()) {
                    this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12512_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            }
        });
    }

    public boolean isPrimed() {
        return this.fuse > -1;
    }

    public void m_8119_() {
        super.m_8119_();
        this.ifPowderkeg(strength -> {
            double delta;
            if (this.fuse > 0) {
                --this.fuse;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 0.0, 0.0, 0.0);
            } else if (this.fuse == 0) {
                this.explode(strength);
            }
            if (this.f_19862_ && (delta = this.m_20184_().m_165925_()) >= (double)0.01f) {
                this.explode(strength);
            }
        });
    }

    public boolean m_6469_(DamageSource source, float amount) {
        AbstractArrow arrow;
        Entity entity = source.m_7640_();
        if (entity instanceof AbstractArrow && (arrow = (AbstractArrow)entity).m_6060_()) {
            this.ifPowderkeg(this::explode);
        }
        return super.m_6469_(source, amount);
    }

    protected void explode(int strength) {
        if (!this.f_19853_.f_46443_) {
            PowderKegExplosion explosion = new PowderKegExplosion(this.f_19853_, null, this.m_20185_(), this.m_20186_(), this.m_20189_(), strength);
            explosion.m_46061_();
            explosion.m_46075_(true);
            this.m_146870_();
        }
    }

    public boolean ifPowderkeg(IntConsumer toRun) {
        if (!((Boolean)TFCConfig.SERVER.powderKegEnabled.get()).booleanValue()) {
            return false;
        }
        int str = this.getPowderkegStrength();
        if (str != 0) {
            toRun.accept(str);
            return true;
        }
        return false;
    }

    public int getPowderkegStrength() {
        CompoundTag tag;
        BlockItem bi;
        ItemStack stack = this.getHoldItem();
        Item item = stack.m_41720_();
        if (item instanceof BlockItem && (bi = (BlockItem)item).m_40614_() instanceof PowderkegBlock && stack.m_41782_() && (tag = stack.m_41737_("BlockEntityTag")) != null) {
            CompoundTag inventoryTag = tag.m_128469_("inventory");
            ItemStackHandler inventory = new ItemStackHandler();
            inventory.deserializeNBT(inventoryTag.m_128469_("inventory"));
            return PowderkegBlockEntity.getStrength((IItemHandler)inventory);
        }
        return 0;
    }
}

