/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.container;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.PotBlockEntity;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.container.BlockEntityContainer;
import net.dries007.tfc.common.container.CallbackSlot;
import net.dries007.tfc.common.container.Container;
import net.dries007.tfc.common.container.TFCContainerTypes;
import net.dries007.tfc.util.Helpers;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class PotContainer
extends BlockEntityContainer<PotBlockEntity> {
    public static PotContainer create(PotBlockEntity pot, Inventory playerInv, int windowId) {
        return (PotContainer)((Object)new PotContainer(pot, windowId).init(playerInv, 20));
    }

    private PotContainer(PotBlockEntity pot, int windowId) {
        super((MenuType)TFCContainerTypes.POT.get(), windowId, pot);
        this.m_38884_(pot.getSyncableData());
    }

    @Override
    protected boolean moveStack(ItemStack stack, int slotIndex) {
        return switch (this.typeOf(slotIndex)) {
            default -> throw new IncompatibleClassChangeError();
            case Container.IndexType.MAIN_INVENTORY, Container.IndexType.HOTBAR -> {
                if (Helpers.isItem(stack, TFCTags.Items.FIREPIT_FUEL)) {
                    if (!this.m_38903_(stack, 0, 4, false)) {
                        yield true;
                    }
                    yield false;
                }
                if (!this.m_38903_(stack, 4, 9, false)) {
                    yield true;
                }
                yield false;
            }
            case Container.IndexType.CONTAINER -> !this.m_38903_(stack, this.containerSlots, this.f_38839_.size(), false);
        };
    }

    @Override
    protected void addContainerSlots() {
        ((PotBlockEntity)this.blockEntity).getCapability(Capabilities.ITEM).ifPresent(handler -> {
            int i;
            for (i = 0; i < 4; ++i) {
                this.m_38897_((Slot)new CallbackSlot(this.blockEntity, (IItemHandler)handler, i, 8, 70 - 18 * i));
            }
            for (i = 4; i <= 8; ++i) {
                this.m_38897_((Slot)new CallbackSlot(this.blockEntity, (IItemHandler)handler, i, 62 + (i - 4) * 18, 20));
            }
        });
    }
}

