/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.container;

import java.util.function.Consumer;
import net.dries007.tfc.common.container.ItemStackContainer;
import net.dries007.tfc.util.Helpers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ItemStackContainerProvider {
    private final ItemStackContainer.Factory<? extends ItemStackContainer> factory;
    @Nullable
    private final Component name;

    public static Consumer<FriendlyByteBuf> write(InteractionHand hand) {
        return buffer -> buffer.writeBoolean(hand == InteractionHand.MAIN_HAND);
    }

    public ItemStackContainerProvider(ItemStackContainer.Factory<? extends ItemStackContainer> factory) {
        this(factory, null);
    }

    public ItemStackContainerProvider(ItemStackContainer.Factory<? extends ItemStackContainer> factory, @Nullable Component name) {
        this.factory = factory;
        this.name = name;
    }

    public void openScreen(ServerPlayer player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        int encodedSlot = hand == InteractionHand.OFF_HAND ? -1 : player.m_150109_().f_35977_;
        SimpleMenuProvider provider = new SimpleMenuProvider((windowId, playerInventory, playerIn) -> this.factory.create(stack, hand, encodedSlot, playerInventory, windowId), this.name == null ? stack.m_41786_() : this.name);
        Helpers.openScreen(player, (MenuProvider)provider, buffer -> buffer.writeByte(encodedSlot));
    }
}

